/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.hm.efn.gameasset.animations.EFNShortSwordAnimations;
import com.hm.efn.gameasset.combos.Shortsword;
import com.hm.efn.registries.EFNDataKey;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.eventlistener.DealDamageEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ShortSwordInnate
extends ComboBasicAttack {
    private static final UUID DODGE_TRIGGER_UUID = UUID.fromString("e5f6a1b2-c8d1-11ed-a51b-0242ac121029");
    private static final UUID DAMAGE_LISTENER_UUID = UUID.fromString("f6e7b2c3-d9e2-12fd-b52c-1352bd232130");
    private static final UUID DAMAGE_ADDER_UUID = UUID.fromString("f6e7b2c3-d9e2-12fd-b52c-1352bd602102");

    public ShortSwordInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        SkillDataManager data = container.getDataManager();
        PlayerEventListener listener = container.getExecutor().getEventListener();
        this.registerKeyData(data);
        data.registerData(EFNDataKey.DAMAGE_HISTORY.get());
        data.registerData(EFNDataKey.REPLAY_ENHANCED.get());
        data.registerData(EFNDataKey.IS_REPLAY_DAMAGE.get());
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_TRIGGER_UUID, event -> {
            ServerPlayerPatch playerPatch;
            ServerPlayer player;
            PlayerPatch patt2928$temp;
            if (event.getSkillContainer().getSkill() instanceof DodgeSkill && (patt2928$temp = container.getExecutor()) instanceof ServerPlayerPatch && this.isHoldingSword(player = (ServerPlayer)(playerPatch = (ServerPlayerPatch)patt2928$temp).getOriginal())) {
                player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(Shortsword.DodgeCounter));
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, DAMAGE_ADDER_UUID, event -> {
            ServerPlayerPatch serverPlayerPatch;
            ServerPlayer player;
            PlayerPatch patt3595$temp = container.getExecutor();
            if (patt3595$temp instanceof ServerPlayerPatch && this.isHoldingSword(player = (ServerPlayer)(serverPlayerPatch = (ServerPlayerPatch)patt3595$temp).getOriginal()) && event.getAttackDamage() > 0.0f) {
                this.recordDamage(container, event.getAttackDamage(), player.f_19797_);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, DAMAGE_LISTENER_UUID, event -> {
            ServerPlayerPatch serverPlayerPatch;
            ServerPlayer player;
            PlayerPatch patt4198$temp = container.getExecutor();
            if (patt4198$temp instanceof ServerPlayerPatch && this.isHoldingSword(player = (ServerPlayer)(serverPlayerPatch = (ServerPlayerPatch)patt4198$temp).getOriginal()) && event.getAttackDamage() > 0.0f && this.shouldApplyReplayBonus(serverPlayerPatch)) {
                this.applyReplayBonus(container, (DealDamageEvent.Attack)event, player.f_19797_);
            }
        });
    }

    private void registerKeyData(SkillDataManager data) {
        data.registerData(EFNDataKey.KEY1_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY2_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY3_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY4_LONG_PRESS.get());
        data.registerData(EFNDataKey.INNATE_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY1_PRESS.get());
        data.registerData(EFNDataKey.KEY2_PRESS.get());
        data.registerData(EFNDataKey.KEY3_PRESS.get());
        data.registerData(EFNDataKey.KEY4_PRESS.get());
        data.registerData(EFNDataKey.INNATE_PRESS.get());
        data.registerData(EFNDataKey.KEY1_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY2_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY3_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY4_PRESS_TIMER.get());
        data.registerData(EFNDataKey.INNATE_PRESS_TIMER.get());
        data.registerData(EFNDataKey.COMBO_COUNTER.get());
        data.registerData(EFNDataKey.ANGEL_KEY.get());
        data.registerData(EFNDataKey.DEMON_KEY.get());
        data.registerData(EFNDataKey.JUMP_KEY.get());
        data.registerData(EFNDataKey.SNEAK_KEY.get());
        data.registerData(EFNDataKey.UP_KEY.get());
        data.registerData(EFNDataKey.DOWN_KEY.get());
    }

    private void recordDamage(SkillContainer container, float damage, int currentTick) {
        SkillDataManager data = container.getDataManager();
        Boolean isReplayDamage = (Boolean)data.getDataValue(EFNDataKey.IS_REPLAY_DAMAGE.get());
        if (Boolean.TRUE.equals(isReplayDamage)) {
            data.setData(EFNDataKey.IS_REPLAY_DAMAGE.get(), (Object)false);
            return;
        }
        ArrayList<EFNDataKey.DamageRecord> history = new ArrayList<EFNDataKey.DamageRecord>((Collection)data.getDataValue(EFNDataKey.DAMAGE_HISTORY.get()));
        if (!history.isEmpty()) {
            this.cleanupExpiredRecords(history, currentTick);
        }
        history.add(new EFNDataKey.DamageRecord(damage, currentTick));
        data.setDataSync(EFNDataKey.DAMAGE_HISTORY.get(), history, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
    }

    private void cleanupExpiredRecords(List<EFNDataKey.DamageRecord> history, int currentTick) {
        int beforeSize = history.size();
        history.removeIf(record -> record.isExpired(currentTick));
    }

    private boolean shouldApplyReplayBonus(ServerPlayerPatch playerPatch) {
        if (playerPatch == null || playerPatch.getOriginal() == null) {
            return false;
        }
        boolean hasReplayEffect = ((ServerPlayer)playerPatch.getOriginal()).m_21023_((MobEffect)EFNMobEffectRegistry.REPLAY.get());
        boolean alreadyEnhanced = (Boolean)playerPatch.getSkill((Skill)this).getDataManager().getDataValue(EFNDataKey.REPLAY_ENHANCED.get());
        return hasReplayEffect && !alreadyEnhanced;
    }

    private void applyReplayBonus(SkillContainer container, DealDamageEvent.Attack event, int currentTick) {
        SkillDataManager data = container.getDataManager();
        ArrayList<EFNDataKey.DamageRecord> history = new ArrayList<EFNDataKey.DamageRecord>((Collection)data.getDataValue(EFNDataKey.DAMAGE_HISTORY.get()));
        if (history.isEmpty()) {
            return;
        }
        EFNDataKey.DamageRecord lastRecord = (EFNDataKey.DamageRecord)history.get(history.size() - 1);
        float bonusDamage = lastRecord.damage();
        int recordTimestamp = lastRecord.timestamp();
        if (new EFNDataKey.DamageRecord(0.0f, recordTimestamp).isExpired(currentTick)) {
            this.cleanupExpiredRecords(history, currentTick);
            data.setDataSync(EFNDataKey.DAMAGE_HISTORY.get(), history, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
            return;
        }
        this.cleanupExpiredRecords(history, currentTick);
        data.setData(EFNDataKey.IS_REPLAY_DAMAGE.get(), (Object)true);
        EpicFightDamageSource damageSource = event.getDamageSource();
        float originalDamage = event.getAttackDamage();
        damageSource.attachDamageModifier(ValueModifier.adder((float)bonusDamage));
        damageSource.attachArmorNegationModifier(ValueModifier.setter((float)100.0f));
        data.setDataSync(EFNDataKey.REPLAY_ENHANCED.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
        ServerPlayer player = (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal();
        if (player.m_21023_((MobEffect)EFNMobEffectRegistry.REPLAY.get())) {
            player.m_21195_((MobEffect)EFNMobEffectRegistry.REPLAY.get());
        }
        data.setDataSync(EFNDataKey.DAMAGE_HISTORY.get(), history, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            PlayerPatch playerPatch;
            if (container.getExecutor().getTickSinceLastAction() > 9) {
                this.resetCombo(container, (PlayerPatch)container.getServerExecutor(), this.root);
            }
            if ((playerPatch = container.getExecutor()) instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
                SkillDataManager manager = container.getDataManager();
                PlayerPatch executor = container.getExecutor();
                if (manager.hasData(EFNDataKey.COMBO_COUNTER.get())) {
                    float current = ((Float)manager.getDataValue(EFNDataKey.COMBO_COUNTER.get())).floatValue();
                    if (current < 1.0f) {
                        float newValue = current + 0.05f;
                        manager.setDataSync(EFNDataKey.COMBO_COUNTER.get(), (Object)Float.valueOf(newValue), (ServerPlayer)serverPlayerPatch.getOriginal());
                    } else {
                        manager.setDataSync(EFNDataKey.COMBO_COUNTER.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)serverPlayerPatch.getOriginal());
                    }
                }
                if (((Boolean)manager.getDataValue(EFNDataKey.KEY3_PRESS.get())).booleanValue()) {
                    boolean hasEnergy;
                    ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
                    SkillContainer weaponInnate = container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                    boolean bl = hasEnergy = weaponInnate != null && (weaponInnate.getStack() >= 1 || player.m_150110_().f_35937_);
                    if (hasEnergy) {
                        MobEffectInstance replayEffect = new MobEffectInstance((MobEffect)EFNMobEffectRegistry.REPLAY.get(), 100, 0, false, false, false);
                        if (!executor.getEntityState().inaction()) {
                            serverPlayerPatch.playAnimationSynchronized(EFNShortSwordAnimations.NF_SHORTSWORD_SKILL, 0.05f);
                        }
                        serverPlayerPatch.playSound((SoundEvent)SoundEvents.f_12377_.get(), 1.0f, 1.0f);
                        player.m_7292_(replayEffect);
                        if (!player.m_150110_().f_35937_) {
                            weaponInnate.getSkill().setStackSynchronize(weaponInnate, weaponInnate.getStack() - 1);
                        }
                    } else {
                        serverPlayerPatch.playSound(SoundEvents.f_12374_, 0.5f, 1.0f);
                    }
                    manager.setDataSync(EFNDataKey.KEY3_PRESS.get(), (Object)false, player);
                }
                if (manager.hasData(EFNDataKey.REPLAY_ENHANCED.get()) && !((ServerPlayer)serverPlayerPatch.getOriginal()).m_21023_((MobEffect)EFNMobEffectRegistry.REPLAY.get())) {
                    manager.setDataSync(EFNDataKey.REPLAY_ENHANCED.get(), (Object)false, (ServerPlayer)serverPlayerPatch.getOriginal());
                }
            }
        }
    }

    private void handleClientInput(SkillContainer container) {
        LocalPlayer player = (LocalPlayer)container.getExecutor().getOriginal();
        SkillDataManager data = container.getDataManager();
        if (InvincibleKeyMappings.KEY3.m_90857_()) {
            boolean hasEnergy;
            SkillContainer weaponInnate = container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
            boolean bl = hasEnergy = weaponInnate != null && (weaponInnate.getStack() >= 1 || player.m_150110_().f_35937_);
            if (hasEnergy) {
                data.setDataSync(EFNDataKey.KEY3_PRESS.get(), (Object)true, player);
            }
            InvincibleKeyMappings.KEY3.m_7249_(false);
        }
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_TRIGGER_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, DAMAGE_LISTENER_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, DAMAGE_ADDER_UUID);
    }

    private boolean isHoldingSword(ServerPlayer player) {
        return Stream.of(player.m_21205_(), player.m_21206_()).map(EpicFightCapabilities::getItemStackCapability).filter(Objects::nonNull).anyMatch(cap -> cap.getWeaponCategory() == CapabilityItem.WeaponCategories.SWORD);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        list.add(Component.m_237115_((String)"skill.efn.shortsword.tooltip").m_130940_(ChatFormatting.GRAY));
        list.add(Component.m_237115_((String)"skill.efn.shortsword.tooltip1").m_130940_(ChatFormatting.GRAY).m_7220_(InvincibleKeyMappings.KEY3.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.shortsword.tooltip2"));
        return list;
    }
}

