/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.hm.efn.client.input.keymapping.EFNKeyMappings;
import com.hm.efn.client.sound.EFNSounds;
import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.hm.efn.entity.effect.SinSummonedSwordEntity.SinSummonedSwordEntity;
import com.hm.efn.gameasset.animations.EFNYamatoAnimations;
import com.hm.efn.registries.EFNDataKey;
import com.merlin204.avalon.epicfight.animations.AvalonAttackAnimation;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class YamatoInnate
extends ComboBasicAttack {
    private static final AnimationManager.AnimationAccessor<? extends AvalonAttackAnimation> JUDGECUT_ANIM = EFNYamatoAnimations.YAMATO_JUDEMENCUT_ALL;
    private static final AnimationManager.AnimationAccessor<? extends AvalonAttackAnimation> QUICK_ANIM = EFNYamatoAnimations.YAMATO_JUDEMENCUT;
    private static final AnimationManager.AnimationAccessor<? extends AvalonAttackAnimation> JUST_ANIM = EFNYamatoAnimations.YAMATO_JUDEMENCUT_JUST;
    private static final AnimationManager.AnimationAccessor<? extends AvalonAttackAnimation> CHARGE_ANIM = EFNYamatoAnimations.YAMATO_JUDEMENCUT_CHARGE;
    private static final int QUICK_THRESHOLD = 7;
    private static final int JUST_THRESHOLD = 13;
    private static final int MAX_CHARGE_TICKS = 210;
    private static final UUID JUDGECUT_LISTENER_UUID = UUID.fromString("d34db35f-5a2d-4b3a-9f5c-1919810c2d1a");
    private static final UUID ANIMATION_INTERRUPT_LISTENER_UUID = UUID.fromString("d34db23f-5a1d-4b3a-9f2c-1919810c2d1a");
    private boolean hasAutoTriggered = false;

    public YamatoInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        SkillDataManager data = container.getDataManager();
        this.registerKeyData(data);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, JUDGECUT_LISTENER_UUID, event -> {
            if (event.getAnimation().getRealAnimation().equals(JUDGECUT_ANIM)) {
                data.setData(EFNDataKey.isCharging(), (Object)true);
                data.setData(EFNDataKey.chargeTicks(), (Object)0);
                this.hasAutoTriggered = false;
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, ANIMATION_INTERRUPT_LISTENER_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(EFNDataKey.isCharging())).booleanValue() && !this.isChargeRelatedAnimation(event.getAnimation())) {
                this.cancelCharging(container);
            }
        });
    }

    private boolean isChargeRelatedAnimation(StaticAnimation animation) {
        return animation.getRealAnimation().equals(JUDGECUT_ANIM) || animation.getRealAnimation().equals(QUICK_ANIM) || animation.getRealAnimation().equals(JUST_ANIM) || animation.getRealAnimation().equals(CHARGE_ANIM);
    }

    private void cancelCharging(SkillContainer container) {
        SkillDataManager data = container.getDataManager();
        if (!data.hasData(EFNDataKey.isCharging()) || !data.hasData(EFNDataKey.isPressing())) {
            return;
        }
        data.setData(EFNDataKey.isCharging(), (Object)false);
        data.setData(EFNDataKey.chargeTicks(), (Object)0);
        PlayerPatch playerPatch = container.getExecutor();
        if (playerPatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPatch = (ServerPlayerPatch)playerPatch;
            if (data.hasData(EFNDataKey.isPressing())) {
                data.setDataSync(EFNDataKey.isPressing(), (Object)false, (ServerPlayer)serverPatch.getOriginal());
            }
        }
        this.hasAutoTriggered = false;
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, JUDGECUT_LISTENER_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, ANIMATION_INTERRUPT_LISTENER_UUID);
        super.onRemoved(container);
    }

    private void registerKeyData(SkillDataManager data) {
        data.registerData(EFNDataKey.isCharging());
        data.registerData(EFNDataKey.chargeTicks());
        data.registerData(EFNDataKey.isPressing());
        data.registerData(EFNDataKey.KEY1_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY2_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY3_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY4_LONG_PRESS.get());
        data.registerData(EFNDataKey.INNATE_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY1_PRESS.get());
        data.registerData(EFNDataKey.KEY2_PRESS.get());
        data.registerData(EFNDataKey.KEY3_PRESS.get());
        data.registerData(EFNDataKey.KEY4_PRESS.get());
        data.registerData(EFNDataKey.INNATE_PRESS.get());
        data.registerData(EFNDataKey.SUMMON_SWORD.get());
        data.registerData(EFNDataKey.DOPPELGANGER.get());
        data.registerData(EFNDataKey.KEY1_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY2_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY3_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY4_PRESS_TIMER.get());
        data.registerData(EFNDataKey.INNATE_PRESS_TIMER.get());
        data.registerData(EFNDataKey.COMBO_COUNTER.get());
        data.registerData(EFNDataKey.ANGEL_KEY.get());
        data.registerData(EFNDataKey.DEMON_KEY.get());
        data.registerData(EFNDataKey.JUMP_KEY.get());
        data.registerData(EFNDataKey.SNEAK_KEY.get());
        data.registerData(EFNDataKey.UP_KEY.get());
        data.registerData(EFNDataKey.DOWN_KEY.get());
        data.registerData(EFNDataKey.HAVE_DOPPELGANGER.get());
        data.registerData(EFNDataKey.DOPPELGANGER_STYLE.get());
        data.registerData(EFNDataKey.DOPPELGANGER_DELAY.get());
        data.registerData(EFNDataKey.DOPPELGANGER_TICK.get());
    }

    public void updateContainer(SkillContainer container) {
        float consume;
        SkillDataManager data;
        PlayerPatch playerPatch;
        super.updateContainer(container);
        Skill skill = container.getSkill();
        if (container.getStack() >= skill.getMaxStack() && container.getResource() > 0.0f && !container.getExecutor().isLogicalClient()) {
            skill.setStackSynchronize(container, skill.getMaxStack() - 1);
        }
        if (!container.getExecutor().isLogicalClient() && container.getExecutor().getTickSinceLastAction() > 7) {
            this.resetCombo(container, (PlayerPatch)container.getServerExecutor(), this.root);
        }
        if (!container.getExecutor().isLogicalClient() && (playerPatch = container.getExecutor()) instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            SkillDataManager manager = container.getDataManager();
            if (manager.hasData(EFNDataKey.COMBO_COUNTER.get())) {
                float current = ((Float)manager.getDataValue(EFNDataKey.COMBO_COUNTER.get())).floatValue();
                if (current < 1.0f) {
                    float newValue = current + 0.05f;
                    manager.setDataSync(EFNDataKey.COMBO_COUNTER.get(), (Object)Float.valueOf(newValue), (ServerPlayer)serverPlayerPatch.getOriginal());
                } else {
                    manager.setDataSync(EFNDataKey.COMBO_COUNTER.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)serverPlayerPatch.getOriginal());
                }
            }
        }
        if (container.getExecutor().isLogicalClient()) {
            this.handleClientInput(container);
        } else {
            this.validateServerState(container);
        }
        if (!container.getExecutor().isLogicalClient() && ((Boolean)(data = container.getDataManager()).getDataValue(EFNDataKey.SUMMON_SWORD.get())).booleanValue()) {
            PlayerPatch current = container.getExecutor();
            if (current instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)current;
                float maxStamina = serverPlayerPatch.getMaxStamina();
                float staminaCost = maxStamina * 0.05f;
                float currentStamina = serverPlayerPatch.getStamina();
                if (currentStamina < staminaCost) {
                    data.setDataSync(EFNDataKey.SUMMON_SWORD.get(), (Object)false, (ServerPlayer)serverPlayerPatch.getOriginal());
                    return;
                }
                serverPlayerPatch.setStamina(currentStamina - staminaCost);
                serverPlayerPatch.setStaminaRegenAwaitTicks(15);
            }
            boolean isAngel = (Boolean)data.getDataValue(EFNDataKey.ANGEL_KEY.get());
            boolean isDemon = (Boolean)data.getDataValue(EFNDataKey.DEMON_KEY.get());
            SinSummonedSwordEntity.summon(container.getServerExecutor(), isAngel, isDemon);
            data.setDataSync(EFNDataKey.SUMMON_SWORD.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
        }
        this.have_doppelganger(container);
        if (((Boolean)container.getDataManager().getDataValue(EFNDataKey.DOPPELGANGER.get())).booleanValue() && !container.getExecutor().isLogicalClient()) {
            if (!((Boolean)container.getDataManager().getDataValue(EFNDataKey.HAVE_DOPPELGANGER.get())).booleanValue() && container.getStack() >= 1) {
                DoppelgangerEntity.summon(container.getServerExecutor());
            } else {
                this.destroy(container);
            }
        }
        if ((consume = container.getMaxResource() / 60.0f) >= container.getResource()) {
            consume = container.getResource();
        }
        if (((Boolean)container.getDataManager().getDataValue(EFNDataKey.HAVE_DOPPELGANGER.get())).booleanValue()) {
            if ((double)container.getResource() <= 0.0) {
                if (!container.getExecutor().isLogicalClient()) {
                    skill.setStackSynchronize(container, container.getStack());
                }
                if (container.getStack() <= 0 && container.getResource() <= 0.0f) {
                    if (!container.getExecutor().isLogicalClient()) {
                        this.destroy(container);
                    }
                    return;
                }
                container.setResource(container.getMaxResource() - 0.01f);
            } else {
                container.setResource(container.getResource() - consume);
            }
        }
        if (container.getStack() >= skill.getMaxStack() && container.getResource() > 0.0f && !container.getExecutor().isLogicalClient()) {
            skill.setStackSynchronize(container, skill.getMaxStack() - 1);
        }
    }

    private void have_doppelganger(SkillContainer container) {
        Level level = ((Player)container.getExecutor().getOriginal()).m_9236_();
        double range = 20.0;
        List nearbyEntities = level.m_6249_(container.getExecutor().getOriginal(), ((Player)container.getExecutor().getOriginal()).m_20191_().m_82400_(range), entity -> true);
        for (Entity entity2 : nearbyEntities) {
            DoppelgangerEntity doppelganger;
            if (!(entity2 instanceof DoppelgangerEntity) || (doppelganger = (DoppelgangerEntity)entity2).m_269323_() == null || !doppelganger.m_269323_().equals((Object)container.getExecutor().getOriginal())) continue;
            container.getDataManager().setDataSync(EFNDataKey.HAVE_DOPPELGANGER.get(), (Object)true);
            return;
        }
        container.getDataManager().setDataSync(EFNDataKey.HAVE_DOPPELGANGER.get(), (Object)false);
    }

    public void destroy(SkillContainer container) {
        Level level = ((Player)container.getExecutor().getOriginal()).m_9236_();
        double range = 20.0;
        List nearbyEntities = level.m_6249_(container.getExecutor().getOriginal(), ((Player)container.getExecutor().getOriginal()).m_20191_().m_82400_(range), entity -> true);
        for (Entity entity2 : nearbyEntities) {
            DoppelgangerEntity doppelganger;
            if (!(entity2 instanceof DoppelgangerEntity) || (doppelganger = (DoppelgangerEntity)entity2).m_269323_() == null || !doppelganger.m_269323_().equals((Object)container.getExecutor().getOriginal())) continue;
            container.getServerExecutor().playSound((SoundEvent)EFNSounds.DOPPELGANGER_CLOSE.get(), 1.0f, 1.0f, 1.0f);
            DoppelgangerEntity.spawnDarkParticles(((ServerPlayer)container.getServerExecutor().getOriginal()).m_284548_(), entity2.m_20182_());
            entity2.m_146870_();
        }
    }

    private void handleClientInput(SkillContainer container) {
        LocalPlayer player = (LocalPlayer)container.getExecutor().getOriginal();
        SkillDataManager data = container.getDataManager();
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).m_21205_();
        if (EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(container.getExecutor(), itemstack) == this) {
            if (((Boolean)data.getDataValue(EFNDataKey.isCharging())).booleanValue()) {
                boolean isLeftMouseDown;
                long windowHandle = Minecraft.m_91087_().m_91268_().m_85439_();
                boolean bl = isLeftMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
                if (!isLeftMouseDown) {
                    int chargeTime = (Integer)data.getDataValue(EFNDataKey.chargeTicks());
                    this.releaseAttack(container, chargeTime);
                    data.setDataSync(EFNDataKey.isCharging(), (Object)false, player);
                }
            }
            if (((Boolean)data.getDataValue(EFNDataKey.HAVE_DOPPELGANGER.get())).booleanValue() && EFNKeyMappings.DOPPELGANGER_DELAY.m_90857_()) {
                if (((Boolean)data.getDataValue(EFNDataKey.DOPPELGANGER_DELAY.get())).booleanValue()) {
                    data.setDataSync(EFNDataKey.DOPPELGANGER_DELAY.get(), (Object)false);
                } else {
                    data.setDataSync(EFNDataKey.DOPPELGANGER_DELAY.get(), (Object)true);
                }
                EFNKeyMappings.DOPPELGANGER_DELAY.m_7249_(false);
                container.getExecutor().playSound((SoundEvent)EFNSounds.DOPPELGANGER_SWITCH.get(), 1.0f, 1.0f, 1.0f);
            }
            if (((Boolean)data.getDataValue(EFNDataKey.HAVE_DOPPELGANGER.get())).booleanValue() && EFNKeyMappings.DOPPELGANGER.m_90857_() && ((Player)container.getExecutor().getOriginal()).m_6144_()) {
                int current = (Integer)data.getDataValue(EFNDataKey.DOPPELGANGER_STYLE.get());
                switch (current) {
                    case 0: {
                        data.setDataSync(EFNDataKey.DOPPELGANGER_STYLE.get(), (Object)1);
                        break;
                    }
                    case 1: {
                        data.setDataSync(EFNDataKey.DOPPELGANGER_STYLE.get(), (Object)0);
                    }
                }
                EFNKeyMappings.DOPPELGANGER.m_7249_(false);
                return;
            }
            if (EFNKeyMappings.DOPPELGANGER.m_90857_()) {
                data.setDataSync(EFNDataKey.DOPPELGANGER.get(), (Object)true);
                EFNKeyMappings.DOPPELGANGER.m_7249_(false);
            } else {
                data.setDataSync(EFNDataKey.DOPPELGANGER.get(), (Object)false);
                EFNKeyMappings.DOPPELGANGER.m_7249_(false);
            }
            boolean isAngelHeld = EFNKeyMappings.ANGEL.m_90857_();
            data.setDataSync(EFNDataKey.ANGEL_KEY.get(), (Object)isAngelHeld, player);
            boolean isDemonHeld = EFNKeyMappings.DEMON.m_90857_();
            data.setDataSync(EFNDataKey.DEMON_KEY.get(), (Object)isDemonHeld, player);
            if (EFNKeyMappings.SUMMONED_SWORD.m_90857_()) {
                data.setDataSync(EFNDataKey.SUMMON_SWORD.get(), (Object)true, player);
                EFNKeyMappings.SUMMONED_SWORD.m_7249_(false);
            }
        }
    }

    private void releaseAttack(SkillContainer container, int chargeTime) {
        PlayerPatch executor = container.getExecutor();
        float currentStamina = executor.getStamina();
        float MaxStamina = executor.getMaxStamina();
        if (chargeTime <= 7) {
            executor.playAnimationSynchronized(QUICK_ANIM, 0.05f);
            executor.setStamina(currentStamina - 0.1f * MaxStamina);
            executor.playSound((SoundEvent)EFNSounds.JUDGEMENTCUT.get(), 0.6f, 0.0f, 0.0f);
        } else if (chargeTime <= 13) {
            executor.playAnimationSynchronized(JUST_ANIM, 0.05f);
            executor.setStamina(currentStamina + 0.5f * MaxStamina);
            executor.playSound((SoundEvent)EFNSounds.JUDGEMENTCUT.get(), 0.6f, 0.0f, 0.0f);
        } else {
            executor.playAnimationSynchronized(CHARGE_ANIM, 0.05f);
            executor.setStamina(currentStamina + 0.3f * MaxStamina);
            executor.playSound((SoundEvent)EFNSounds.JUDGEMENTCUT.get(), 0.6f, 0.0f, 0.0f);
        }
    }

    private void validateServerState(SkillContainer container) {
        SkillDataManager data = container.getDataManager();
        if (((Boolean)data.getDataValue(EFNDataKey.isCharging())).booleanValue()) {
            int currentTime = (Integer)data.getDataValue(EFNDataKey.chargeTicks());
            int newTime = Math.min(currentTime + 1, 210);
            data.setDataSync(EFNDataKey.chargeTicks(), (Object)newTime, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
            if (newTime >= 210) {
                data.setDataSync(EFNDataKey.isCharging(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
                this.hasAutoTriggered = true;
            }
        }
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip1").m_130940_(ChatFormatting.BOLD).m_130946_("A\u00b7").m_7220_(InvincibleKeyMappings.KEY1.m_90863_()).m_130946_(" ").m_130946_("S\u00b7").m_7220_(InvincibleKeyMappings.KEY3.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip2").m_130940_(ChatFormatting.GRAY));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip3").m_130940_(ChatFormatting.GRAY));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip4").m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.UNDERLINE).m_7220_(EFNKeyMappings.ANGEL.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip5").m_130940_(ChatFormatting.GRAY));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip6").m_130940_(ChatFormatting.GRAY));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip7").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.UNDERLINE).m_7220_(EFNKeyMappings.DEMON.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip8").m_130940_(ChatFormatting.GRAY));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip9").m_130940_(ChatFormatting.GRAY));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip10").m_130940_(ChatFormatting.BOLD));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip14").m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE).m_7220_(EFNKeyMappings.EFN_ARTS.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip11").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE).m_7220_(EFNKeyMappings.SUMMONED_SWORD.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip12").m_130940_(ChatFormatting.GRAY));
        list.add(Component.m_237115_((String)"skill.efn.yamato.tooltip13").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE).m_7220_(EFNKeyMappings.DOPPELGANGER.m_90863_()));
        return list;
    }
}

