/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_passive;

import com.hm.efn.gameasset.animations.EFNGreatSwordAnimations;
import com.hm.efn.gameasset.combos.Ruinsgreatsword;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.mojang.text2speech.Narrator;
import com.p1nero.invincible.api.skill.ComboNode;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class RuinGreatSwordPassive
extends PassiveSkill {
    private static final float COUNTER_WINDOW_MIN = 0.3f;
    private static final float COUNTER_WINDOW_MAX = 1.1f;
    private static final float CHARGE_WINDOW_START = 0.0f;
    private static final float CHARGE_WINDOW_END = 0.3f;
    private static final float TRANSITION_TIME = 0.0f;
    private static final UUID CHARGE_ANIMATION_LISTENER_UUID = UUID.fromString("e5f6a1b2-c3d4-11ed-a05b-0242ac114511");
    private static final UUID DAMAGE_EVENT_UUID = UUID.fromString("e5f6a1b2-c3d4-11ed-a51b-0242ac114512");

    public RuinGreatSwordPassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerPatch executer = container.getExecutor();
        Player player = (Player)executer.getOriginal();
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, DAMAGE_EVENT_UUID, event -> {
            float elapsedTime;
            float elapsedTime2;
            PlayerPatch patt2643$temp = container.getExecutor();
            if (!(patt2643$temp instanceof ServerPlayerPatch)) {
                return;
            }
            ServerPlayerPatch playerPatch = (ServerPlayerPatch)patt2643$temp;
            if (player.m_5833_()) {
                return;
            }
            AnimationPlayer clashAnim = playerPatch.getAnimator().getPlayerFor(EFNGreatSwordAnimations.NG_GREATSWORD_SKILL_CLASH);
            if (clashAnim != null && clashAnim.getAnimation() == EFNGreatSwordAnimations.NG_GREATSWORD_SKILL_CLASH && (elapsedTime2 = clashAnim.getElapsedTime()) >= 0.3f && elapsedTime2 <= 1.1f) {
                event.setCanceled(true);
                event.setResult(AttackResult.ResultType.MISSED);
                playerPatch.playAnimationSynchronized(EFNGreatSwordAnimations.NG_GREATSWORD_SKILL_CLASH_HIT, 0.0f);
                return;
            }
            AnimationPlayer chargeAnim = playerPatch.getAnimator().getPlayerFor(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_FIRST);
            if (chargeAnim != null && chargeAnim.getAnimation() == EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_FIRST && (elapsedTime = chargeAnim.getElapsedTime()) >= 0.0f && elapsedTime <= 0.3f) {
                event.setCanceled(true);
                event.setResult(AttackResult.ResultType.MISSED);
                playerPatch.playAnimationSynchronized(EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_FIRST, -0.15f);
                playerPatch.playSound((SoundEvent)EpicFightSounds.ENTITY_MOVE.get(), 130.0f, 0.0f, 0.0f);
                player.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 40, 1, false, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 5, false, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 40, 5, false, false, false));
                player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> {
                    if (Ruinsgreatsword.RuinExtendRoot_1_GP == null) {
                        Ruinsgreatsword.RuinExtendRoot_1_GP = ComboNode.createNode(EFNGreatSwordAnimations.NG_GREATSWORD_IDLE);
                    }
                    inv.setCurrentNode(Ruinsgreatsword.RuinExtendRoot_1_GP);
                });
            }
        }, 0);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, CHARGE_ANIMATION_LISTENER_UUID, event -> {
            ServerPlayerPatch serverPatch;
            PlayerPatch patt5675$temp = event.getPlayerPatch();
            if (patt5675$temp instanceof ServerPlayerPatch && (serverPatch = (ServerPlayerPatch)patt5675$temp).getOriginal() instanceof ServerPlayer) {
                this.handleChargeAnimationStart(serverPatch, event.getAnimation());
            }
        });
    }

    private void handleChargeAnimationStart(ServerPlayerPatch playerPatch, StaticAnimation animation) {
        ServerPlayer player;
        try {
            if (playerPatch == null || playerPatch.getOriginal() == null) {
                return;
            }
            player = (ServerPlayer)playerPatch.getOriginal();
            player.m_9236_();
            if (player.m_213877_()) {
                return;
            }
        }
        catch (Exception e) {
            Narrator.LOGGER.error("\u52a8\u753b\u51fa\u9519", (Throwable)e);
        }
        if (!(playerPatch.getOriginal() instanceof ServerPlayer)) {
            return;
        }
        player = (ServerPlayer)playerPatch.getOriginal();
        if (animation == EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MIN.get()) {
            player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> {
                inv.setCurrentNode(Ruinsgreatsword.RuinExtendRoot_2_ChargeMin);
                this.spawnChargeParticles(player, 0.5f);
            });
        } else if (animation == EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_FIRST.get()) {
            player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> {
                inv.setCurrentNode(Ruinsgreatsword.RuinExtendRoot_3_ChargeMax);
                this.spawnChargeParticles(player, 1.0f);
                playerPatch.playSound((SoundEvent)SoundEvents.f_12377_.m_203334_(), 1.1f, 0.0f, 0.0f);
            });
        } else if (animation == EFNGreatSwordAnimations.NG_GREATSWORD_SKILL_CLASH_HIT.get()) {
            player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(Ruinsgreatsword.RuinExtendRoot_1_Clash));
        }
    }

    private void spawnChargeParticles(ServerPlayer player, float intensity) {
        Vec3 pos = player.m_20182_();
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, pos.f_82479_, pos.f_82480_ + 1.5, pos.f_82481_, (int)(15.0f * intensity), 0.5, 0.5, 0.5, 0.2 * (double)intensity);
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, CHARGE_ANIMATION_LISTENER_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, DAMAGE_EVENT_UUID, 0);
    }
}

