/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_passive;

import com.hm.efn.EFN;
import com.hm.efn.EFNConfig;
import com.hm.efn.capability.EFNCapabilities;
import com.hm.efn.client.sound.EFNSounds;
import com.hm.efn.comboevents.events.TickChange;
import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.hm.efn.entity.doppelganger.DoppelgangerPatch;
import com.hm.efn.gameasset.EFNAnimations;
import com.hm.efn.gameasset.EFNSkillSlots;
import com.hm.efn.gameasset.EFNSkills;
import com.hm.efn.gameasset.combos.Yamato;
import com.hm.efn.registries.EFNDataKey;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DodgeAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;

@Mod.EventBusSubscriber
public class YamatoPassive
extends PassiveSkill {
    private static final UUID DODGE_RESET_UUID = UUID.fromString("e5f6a1b2-c1d8-11cd-a05b-0242ac120018");
    private static final UUID DODGE_CANCLE_UUID = UUID.fromString("4704c6de-0268-11ee-be56-0242ac120721");
    private static final UUID PARRY_STUN_UUID = UUID.fromString("a1b2c3d4-e5f6-7890-abcd-ef1234567890");
    private static final Map<LivingEntity, TakeDamageEvent.Attack> parriedAttacks = new ConcurrentHashMap<LivingEntity, TakeDamageEvent.Attack>();
    private int parrycooldown;
    private boolean isBeingRemoved = false;

    public YamatoPassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public static boolean wasRecentlyParried(LivingEntity attacker) {
        return parriedAttacks.containsKey(attacker);
    }

    public static TakeDamageEvent.Attack getParryEvent(LivingEntity attacker) {
        return parriedAttacks.get(attacker);
    }

    public static void clearParryRecord(LivingEntity attacker) {
        parriedAttacks.remove(attacker);
    }

    private static void spawnBlockParticles(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        Vec3 center = player.m_20182_().m_82520_(0.0, 1.5, 0.0);
        for (int i = 0; i < 12; ++i) {
            double angle = Math.toRadians(i * 30);
            Vec3 pos = center.m_82520_(Math.sin(angle) * 1.5, Math.cos(angle) * 0.3, Math.cos(angle) * 1.5);
            level.m_8767_((ParticleOptions)ParticleTypes.f_175829_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 2, 0.0, 0.0, 0.0, 1.0);
        }
    }

    private static void spawnCounterParticles(ServerPlayer player) {
        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_(), 15, 0.3, 0.5, 0.3, 0.5);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.parrycooldown = parameters.m_128451_("parrycooldown");
    }

    public void onInitiate(SkillContainer container) {
        SkillContainer artContainer;
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        PlayerPatch executer = container.getExecutor();
        Player player = (Player)executer.getOriginal();
        SkillContainer dodgeContainer = executer.getSkill((SkillSlot)SkillSlots.DODGE);
        if (dodgeContainer != null && dodgeContainer.getSkill() != null) {
            String lastDodge = dodgeContainer.getSkill().getRegistryName().toString();
            player.getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap -> {
                if (!lastDodge.equals(EFNSkills.YAMATO_DODGE.getRegistryName().toString())) {
                    cap.setLastDodgeSkill(lastDodge);
                    executer.getSkill((SkillSlot)SkillSlots.DODGE).setSkill(EFNSkills.YAMATO_DODGE);
                }
            });
        }
        if ((artContainer = executer.getSkill((SkillSlot)EFNSkillSlots.JUDGMENTCUT_END)) != null) {
            executer.getSkill((SkillSlot)EFNSkillSlots.JUDGMENTCUT_END).setSkill(EFNSkills.JUDGEMENTCUTEND);
        }
        SkillDataManager data = container.getDataManager();
        data.registerData(EFNDataKey.HAVE_DOPPELGANGER.get());
        data.registerData(EFNDataKey.DOPPELGANGER_STYLE.get());
        data.registerData(EFNDataKey.DOPPELGANGER_DELAY.get());
        data.registerData(EFNDataKey.STUN_COOLDOWN.get());
        data.registerData(EFNDataKey.PARRY_COOLDOWN.get());
        listener.addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, PARRY_STUN_UUID, event -> {
            if (event.getDamageSource().m_7639_() == ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()) {
                event.setResult(AttackResult.ResultType.MISSED);
                event.setCanceled(true);
                return;
            }
            if (Objects.requireNonNull(((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null)).getRealAnimation() == EFNAnimations.DMC5_V_JC) {
                return;
            }
            int phaseLevel = ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().getLevel();
            DamageSource damageSource = event.getDamageSource();
            if (event.getDamage() > 0.0f && phaseLevel > 0 && phaseLevel < 3 && (Integer)container.getDataManager().getDataValue(EFNDataKey.PARRY_COOLDOWN.get()) <= 0 && this.isBlockableSource(damageSource)) {
                LivingEntity attacker = damageSource.m_7640_() instanceof LivingEntity ? (LivingEntity)damageSource.m_7640_() : null;
                Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                Vec3 attackDirection = Optional.ofNullable(damageSource.m_7270_()).map(pos -> pos.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_()).orElseGet(() -> attacker != null ? attacker.m_20154_() : viewVector);
                SkillContainer weaponSkillContainer = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                if (weaponSkillContainer != null && weaponSkillContainer.getSkill() != null) {
                    float currentStack = weaponSkillContainer.getStack();
                    float maxStack = weaponSkillContainer.getSkill().getMaxStack();
                    float newStack = Math.min(maxStack, currentStack + 1.0f);
                    weaponSkillContainer.getSkill().setConsumptionSynchronize(weaponSkillContainer, newStack);
                }
                if (attackDirection.m_82526_(viewVector) > 0.0) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EFNSounds.PARRY.get(), 1.0f, 1.0f);
                    event.setCanceled(true);
                    event.setParried(true);
                    event.setResult(AttackResult.ResultType.MISSED);
                    ((ServerPlayerPatch)event.getPlayerPatch()).resetActionTick();
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.INVINCIBILITY_EFFECT.get(), 30, 1, false, false, false));
                    if (attacker != null) {
                        attacker.m_21195_((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get());
                        attacker.m_21195_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get());
                        attacker.m_21195_(MobEffects.f_19606_);
                    }
                    container.getDataManager().setDataSync(EFNDataKey.PARRY_COOLDOWN.get(), (Object)this.parrycooldown);
                    if (((Boolean)EFNConfig.ENABLE_YAMATO_PARRY_TIMESLOWDOWN.get()).booleanValue()) {
                        boolean isDedicatedServer;
                        Level level = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_();
                        int playerCount = level.m_6907_().size();
                        boolean bl = isDedicatedServer = level.m_7654_() != null && level.m_7654_().m_6982_();
                        if (!isDedicatedServer) {
                            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 11, 5, false, false, false));
                            int BegindelayTicks = (Integer)EFNConfig.YAMATO_PARRY_TIMESLOW_DELAY_BEGIN.get();
                            int EndTicks = (Integer)EFNConfig.YAMATO_PARRY_TIMESLOW_DELAY_END.get();
                            int amplifier = (Integer)EFNConfig.YAMATO_PARRY_TIMESLOW_AMPLIFIER.get();
                            if (playerCount <= 1) {
                                EFN.queueServerWork(BegindelayTicks, () -> TickChange.requestChange(amplifier));
                                EFN.queueServerWork(EndTicks, () -> TickChange.requestChange(20.0f));
                            }
                        }
                    }
                    YamatoPassive.spawnCounterParticles((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                    YamatoPassive.spawnBlockParticles((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                    this.applyParryStun((TakeDamageEvent.Attack)event, attacker, container);
                }
            }
        }, 0);
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_CANCLE_UUID, event -> {
            if (event.getSkillContainer().getSkill().getCategory() == SkillCategories.DODGE && !event.isStateExecutable()) {
                EntityState state = container.getExecutor().getEntityState();
                DynamicAnimation animation = (DynamicAnimation)Objects.requireNonNull(container.getExecutor().getAnimator().getPlayerFor(null)).getRealAnimation().get();
                if (animation instanceof ActionAnimation && !(animation instanceof DodgeAnimation) && !event.isStateExecutable()) {
                    event.setStateExecutable(true);
                }
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_RESET_UUID, event -> {
            if (event.getSkillContainer().getSkill() instanceof DodgeSkill) {
                player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(Yamato.yamato_root));
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, DODGE_RESET_UUID, event -> {
            Level level = ((Player)container.getExecutor().getOriginal()).m_9236_();
            double range = 20.0;
            List nearbyEntities = level.m_6249_(container.getExecutor().getOriginal(), ((Player)container.getExecutor().getOriginal()).m_20191_().m_82400_(range), entity -> true);
            for (Entity entity2 : nearbyEntities) {
                DoppelgangerEntity doppelganger;
                if (!(entity2 instanceof DoppelgangerEntity) || (doppelganger = (DoppelgangerEntity)entity2).m_269323_() == null || !doppelganger.m_269323_().equals((Object)container.getExecutor().getOriginal())) continue;
                DoppelgangerPatch doppelgangerPatch = (DoppelgangerPatch)EpicFightCapabilities.getEntityPatch((Entity)doppelganger, DoppelgangerPatch.class);
                SkillContainer innate = container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                if (!((Boolean)innate.getDataManager().getDataValue(EFNDataKey.DOPPELGANGER_DELAY.get())).booleanValue()) {
                    doppelgangerPatch.playAnimationSynchronized((AssetAccessor)((StaticAnimation)event.getAnimation().get()).getAccessor(), 0.0f);
                    if (doppelgangerPatch.getTarget() == null) continue;
                    ((DoppelgangerEntity)doppelgangerPatch.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(doppelgangerPatch.getTarget().m_20185_(), doppelgangerPatch.getTarget().m_20188_() + 0.1, doppelgangerPatch.getTarget().m_20189_()));
                    continue;
                }
                EFN.queueServerWork(20, () -> {
                    doppelgangerPatch.playAnimationSynchronized((AssetAccessor)((StaticAnimation)event.getAnimation().get()).getAccessor(), 0.0f);
                    if (doppelgangerPatch.getTarget() != null) {
                        ((DoppelgangerEntity)doppelgangerPatch.getOriginal()).m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(doppelgangerPatch.getTarget().m_20185_(), doppelgangerPatch.getTarget().m_20188_() + 0.1, doppelgangerPatch.getTarget().m_20189_()));
                    }
                });
            }
        }, 999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_CANCLE_UUID);
        listener.removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_RESET_UUID);
        listener.removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, PARRY_STUN_UUID, 0);
        listener.removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, DODGE_RESET_UUID, 0);
        if (this.isBeingRemoved) {
            return;
        }
        this.isBeingRemoved = true;
        try {
            super.onRemoved(container);
            PlayerPatch executer = container.getExecutor();
            Player player = (Player)executer.getOriginal();
            player.getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap -> {
                Skill originalDodgeSkill;
                String lastDodge = cap.getLastDodgeSkill();
                if (lastDodge != null && !lastDodge.isEmpty() && (originalDodgeSkill = SkillManager.getSkill((String)lastDodge)) != null) {
                    ServerPlayerPatch serverPlayerPatch;
                    SkillContainer skillContainer;
                    executer.getSkill((SkillSlot)SkillSlots.DODGE).setSkill(originalDodgeSkill);
                    if (executer instanceof ServerPlayerPatch && (skillContainer = (serverPlayerPatch = (ServerPlayerPatch)executer).getSkill((SkillSlot)SkillSlots.DODGE)) != null) {
                        EpicFightNetworkManager.sendToPlayer((Object)skillContainer.createSyncPacketToLocalPlayer(), (ServerPlayer)((ServerPlayer)serverPlayerPatch.getOriginal()), (Object[])new Object[0]);
                    }
                }
            });
        }
        finally {
            this.isBeingRemoved = false;
        }
    }

    private void applyParryStun(TakeDamageEvent.Attack event, LivingEntity attacker, SkillContainer container) {
        int cooldown;
        if (attacker == null || !attacker.m_6084_()) {
            return;
        }
        if (container.getDataManager().hasData(EFNDataKey.STUN_COOLDOWN.get()) && (cooldown = ((Integer)container.getDataManager().getDataValue(EFNDataKey.STUN_COOLDOWN.get())).intValue()) > 0) {
            return;
        }
        parriedAttacks.put(attacker, event);
        EFN.queueServerWork(100, () -> parriedAttacks.remove(attacker));
        EFN.LOGGER.debug("Recorded parry against {}", (Object)attacker.m_7755_().getString());
    }

    private void handleCombatStaminaRegen(PlayerPatch<?> playerPatch) {
        float maxStamina;
        float stamina;
        if (playerPatch.getEntityState().inaction() && (stamina = playerPatch.getStamina()) < (maxStamina = playerPatch.getMaxStamina())) {
            float regenAmount = maxStamina * 0.04f / 20.0f;
            playerPatch.setStamina(Math.min(stamina + regenAmount, maxStamina));
            if (playerPatch.getStaminaRegenAwaitTicks() > 10) {
                playerPatch.setStaminaRegenAwaitTicks(10);
            }
        }
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            this.handleCombatStaminaRegen(container.getExecutor());
        }
        if (!container.getExecutor().isLogicalClient() && container.getDataManager().hasData(EFNDataKey.STUN_COOLDOWN.get()) && container.getDataManager().hasData(EFNDataKey.PARRY_COOLDOWN.get())) {
            int parryCooldown = (Integer)container.getDataManager().getDataValue(EFNDataKey.PARRY_COOLDOWN.get());
            int cooldown = (Integer)container.getDataManager().getDataValue(EFNDataKey.STUN_COOLDOWN.get());
            if (cooldown > 0) {
                container.getDataManager().setData(EFNDataKey.STUN_COOLDOWN.get(), (Object)(cooldown - 1));
            }
            if (parryCooldown > 0) {
                container.getDataManager().setData(EFNDataKey.PARRY_COOLDOWN.get(), (Object)(parryCooldown - 1));
            }
        }
    }

    private boolean isBlockableSource(DamageSource damageSource) {
        return !damageSource.m_269533_(DamageTypeTags.f_268738_) && !damageSource.m_269533_(DamageTypeTags.f_268745_);
    }
}

