/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.util;

import com.hm.efn.EFN;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;

public class RenderUtils {
    public static final int EmissiveLightPos = 0xF000F0;
    private static final OpenMatrix4f OPEN_MATRIX_BUFFER = new OpenMatrix4f();

    public static void GLSetTexture(ResourceLocation texture) {
        TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
        AbstractTexture abstracttexture = texturemanager.m_118506_(texture);
        RenderSystem.bindTexture((int)abstracttexture.m_117963_());
        RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
        RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        RenderSystem.setShaderTexture((int)0, (int)abstracttexture.m_117963_());
    }

    public static ResourceLocation GetTexture(String path) {
        return new ResourceLocation("efn", "textures/" + path + ".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void AddParticle(ClientLevel level, Particle particle) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            Camera camera = mc.f_91063_.m_109153_();
            if (mc.f_91073_ != level) {
                EFN.LOGGER.info("[ParticleEngine]Different Level!");
            }
            if (camera.m_90593_() && mc.f_91061_ != null && camera.m_90583_().m_82531_(particle.f_107212_, particle.f_107213_, particle.f_107214_) < 1024.0) {
                mc.f_91061_.m_107344_(particle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void RenderQuadFaceOnCamera(VertexConsumer vertexConsumer, Camera camera, float posX, float posY, float posZ, float r, float g, float b, float a, float scale, float pt) {
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Vec3 camPos = camera.m_90583_();
        float x = (float)((double)posX - camPos.m_7096_());
        float y = (float)((double)posY - camPos.m_7098_());
        float z = (float)((double)posZ - camPos.m_7094_());
        Quaternionf camRot = camera.m_253121_();
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.mul(scale);
            vector3f.add(0.0f, 0.0f, -0.2f);
            vector3f.rotate((Quaternionfc)camRot);
            vector3f.add(x, y, z);
        }
        int j = 0xF000F0;
        vertexConsumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_85969_(j).m_5752_();
    }

    public static void RenderQuadFaceOnCamera2(VertexConsumer vertexConsumer, Camera camera, float posX, float posY, float posZ, float r, float g, float b, float a, float scale) {
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Vec3 camPos = camera.m_90583_();
        float x = (float)((double)posX - camPos.m_7096_());
        float y = (float)((double)posY - camPos.m_7098_());
        float z = (float)((double)posZ - camPos.m_7094_());
        Quaternionf camRot = camera.m_253121_();
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.mul(scale);
            vector3f.add(0.0f, 0.0f, -0.2f);
            vector3f.rotate((Quaternionfc)camRot);
            vector3f.add(x, y, z);
        }
        int j = 0xF000F0;
        vertexConsumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, a).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(0.0f, 1.0f).m_85950_(r, g, b, a).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(1.0f, 1.0f).m_85950_(r, g, b, a).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(1.0f, 0.0f).m_85950_(r, g, b, a).m_85969_(j).m_5752_();
    }

    public static void translateStack(PoseStack poseStack, OpenMatrix4f mat) {
        poseStack.m_252880_(mat.m30, mat.m31, mat.m32);
    }

    public static void rotateStack(PoseStack poseStack, OpenMatrix4f mat) {
        OpenMatrix4f.transpose((OpenMatrix4f)mat, (OpenMatrix4f)OPEN_MATRIX_BUFFER);
        poseStack.m_252781_(RenderUtils.getQuaternionFromMatrix(OPEN_MATRIX_BUFFER));
    }

    public static void scaleStack(PoseStack poseStack, OpenMatrix4f mat) {
        OpenMatrix4f.transpose((OpenMatrix4f)mat, (OpenMatrix4f)OPEN_MATRIX_BUFFER);
        Vector3f vector = RenderUtils.getScaleVectorFromMatrix(OPEN_MATRIX_BUFFER);
        poseStack.m_85841_(vector.x(), vector.y(), vector.z());
    }

    private static Vector3f getScaleVectorFromMatrix(OpenMatrix4f mat) {
        Vec3f a = new Vec3f(mat.m00, mat.m10, mat.m20);
        Vec3f b = new Vec3f(mat.m01, mat.m11, mat.m21);
        Vec3f c = new Vec3f(mat.m02, mat.m12, mat.m22);
        return new Vector3f(a.length(), b.length(), c.length());
    }

    private static Quaternionf getQuaternionFromMatrix(OpenMatrix4f mat) {
        Quaternionf quat = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        quat.setFromUnnormalized((Matrix4fc)OpenMatrix4f.exportToMojangMatrix((OpenMatrix4f)mat.transpose(null)));
        return quat;
    }

    public static class Quad {
        public final Vec2f[] uvs = new Vec2f[4];
        private final Vec3f[] vertexs = new Vec3f[4];

        public Quad(float sizeX, float sizeY) {
            float x = sizeX / 2.0f;
            float z = -sizeY / 2.0f;
            this.vertexs[0] = new Vec3f(x, 0.0f, z);
            this.vertexs[1] = new Vec3f(-x, 0.0f, z);
            this.vertexs[2] = new Vec3f(-x, 0.0f, -z);
            this.vertexs[3] = new Vec3f(x, 0.0f, -z);
            this.uvs[0] = new Vec2f(1.0f, 1.0f);
            this.uvs[1] = new Vec2f(0.0f, 1.0f);
            this.uvs[2] = new Vec2f(0.0f, 0.0f);
            this.uvs[3] = new Vec2f(1.0f, 0.0f);
        }

        public Quad rotate(Vec3f rotAxis, float angle) {
            for (int i = 0; i < this.vertexs.length; ++i) {
                this.vertexs[i].rotate(angle, rotAxis);
            }
            return this;
        }

        public Quad move(float x, float y, float z) {
            for (int i = 0; i < this.vertexs.length; ++i) {
                this.vertexs[i] = this.vertexs[i].add(x, y, z);
            }
            return this;
        }

        public Vec3f GetVertex(int idx, OpenMatrix4f matrix4f) {
            return OpenMatrix4f.transform3v((OpenMatrix4f)matrix4f, (Vec3f)this.vertexs[idx], (Vec3f)new Vec3f());
        }

        public void PushVertex(VertexConsumer buffer, Vec3f camPos, OpenMatrix4f tf, float rCol, float gCol, float bCol, float alpha, int lightCol) {
            for (int i = 0; i < this.vertexs.length; ++i) {
                Vec3f pos = this.GetVertex(i, tf).sub(camPos);
                buffer.m_5483_((double)pos.x, (double)pos.y, (double)pos.z).m_85950_(rCol, gCol, bCol, alpha).m_7421_(this.uvs[i].x, this.uvs[i].y).m_85969_(lightCol).m_5752_();
            }
        }
    }
}

