/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.util;

import com.hm.efn.registries.EFNMobEffectRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="efn", value={Dist.CLIENT})
public class TriangleParticleEffect {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player != Minecraft.m_91087_().f_91074_) {
            return;
        }
        Player player = event.player;
        Level world = player.m_9236_();
        if (player.m_21023_((MobEffect)EFNMobEffectRegistry.RING.get())) {
            TriangleParticleEffect.handleTriangleParticles(player, world);
        }
    }

    private static void handleTriangleParticles(Player player, Level world) {
        long gameTime = world.m_46467_();
        long cycleTime = gameTime % 100L;
        Vec3[] uprightTriangle = new Vec3[]{new Vec3(0.0, 0.0, 2.0), new Vec3(Math.sqrt(3.0), 0.0, -1.0), new Vec3(-Math.sqrt(3.0), 0.0, -1.0)};
        Vec3[] invertedTriangle = new Vec3[]{new Vec3(0.0, 0.0, -2.0), new Vec3(-Math.sqrt(3.0), 0.0, 1.0), new Vec3(Math.sqrt(3.0), 0.0, 1.0)};
        if (cycleTime >= 4L && cycleTime <= 32L && cycleTime % 4L == 0L) {
            TriangleParticleEffect.spawnTriangleParticles(player, uprightTriangle, true);
        } else if (cycleTime >= 52L && cycleTime <= 84L && cycleTime % 4L == 0L) {
            TriangleParticleEffect.spawnTriangleParticles(player, invertedTriangle, false);
        }
    }

    private static void spawnTriangleParticles(Player player, Vec3[] triangle, boolean clockwise) {
        Vec3 playerPos = player.m_20182_();
        double baseY = playerPos.f_82480_ + 0.2;
        for (int i = 0; i < triangle.length; ++i) {
            Vec3 current = triangle[i];
            double x = playerPos.f_82479_ + current.f_82479_;
            double z = playerPos.f_82481_ + current.f_82481_;
            int nextIndex = clockwise ? (i - 1 + triangle.length) % triangle.length : (i + 1) % triangle.length;
            Vec3 next = triangle[nextIndex];
            double dx = (next.f_82479_ - current.f_82479_) * 0.1;
            double dz = (next.f_82481_ - current.f_82481_) * 0.1;
            player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, baseY, z, dx, 0.0, dz);
        }
    }
}

