/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.Client.Particles;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.HashMap;
import net.corruptdog.cdm.Client.Particles.Types.DMC.BloomParticleRenderType;
import net.corruptdog.cdm.Client.Particles.Types.RenderUtils;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ParticleRenderTypes {
    private static int bloomIdx = 0;
    public static final HashMap<ResourceLocation, BloomParticleRenderType> BloomRenderTypes = Maps.newHashMap();
    public static final ParticleRenderType CUT = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferBuilder, @NotNull TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::m_172753_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
        }

        public String toString() {
            return "cdmoveset:cut";
        }
    };
    public static final ParticleRenderType AFTER_IMAGE = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferbuilder, @NotNull TextureManager texManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::m_172829_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }

        public String toString() {
            return "CDMOVESET:AFTERIMAGE";
        }
    };

    public static BloomParticleRenderType getBloomRenderTypeByTexture(ResourceLocation texture) {
        if (BloomRenderTypes.containsKey(texture)) {
            return BloomRenderTypes.get(texture);
        }
        BloomParticleRenderType bloomType = new BloomParticleRenderType(ResourceLocation.fromNamespaceAndPath((String)"cdmoveset", (String)("bp_" + bloomIdx++)), texture);
        BloomRenderTypes.put(texture, bloomType);
        return bloomType;
    }

    public static class QuadParticleRenderType
    implements ParticleRenderType {
        private final ResourceLocation Texture;
        private final String Name;

        public QuadParticleRenderType(String name, ResourceLocation tex) {
            this.Texture = tex;
            this.Name = name;
        }

        public void m_6505_(@NotNull BufferBuilder p_107448_, @NotNull TextureManager p_107449_) {
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::m_172829_);
            if (this.Texture != null) {
                RenderUtils.GLSetTexture(this.Texture);
            }
            p_107448_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85915_().m_277127_(VertexSorting.f_276633_);
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
        }

        public String toString() {
            return this.Name;
        }
    }

    public static class TriangleParticleRenderType
    implements ParticleRenderType {
        private final ResourceLocation Texture;
        private final String Name;

        public TriangleParticleRenderType(String name, ResourceLocation tex) {
            this.Texture = tex;
            this.Name = name;
        }

        public void m_6505_(@NotNull BufferBuilder p_107448_, @NotNull TextureManager p_107449_) {
            RenderSystem.enableBlend();
            RenderSystem.enableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::m_172835_);
            if (this.Texture != null) {
                RenderUtils.GLSetTexture(this.Texture);
            }
            p_107448_.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85820_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85915_().m_277127_(VertexSorting.f_276633_);
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
        }

        public String toString() {
            return this.Name;
        }
    }
}

