/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.api.animation.types;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.StateSpectrum;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class KatanaAttackanimation
extends AttackAnimation {
    protected final StateSpectrum.Blueprint stateUtilsBlueprint = new StateSpectrum.Blueprint();
    private final StateSpectrum stateUtils = new StateSpectrum();

    public KatanaAttackanimation(float convertTime, AnimationManager.AnimationAccessor<? extends KatanaAttackanimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(convertTime, accessor, armature, phases);
        this.stateUtilsBlueprint.clear();
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, true);
    }

    protected void bindPhaseState(AttackAnimation.Phase phase) {
        this.stateSpectrumBlueprint.newTimePair(phase.start, phase.end).addState(EntityState.INACTION, (Object)true).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).newTimePair(phase.start, phase.recovery).addState(EntityState.HURT_LEVEL, (Object)1).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).newTimePair(phase.start, phase.preDelay).addState(EntityState.PHASE_LEVEL, (Object)1).newTimePair(phase.preDelay, phase.contact + 0.01f).addState(EntityState.ATTACKING, (Object)true).addState(EntityState.PHASE_LEVEL, (Object)2).newTimePair(phase.contact + 0.01f, phase.end).addState(EntityState.PHASE_LEVEL, (Object)3).addState(EntityState.TURNING_LOCKED, (Object)true);
    }

    public void postInit() {
        super.postInit();
        if (!this.properties.containsKey(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED)) {
            float basisSpeed = Float.parseFloat(String.format(Locale.US, "%.2f", Float.valueOf(1.0f / this.getTotalTime())));
            this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, Float.valueOf(basisSpeed));
        }
    }

    protected Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> dynamicAnimation) {
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        if (entitypatch.shouldBlockMoving() && this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(false).booleanValue()) {
            vec3 = vec3.m_82490_(0.0);
        }
        return vec3;
    }

    public boolean isBasicAttackAnimation() {
        return true;
    }

    public void setLinkAnimation(AssetAccessor<? extends DynamicAnimation> fromAnimation, Pose startPose, boolean isOnSameLayer, float transitionTimeModifier, LivingEntityPatch<?> entitypatch, LinkAnimation dest) {
        if (!entitypatch.isLogicalClient()) {
            startPose = Animations.EMPTY_ANIMATION.getPoseByTime(entitypatch, 0.0f, 1.0f);
        }
        dest.resetNextStartTime();
        float playTime = this.getPlaySpeed(entitypatch, (DynamicAnimation)dest);
        AnimationProperty.PlaybackSpeedModifier playSpeedModifier = ((StaticAnimation)this.getRealAnimation().get()).getProperty((AnimationProperty)AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER).orElse(null);
        if (playSpeedModifier != null) {
            playTime = playSpeedModifier.modify((DynamicAnimation)dest, entitypatch, playTime, 0.0f, playTime);
        }
        playTime = Math.abs(playTime);
        float linkTime = transitionTimeModifier > 0.0f ? transitionTimeModifier + this.transitionTime : this.transitionTime;
        float totalTime = (playTime *= 0.05f) * (float)((int)Math.ceil(linkTime / playTime));
        float nextStartTime = Math.max(0.0f, -transitionTimeModifier);
        dest.setNextStartTime(nextStartTime += totalTime - linkTime);
        dest.getTransfroms().clear();
        dest.setTotalTime(totalTime);
        dest.setConnectedAnimations(fromAnimation, (AssetAccessor)this.getAccessor());
        Map data1 = startPose.getJointTransformData();
        Map data2 = this.getPoseByTime(entitypatch, nextStartTime, 0.0f).getJointTransformData();
        HashSet<String> joint1 = new HashSet<String>(isOnSameLayer ? data1.keySet() : Set.of());
        HashSet joint2 = new HashSet(data2.keySet());
        if (entitypatch.isLogicalClient()) {
            JointMaskEntry entry = ((DynamicAnimation)fromAnimation.get()).getJointMaskEntry(entitypatch, false).orElse(null);
            JointMaskEntry entry2 = this.getJointMaskEntry(entitypatch, true).orElse(null);
            if (entry != null) {
                joint1.removeIf(jointName -> entry.isMasked(((DynamicAnimation)fromAnimation.get()).getProperty((AnimationProperty)ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER) == Layer.LayerType.BASE_LAYER ? entitypatch.getClientAnimator().currentMotion() : entitypatch.getClientAnimator().currentCompositeMotion(), jointName));
            }
            if (entry2 != null) {
                joint2.removeIf(jointName -> entry2.isMasked(this.getProperty((AnimationProperty)ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER) == Layer.LayerType.BASE_LAYER ? entitypatch.getCurrentLivingMotion() : entitypatch.currentCompositeMotion, jointName));
            }
        }
        joint1.addAll(joint2);
        if (linkTime != totalTime) {
            Map firstPose = this.getPoseByTime(entitypatch, 0.0f, 0.0f).getJointTransformData();
            for (String jointName2 : joint1) {
                Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, (JointTransform)data1.get(jointName2)), new Keyframe(linkTime, (JointTransform)firstPose.get(jointName2)), new Keyframe(totalTime, (JointTransform)data2.get(jointName2))};
                TransformSheet sheet = new TransformSheet(keyframes);
                dest.getAnimationClip().addJointTransform(jointName2, sheet);
            }
        } else {
            for (String jointName3 : joint1) {
                Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, (JointTransform)data1.get(jointName3)), new Keyframe(totalTime, (JointTransform)data2.get(jointName3))};
                TransformSheet sheet = new TransformSheet(keyframes);
                dest.getAnimationClip().addJointTransform(jointName3, sheet);
            }
        }
    }
}

