/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.api.animation.types;

import java.util.Objects;
import net.corruptdog.cdm.api.animation.types.property.Properties;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StateSpectrum;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ThrowSkillAnimation
extends AttackAnimation {
    protected final StateSpectrum.Blueprint stateUtilsBlueprint = new StateSpectrum.Blueprint();
    private boolean wasLockOn = false;

    public ThrowSkillAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends ThrowSkillAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(transitionTime, accessor, armature, phases);
        this.stateUtilsBlueprint.clear();
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, true);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, false);
    }

    protected void bindPhaseState(AttackAnimation.Phase phase) {
        float preDelay = phase.preDelay;
        this.stateSpectrumBlueprint.newTimePair(phase.contact, phase.end).addState(EntityState.LOCKON_ROTATE, (Object)true).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.HURT_LEVEL, (Object)2).newTimePair(phase.start, preDelay).addState(EntityState.PHASE_LEVEL, (Object)1).newTimePair(phase.start, phase.end + 1.0f).addState(EntityState.LOCKON_ROTATE, (Object)true).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).newTimePair(phase.start, phase.end).addState(EntityState.INACTION, (Object)true).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.MOVEMENT_LOCKED, (Object)true).newTimePair(preDelay, phase.contact + 0.01f).addState(EntityState.ATTACKING, (Object)true).addState(EntityState.PHASE_LEVEL, (Object)2).newTimePair(phase.contact + 0.01f, phase.end).addState(EntityState.PHASE_LEVEL, (Object)3).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.INACTION, (Object)true).addState(EntityState.ATTACK_RESULT, damagesource -> !damagesource.m_269533_(DamageTypeTags.f_268738_) ? AttackResult.ResultType.MISSED : AttackResult.ResultType.SUCCESS);
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        if (entitypatch.isLogicalClient() && this.getProperty((AnimationProperty)Properties.MOVE_ROOT_PHASE).isEmpty() && entitypatch instanceof LocalPlayerPatch) {
            LocalPlayerPatch localPlayerPatch = (LocalPlayerPatch)entitypatch;
            this.wasLockOn = localPlayerPatch.isTargetLockedOn();
            localPlayerPatch.setLockOn(true);
        }
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
    }

    protected Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> dynamicAnimation) {
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        float t = Objects.requireNonNull(entitypatch.getAnimator().getPlayerFor(dynamicAnimation)).getElapsedTime();
        if (this.getProperty((AnimationProperty)Properties.MOVE_ROOT_PHASE).isPresent() && ((Properties.SpecialPhase)this.getProperty((AnimationProperty)Properties.MOVE_ROOT_PHASE).get()).isInPhase(t)) {
            vec3 = vec3.m_82542_(0.0, 0.0, 0.0);
        }
        return vec3;
    }
}

