/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.entity.entitypatch;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Random;
import java.util.Set;
import net.corruptdog.cdm.Client.particle.CorruptParticles;
import net.corruptdog.cdm.entity.init.CorruptFightMobEntity;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.corruptdog.cdm.gameasset.CorruptSound;
import net.corruptdog.cdm.world.CorruptWeaponCategories;
import net.corruptdog.cdm.world.ai.CorruptFightCombatBehaviors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class CorruptDogPatch<T extends PathfinderMob>
extends HumanoidMobPatch<T> {
    private boolean isHit1Played = false;
    private boolean parry = false;
    private Random random = new Random();

    public CorruptDogPatch() {
        super((Faction)Factions.NEUTRAL);
    }

    protected void setWeaponMotions() {
        super.setWeaponMotions();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.TACHI, ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, Set.of(Pair.of((Object)LivingMotions.CHASE, (Object)Animations.BIPED_RUN_LONGSWORD), Pair.of((Object)LivingMotions.WALK, (Object)Animations.BIPED_WALK_LONGSWORD), Pair.of((Object)LivingMotions.IDLE, (Object)Animations.BIPED_HOLD_LONGSWORD))));
        this.weaponLivingMotions.put(CorruptWeaponCategories.S_LONGSWORD, ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, Set.of(Pair.of((Object)LivingMotions.CHASE, (Object)Animations.BIPED_RUN_LONGSWORD), Pair.of((Object)LivingMotions.WALK, (Object)Animations.BIPED_WALK_LONGSWORD), Pair.of((Object)LivingMotions.IDLE, (Object)Animations.BIPED_HOLD_LONGSWORD))));
        this.weaponAttackMotions.put(CorruptWeaponCategories.S_LONGSWORD, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, CorruptFightCombatBehaviors.CORRUPT_DOG_LONGSWORD));
        this.weaponAttackMotions.put(CorruptWeaponCategories.S_TACHI, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, CorruptFightCombatBehaviors.CORRUPT_DOG_LONGSWORD));
    }

    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> opponent) {
        EpicFightDamageSource extendedDamageSource;
        if (damageSource instanceof EpicFightDamageSource && (extendedDamageSource = (EpicFightDamageSource)damageSource).m_269533_(EpicFightDamageTypeTags.FINISHER) && (CorruptAnimations.RING_SKILL.equals((Object)extendedDamageSource.getAnimation()) || CorruptAnimations.RING_SKILL_FAST.equals((Object)extendedDamageSource.getAnimation()))) {
            this.playSound((SoundEvent)CorruptSound.IMPACT.get(), 1.0f, 1.0f);
            this.playAnimationSynchronized((AssetAccessor)CorruptAnimations.PARRY_BREAK1, 0.0f);
            opponent.playAnimationSynchronized(CorruptAnimations.PARRY_BREAK6, 0.0f);
        }
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (this.parry && this.getTarget() != null) {
            if (this.isHit1Played) {
                this.playAnimationSynchronized((AssetAccessor)Animations.LONGSWORD_GUARD_ACTIVE_HIT1, 0.0f);
            } else {
                this.playAnimationSynchronized((AssetAccessor)Animations.LONGSWORD_GUARD_ACTIVE_HIT2, 0.0f);
            }
            this.isHit1Played = !this.isHit1Played;
            ((HitParticleType)CorruptParticles.PARRY.get()).spawnParticleWithArgument((ServerLevel)((PathfinderMob)this.original).m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, this.original, damageSource.m_7640_());
            this.playSound((SoundEvent)EpicFightSounds.CLASH.get(), 1.0f, 1.0f);
            return AttackResult.blocked((float)0.0f);
        }
        return super.tryHurt(damageSource, amount);
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        this.parry = this.state.canBasicAttack();
        if (this.parry && ((PathfinderMob)this.original).m_5448_() != null && ((PathfinderMob)this.original).m_20270_((Entity)((PathfinderMob)this.original).m_5448_()) < 5.0f) {
            this.animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, (AssetAccessor)Animations.LONGSWORD_GUARD);
            this.animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, (AssetAccessor)Animations.LONGSWORD_GUARD);
            this.animator.addLivingAnimation((LivingMotion)LivingMotions.CHASE, (AssetAccessor)Animations.LONGSWORD_GUARD);
        }
        if (this.state.knockDown()) {
            int choice = this.random.nextInt(3);
            switch (choice) {
                case 0: {
                    this.playAnimationSynchronized((AssetAccessor)Animations.BIPED_KNOCKDOWN_WAKEUP_LEFT, 0.0f);
                    break;
                }
                case 1: {
                    this.playAnimationSynchronized((AssetAccessor)Animations.BIPED_KNOCKDOWN_WAKEUP_RIGHT, 0.0f);
                    break;
                }
                case 2: {
                    this.playAnimationSynchronized((AssetAccessor)CorruptAnimations.BIPED_HIT_LONG2, 0.0f);
                }
            }
        }
    }

    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder builder;
        if (!holdingRanedWeapon && (builder = this.getHoldingItemWeaponMotionBuilder()) != null) {
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, (Goal)new AnimatedAttackGoal((MobPatch)this, builder.build((MobPatch)this)));
            ((PathfinderMob)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal((MobPatch)this, (PathfinderMob)this.original, 1.2, true));
        }
    }

    public void processEntityPacket(FriendlyByteBuf buf) {
        ClientAnimator animator = this.getClientAnimator();
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, (AssetAccessor)Animations.BIPED_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, (AssetAccessor)Animations.BIPED_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.CHASE, (AssetAccessor)Animations.BIPED_WALK);
        animator.setCurrentMotionsAsDefault();
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add((EntityType)CorruptFightMobEntity.CORRUPTDOG.get(), (Attribute)EpicFightAttributes.IMPACT.get(), 3.0);
    }

    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, (AssetAccessor)Animations.BIPED_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, (AssetAccessor)Animations.BIPED_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.CHASE, (AssetAccessor)Animations.BIPED_RUN);
        animator.addLivingAnimation((LivingMotion)LivingMotions.FALL, (AssetAccessor)Animations.BIPED_FALL);
        animator.addLivingAnimation((LivingMotion)LivingMotions.MOUNT, (AssetAccessor)Animations.BIPED_MOUNT);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, CorruptAnimations.GUARD_BREAK1);
    }

    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveRangedMobUpdateMotion(considerInaction);
    }
}

