/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.Dodge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.UUID;
import net.corruptdog.cdm.gameasset.CDSkills;
import net.corruptdog.cdm.skill.CDSkillDataKeys;
import net.corruptdog.cdm.world.CorruptWeaponCategories;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class EXYamatoDodge
extends DodgeSkill {
    private static final UUID EVENT_UUID = UUID.fromString("5fcb382d-1ebe-4502-bf10-1bc5aa47cae4");
    private static final ResourceLocation EXTX = ResourceLocation.fromNamespaceAndPath((String)"cdmoveset", (String)"textures/gui/skills/dodge/ex_yamato_step.png");

    public EXYamatoDodge(DodgeSkill.Builder builder) {
        super(builder);
    }

    public static DodgeSkill.Builder createDodgeBuilder() {
        return (DodgeSkill.Builder)new DodgeSkill.Builder().setCategory((SkillCategory)SkillCategories.DODGE).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() != CorruptWeaponCategories.YAMATO) {
                SkillContainer dodge = ((ServerPlayerPatch)event.getPlayerPatch()).getSkillCapability().skillContainers[SkillCategories.DODGE.universalOrdinal()];
                dodge.setSkill(CDSkills.YAMATO_STEP);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> container.getDataManager().setDataSync((SkillDataKey)CDSkillDataKeys.TARGET_ID.get(), (Object)event.getTarget().m_19879_()));
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executer, ControlEngine controllEngine) {
        Input input = ((LocalPlayer)executer.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)Minecraft.m_91087_().f_91074_)), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(forward);
        buf.writeInt(backward);
        buf.writeInt(left);
        buf.writeInt(right);
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        int degree;
        int forward = args.readInt();
        int backward = args.readInt();
        int left = args.readInt();
        int right = args.readInt();
        int vertic = forward + backward;
        int horizon = left + right;
        int n = degree = vertic == 0 ? 0 : -(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon);
        int animation = vertic == 0 ? (horizon == 0 ? 4 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        CPSkillRequest packet = new CPSkillRequest(executer.getSkill((Skill)this).getSlot());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat((float)degree);
        return packet;
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        super.executeOnServer(skillContainer, args);
        ServerPlayerPatch executor = skillContainer.getServerExecutor();
        executor.getSkill((Skill)this).activate();
        int i = args.readInt();
        float yaw = args.readFloat();
        boolean tag = false;
        LivingEntity target = (LivingEntity)((ServerPlayer)executor.getOriginal()).m_9236_().m_6815_(((Integer)executor.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.TARGET_ID.get())).intValue());
        if (target != null) {
            if (target.m_20270_(executor.getOriginal()) < 30.0f) {
                tag = true;
            }
            if (!tag) {
                i = 0;
            }
        }
        StaticAnimation animation = (StaticAnimation)this.animations[i].get();
        executor.playAnimationSynchronized((AssetAccessor)animation, 0.0f);
        executor.setModelYRot(yaw, true);
    }

    public Skill getPriorSkill() {
        return CDSkills.YAMATO_STEP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        LivingEntity target = (LivingEntity)((Player)container.getExecutor().getOriginal()).m_9236_().m_6815_(((Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.TARGET_ID.get())).intValue());
        return target != null && target.m_20270_(container.getExecutor().getOriginal()) < 30.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_85836_();
        Objects.requireNonNull(gui.getFont());
        poseStack.m_85837_(0.0, (double)9.0f, 0.0);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getSkillTexture());
        guiGraphics.m_280411_(EXTX, (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        Entity target;
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.TARGET_ID.get()) != null && (target = ((Player)container.getExecutor().getOriginal()).m_9236_().m_6815_(((Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.TARGET_ID.get())).intValue())) instanceof LivingEntity && !target.m_6084_()) {
            container.getDataManager().setDataSync((SkillDataKey)CDSkillDataKeys.TARGET_ID.get(), (Object)-1);
        }
    }
}

