/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.identity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.corruptdog.cdm.gameasset.CorruptSound;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class FatalFlash
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("f47ac10b-58cc-4372-a567-0e02b2c3d479");
    private static final ResourceLocation FATALFLASH_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cdmoveset", (String)"textures/gui/skills/identity/fatalfalsh.png");
    private static final ResourceLocation FLASH1_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cdmoveset", (String)"textures/gui/screen/flash1.png");
    private static final ResourceLocation FLASH2_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cdmoveset", (String)"textures/gui/screen/flash2.png");
    private static final ResourceLocation FLASH3_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cdmoveset", (String)"textures/gui/screen/flash3.png");
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final long cooldownTime = 10000L;
    private long lastUsedTime = 0L;
    private int currentFlashIndex = 0;
    private int flashDuration = 15;
    private int flashCounter = 0;
    private boolean isOnCooldown = false;
    private static boolean skillTrue = false;
    private final Set<WeaponCategory> availableWeapons;

    public static Builder createRevelationSkillBuilder() {
        return new Builder().setCategory((SkillCategory)SkillCategories.IDENTITY).setResource(Skill.Resource.COOLDOWN);
    }

    public FatalFlash(Builder builder) {
        super((SkillBuilder)builder);
        this.availableWeapons = builder.availableWeapons;
    }

    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        PlayerPatch playerPatch = container.getExecutor();
        Player original = (Player)playerPatch.getOriginal();
        listener.addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            double distance;
            LivingEntity target = container.getExecutor().getTarget();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastUsedTime < 10000L || !this.availableWeapons.contains(container.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory())) {
                return;
            }
            if (target != null && (distance = (double)original.m_20270_((Entity)target)) <= 10.0 && (double)target.m_21223_() < (double)target.m_21233_() * 0.3) {
                event.setCanceled(true);
                container.getExecutor().playSound((SoundEvent)CorruptSound.FATALFLASH.get(), 0.8f, 1.2f);
                playerPatch.playAnimationSynchronized(CorruptAnimations.FATALFLASH_READY, 0.2f);
                this.lastUsedTime = currentTime;
                if (this.isOnCooldown) {
                    return;
                }
                this.isOnCooldown = true;
                this.scheduler.schedule(() -> {
                    this.isOnCooldown = false;
                }, 10000L, TimeUnit.MILLISECONDS);
                skillTrue = true;
                new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    playerPatch.playAnimationSynchronized(CorruptAnimations.FATALFLASH, 0.0f);
                    skillTrue = false;
                }).start();
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.TARGET_INDICATOR_ALERT_CHECK_EVENT, EVENT_UUID, event -> {
            LivingEntity target = playerPatch.getTarget();
            if (target == null || !target.m_6084_()) {
                return;
            }
            double distance = original.m_20270_((Entity)target);
            if (!this.isOnCooldown && distance <= 10.0 && (double)target.m_21223_() < (double)target.m_21233_() * 0.3) {
                event.setCanceled(false);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TARGET_INDICATOR_ALERT_CHECK_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        PlayerPatch playerPatch = container.getExecutor();
        LivingEntity target = playerPatch.getTarget();
        if (this.isOnCooldown || !this.availableWeapons.contains(container.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory())) {
            return true;
        }
        if (target != null) {
            double distance = ((Player)playerPatch.getOriginal()).m_20270_((Entity)target);
            return distance < 10.0;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        Objects.requireNonNull(gui.getFont());
        poseStack.m_252880_(0.0f, 9.0f, 0.0f);
        if (this.isOnCooldown) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        guiGraphics.m_280411_(FATALFLASH_TEXTURE, (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        if (this.isOnCooldown) {
            long remainingCooldown = 10000L - (System.currentTimeMillis() - this.lastUsedTime);
            String cooldownString = String.valueOf(remainingCooldown / 1000L);
            guiGraphics.drawString(gui.getFont(), cooldownString, x + 13.0f - (float)gui.getFont().m_92895_(cooldownString), y + 10.0f, 0xFFFFFF, true);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScreen(LocalPlayerPatch playerpatch, float resolutionX, float resolutionY) {
        if (skillTrue) {
            ++this.flashCounter;
            if (this.flashCounter >= this.flashDuration) {
                this.flashCounter = 0;
                this.currentFlashIndex = (this.currentFlashIndex + 1) % 3;
            }
            ResourceLocation currentTexture = switch (this.currentFlashIndex) {
                case 1 -> FLASH2_TEXTURE;
                case 2 -> FLASH3_TEXTURE;
                default -> FLASH1_TEXTURE;
            };
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)currentTexture);
            GlStateManager._enableBlend();
            GlStateManager._disableDepthTest();
            GlStateManager._blendFunc((int)770, (int)771);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_5483_(0.0, 0.0, 1.0).m_7421_(0.0f, 0.0f).m_5752_();
            bufferbuilder.m_5483_(0.0, (double)resolutionY, 1.0).m_7421_(0.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)resolutionX, (double)resolutionY, 1.0).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)resolutionX, 0.0, 1.0).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
        }
    }

    public static class Builder
    extends SkillBuilder<FatalFlash> {
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation>> motions = Maps.newHashMap();
        protected final Set<WeaponCategory> availableWeapons = Sets.newHashSet();

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder addAvailableWeaponCategory(WeaponCategory ... wc) {
            this.availableWeapons.addAll(Arrays.asList(wc));
            return this;
        }
    }
}

