/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.weaponinnate;

import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.corruptdog.cdm.skill.CDSkillDataKeys;
import net.minecraft.network.FriendlyByteBuf;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class DualDaggerSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("f082557a-b2f9-11eb-8529-0242ac130003");
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public DualDaggerSkill(SkillBuilder<? extends WeaponInnateSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID, event -> {
            StaticAnimation animation = event.getAnimation();
            int r = (Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.RUSH_COMBO.get());
            int id = event.getAnimation().getId();
            if (id == ((AttackAnimation)CorruptAnimations.BLADE_RUSH1.get()).getId()) {
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.RUSH_STAR.get(), (Object)true);
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.RUSH_COMBO.get(), (Object)(r + 1));
            }
            if (id == ((AttackAnimation)CorruptAnimations.BLADE_RUSH2.get()).getId()) {
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.RUSH_COMBO.get(), (Object)(r + 1));
            }
            if (id == ((AttackAnimation)CorruptAnimations.BLADE_RUSH3.get()).getId()) {
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.RUSH_COMBO.get(), (Object)(r + 1));
            }
            if (id == ((AttackAnimation)CorruptAnimations.BLADE_RUSH4.get()).getId()) {
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.RUSH_STAR.get(), (Object)false);
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.RUSH_COMBO.get(), (Object)0);
            }
            if (animation != CorruptAnimations.BLADE_RUSH1 && animation != CorruptAnimations.BLADE_RUSH2 && animation != CorruptAnimations.BLADE_RUSH3 && animation != CorruptAnimations.BLADE_RUSH4) {
                this.scheduleResetCombo(container);
            }
        });
    }

    private void scheduleResetCombo(SkillContainer container) {
        this.scheduler.schedule(() -> {
            container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.RUSH_COMBO.get(), (Object)0);
            container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.RUSH_STAR.get(), (Object)false);
        }, 0L, TimeUnit.SECONDS);
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID);
        this.scheduler.shutdown();
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        SkillContainer skillContainer = container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        Boolean rush = (Boolean)skillContainer.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.RUSH_STAR.get());
        int combo = (Integer)skillContainer.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.RUSH_COMBO.get());
        if (!rush.booleanValue()) {
            container.getExecutor().playAnimationSynchronized(CorruptAnimations.BLADE_RUSH1, 0.0f);
        }
        if (combo == 1) {
            container.getExecutor().playAnimationSynchronized(CorruptAnimations.BLADE_RUSH2, 0.0f);
        }
        if (combo == 2) {
            container.getExecutor().playAnimationSynchronized(CorruptAnimations.BLADE_RUSH3, 0.0f);
        }
        if (combo == 3) {
            container.getExecutor().playAnimationSynchronized(CorruptAnimations.BLADE_RUSH4, 0.0f);
        }
    }
}

