/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.weaponinnate;

import java.util.Objects;
import java.util.UUID;
import net.corruptdog.cdm.Client.particle.CorruptParticles;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.corruptdog.cdm.gameasset.CorruptSound;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class GuardParrySkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("244c57c0-a837-11eb-bcbc-0242ac130002");
    private int returnDuration;
    private int enchantLevel;

    public GuardParrySkill(SkillBuilder<? extends WeaponInnateSkill> builder) {
        super(builder);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.returnDuration = parameters.m_128451_("return_duration");
        this.enchantLevel = parameters.m_128451_("enchant_level");
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            if (container.isActivated() && !container.isDisabled() && event.getAttackDamage() > event.getTarget().m_21223_()) {
                this.setDurationSynchronize(container, Math.min(this.maxDuration, container.getRemainDuration() + this.returnDuration));
            }
        });
        container.getDataManager().registerData((SkillDataKey)SkillDataKeys.PARRY_MOTION_COUNTER.get());
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            if (event.getDamage() > 0.0f && container.getRemainDuration() > 0 && this.isExecutableState(event.getPlayerPatch()) && this.canExecute(container) && GuardParrySkill.isBlockableSource(event.getDamageSource())) {
                DamageSource damageSource = event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    this.setDurationSynchronize(container, container.getRemainDuration() - this.returnDuration);
                    SkillDataManager dataManager = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((Skill)this).getDataManager();
                    int motionCounter = (Integer)dataManager.getDataValue((SkillDataKey)SkillDataKeys.PARRY_MOTION_COUNTER.get());
                    dataManager.setDataF((SkillDataKey)SkillDataKeys.PARRY_MOTION_COUNTER.get(), v -> v + 1);
                    if ((motionCounter %= 2) == 1) {
                        ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized((AssetAccessor)Animations.LONGSWORD_GUARD_ACTIVE_HIT1, 0.0f);
                    } else {
                        ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized((AssetAccessor)Animations.LONGSWORD_GUARD_ACTIVE_HIT2, 0.0f);
                    }
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                    ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                    ((HitParticleType)CorruptParticles.PARRY.get()).spawnParticleWithArgument((ServerLevel)playerentity.m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.m_7640_());
                    float knockback = 0.25f;
                    if (damageSource instanceof EpicFightDamageSource) {
                        knockback += Math.min(((EpicFightDamageSource)damageSource).getBaseImpact() * 0.1f, 1.0f);
                        Entity directEntity = event.getDamageSource().m_7640_();
                        LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)directEntity, LivingEntityPatch.class);
                        if (((EpicFightDamageSource)damageSource).getBaseImpact() > 10.0f) {
                            if (entitypatch instanceof HumanoidMobPatch) {
                                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)CorruptSound.IMPACT.get(), 1.0f, 1.0f);
                                entitypatch.playAnimationSynchronized(CorruptAnimations.PARRY_BREAK3, 0.0f);
                            }
                            ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(CorruptAnimations.PARRY_BREAK3, 0.0f);
                        }
                    }
                    if (damageSource.m_7640_() instanceof LivingEntity) {
                        knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)((LivingEntity)damageSource.m_7640_())) * 0.1f;
                    }
                    ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(Objects.requireNonNull(damageSource.m_7640_()).m_20182_(), knockback);
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.BLOCKED);
                }
            }
        }, 0);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).getSkill((Skill)this).isActivated()) {
                LivingEntity livingEntity = (LivingEntity)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                livingEntity.m_6858_(false);
                Minecraft mc = Minecraft.m_91087_();
                ControlEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92091_, (boolean)false);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        PlayerPatch executer = container.getExecutor();
        executer.getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, 0);
        executer.getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        executer.getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        skillContainer.getExecutor().playSound(SoundEvents.f_11677_, 0.0f, 0.0f);
        skillContainer.getExecutor().playAnimationSynchronized((AssetAccessor)Animations.BIPED_LIECHTENAUER_READY, 0.0f);
        SkillContainer weaponInnateSkill = skillContainer.getExecutor().getSkill((Skill)this);
        if (this.isActivated(skillContainer)) {
            this.cancelOnServer(skillContainer, args);
        } else {
            int maxDuration = this.maxDuration + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)skillContainer.getExecutor().getOriginal())) * this.enchantLevel;
            this.setMaxDurationSynchronize(skillContainer, maxDuration);
            this.setDurationSynchronize(skillContainer, maxDuration);
            weaponInnateSkill.activate();
            skillContainer.getServerExecutor().modifyLivingMotionByCurrentItem(false);
        }
    }

    public void cancelOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        skillContainer.deactivate();
        skillContainer.getServerExecutor().modifyLivingMotionByCurrentItem(false);
    }

    public void executeOnClient(SkillContainer skillContainer, FriendlyByteBuf args) {
        super.executeOnClient(skillContainer, args);
        skillContainer.activate();
    }

    public void cancelOnClient(SkillContainer skillContainer, FriendlyByteBuf args) {
        super.cancelOnClient(skillContainer, args);
        skillContainer.deactivate();
    }

    public boolean canExecute(SkillContainer skillContainer) {
        if (skillContainer.getExecutor().isLogicalClient()) {
            return super.canExecute(skillContainer);
        }
        ItemStack itemstack = ((Player)skillContainer.getExecutor().getOriginal()).m_21205_();
        return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill((PlayerPatch)skillContainer.getServerExecutor(), itemstack) == this && ((Player)skillContainer.getExecutor().getOriginal()).m_20202_() == null;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    private static boolean isBlockableSource(DamageSource damageSource) {
        return !damageSource.m_269533_(DamageTypeTags.f_268738_) && !damageSource.m_269533_(DamageTypeTags.f_268415_) && !damageSource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE);
    }
}

