/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.weaponinnate;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class LethalSlicingSkill
extends WeaponInnateSkill {
    private final UUID EVENT_UUID = UUID.fromString("f082557a-b2f9-11eb-8529-0242ac130003");

    public LethalSlicingSkill(SkillBuilder<? extends WeaponInnateSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, this.EVENT_UUID, event -> {
            List hurtEntities;
            if (CorruptAnimations.LETHAL_SLICING_START.equals((Object)event.getAnimation())) {
                ((ServerPlayerPatch)event.getPlayerPatch()).reserveAnimation(CorruptAnimations.LETHAL_SLICING_ONCE);
            } else if (CorruptAnimations.LETHAL_SLICING_ONCE.equals((Object)event.getAnimation()) && (hurtEntities = ((ServerPlayerPatch)event.getPlayerPatch()).getCurrentlyActuallyHitEntities()).size() >= 2) {
                ((ServerPlayerPatch)event.getPlayerPatch()).reserveAnimation(CorruptAnimations.LETHAL_SLICING_TWICE);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, this.EVENT_UUID);
        super.onRemoved(container);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Start Strike:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Once Strike:");
        return list;
    }

    private void SLASH(ServerPlayerPatch executer) {
        executer.playAnimationSynchronized(CorruptAnimations.TACHI_SLASH, 0.0f);
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        ResourceLocation rl = ((DynamicAnimation)skillContainer.getExecutor().getAnimator().getPlayerFor(null).getAnimation().get()).getRegistryName();
        HashMap actionMap = Maps.newHashMap();
        actionMap.put(((AttackAnimation)CorruptAnimations.LETHAL_SLICING_START.get()).getRegistryName(), () -> this.SLASH(skillContainer.getServerExecutor()));
        if (actionMap.containsKey(rl)) {
            ((Runnable)actionMap.get(rl)).run();
        } else {
            skillContainer.getExecutor().playAnimationSynchronized(CorruptAnimations.LETHAL_SLICING_START, 0.0f);
            super.executeOnServer(skillContainer, args);
        }
    }
}

