/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Bee;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class BeeModel
extends EntityModel<Bee>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodybottom;
    private final ModelPart bodymiddle;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftwing;
    private final ModelPart rightwing;
    private final ModelPart thorax1;
    private final ModelPart leftleg;
    private final ModelPart rightleg;
    private final ModelPart leftleglower;
    private final ModelPart rightleglower;
    private float offset = 0.0f;

    public BeeModel(ModelPart root) {
        this.root = root.m_171324_("bee");
        this.bodybottom = this.root.m_171324_("bodybottom");
        this.bodymiddle = this.bodybottom.m_171324_("bodymiddle");
        this.bodytop = this.bodymiddle.m_171324_("bodytop");
        ModelPart neck = this.bodytop.m_171324_("neck");
        this.head = neck.m_171324_("head");
        this.chest = this.bodytop.m_171324_("chest");
        this.leftarm = this.bodytop.m_171324_("leftarm");
        this.rightarm = this.bodytop.m_171324_("rightarm");
        this.leftwing = this.bodytop.m_171324_("leftwing1");
        this.rightwing = this.bodytop.m_171324_("rightwing1");
        this.thorax1 = this.bodybottom.m_171324_("thorax1");
        this.leftleg = this.root.m_171324_("leftleg");
        this.rightleg = this.root.m_171324_("rightleg");
        this.leftleglower = this.leftleg.m_171324_("leftleglower");
        this.rightleglower = this.rightleg.m_171324_("rightleglower");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bee = partdefinition.m_171599_("bee", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = bee.m_171599_("bodybottom", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-13.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.m_171599_("bodymiddle", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).m_171514_(0, 25).m_171481_(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.m_171599_("bodytop", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.5f, -6.0f, -1.5f, 5.0f, 6.0f, 3.0f).m_171514_(36, 33).m_171481_(-3.5f, -6.0f, -1.5f, 7.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).m_171514_(36, 0).m_171481_(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f).m_171514_(36, 14).m_171481_(-4.0f, -6.0f, 1.0f, 8.0f, 8.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.m_171599_("headeyes", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-3.5f, -6.5f, -3.25f, 7.0f, 7.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightantenna = head.m_171599_("rightantenna", CubeListBuilder.m_171558_().m_171514_(36, 25).m_171481_(-2.0f, -8.0f, -5.0f, 1.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition leftantenna = head.m_171599_("leftantenna", CubeListBuilder.m_171558_().m_171514_(36, 25).m_171481_(1.0f, -8.0f, -5.0f, 1.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition chest = bodytop.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171481_(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).m_171514_(0, 36).m_171480_().m_171481_(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-5.5f, (float)-1.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171481_(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-2.5f, (float)-4.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.m_171599_("rightarmlower", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).m_171514_(36, 39).m_171481_(-1.505f, 3.0f, -2.5f, 3.0f, 2.0f, 3.0f), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171480_().m_171481_(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)-4.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.m_171599_("leftarmlower", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171480_().m_171481_(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).m_171555_(false).m_171514_(36, 39).m_171480_().m_171481_(-1.495f, 3.0f, -2.5f, 3.0f, 2.0f, 3.0f).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition rightwing1 = bodytop.m_171599_("rightwing1", CubeListBuilder.m_171558_().m_171514_(64, -10).m_171481_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 10.0f), PartPose.m_171423_((float)1.5f, (float)-4.0f, (float)1.5f, (float)0.5236f, (float)0.7854f, (float)0.0f));
        PartDefinition rightwing2_r1 = rightwing1.m_171599_("rightwing2_r1", CubeListBuilder.m_171558_().m_171514_(64, -10).m_171481_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 10.0f), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition leftwing1 = bodytop.m_171599_("leftwing1", CubeListBuilder.m_171558_().m_171514_(74, -10).m_171481_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 10.0f), PartPose.m_171423_((float)-1.5f, (float)-4.0f, (float)1.5f, (float)0.5236f, (float)-0.7854f, (float)0.0f));
        PartDefinition leftwing2_r1 = leftwing1.m_171599_("leftwing2_r1", CubeListBuilder.m_171558_().m_171514_(74, -10).m_171481_(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 10.0f), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition thorax1 = bodybottom.m_171599_("thorax1", CubeListBuilder.m_171558_().m_171514_(64, 6).m_171481_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)1.5f));
        PartDefinition thorax2 = thorax1.m_171599_("thorax2", CubeListBuilder.m_171558_().m_171514_(64, 12).m_171481_(-2.5f, -1.0f, 0.0f, 5.0f, 5.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)-1.5f, (float)1.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition thorax3 = thorax2.m_171599_("thorax3", CubeListBuilder.m_171558_().m_171514_(64, 22).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = bee.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(24, 12).m_171481_(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.m_171419_((float)-2.0f, (float)-13.0f, (float)0.5f));
        PartDefinition rightleglower = rightleg.m_171599_("rightleglower", CubeListBuilder.m_171558_().m_171514_(24, 22).m_171481_(-1.49f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).m_171514_(94, 0).m_171481_(-2.0f, 6.0f, -0.5f, 4.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition leftleg = bee.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(24, 12).m_171481_(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.m_171419_((float)2.0f, (float)-13.0f, (float)0.5f));
        PartDefinition leftleglower = leftleg.m_171599_("leftleglower", CubeListBuilder.m_171558_().m_171514_(24, 22).m_171481_(-1.51f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).m_171514_(94, 0).m_171481_(-2.0f, 6.0f, -0.5f, 4.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-1.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Bee bee, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)bee, limbSwing, limbSwingAmount, partialTick);
        this.chest.f_104207_ = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !bee.m_6162_();
    }

    public void setupAnim(Bee bee, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legsAngleMoving;
        float armsAngleMoving;
        boolean moveExtremities;
        boolean moving;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        float defaultAngle = 0.0f;
        boolean bl = moving = limbSwingAmount > 0.1f;
        if (moving) {
            moveExtremities = false;
            armsAngleMoving = -1.5707964f;
            legsAngleMoving = 0.08726646f;
            this.bodytop.f_104203_ = 0.5235988f;
            this.rightarm.f_104203_ = armsAngleMoving;
            this.leftarm.f_104203_ = armsAngleMoving;
            this.bodymiddle.f_104203_ = 0.43633232f;
            this.thorax1.f_104203_ = 0.5235988f;
            this.bodybottom.f_104203_ = 0.2617994f;
            this.rightleg.f_104203_ = legsAngleMoving;
            this.leftleg.f_104203_ = legsAngleMoving;
            this.rightleglower.f_104203_ = 1.3089969f;
            this.leftleglower.f_104203_ = 1.3089969f;
            this.head.f_104203_ = -45.0f + headPitch / 57.295776f;
        } else {
            moveExtremities = true;
            armsAngleMoving = defaultAngle;
            legsAngleMoving = defaultAngle;
            this.bodytop.f_104203_ = defaultAngle;
            this.rightarm.f_104203_ = armsAngleMoving;
            this.leftarm.f_104203_ = armsAngleMoving;
            this.bodymiddle.f_104203_ = defaultAngle;
            this.thorax1.f_104203_ = defaultAngle;
            this.bodybottom.f_104203_ = defaultAngle;
            this.rightleg.f_104203_ = legsAngleMoving;
            this.leftleg.f_104203_ = legsAngleMoving;
            this.rightleglower.f_104203_ = defaultAngle;
            this.leftleglower.f_104203_ = defaultAngle;
        }
        this.offset = Mth.m_14089_((float)(ageInTicks * 0.18f)) * 0.9f;
        this.root.f_104201_ = 24.0f - this.offset;
        int animationState = bee.getAnimationState();
        if (animationState == 0) {
            if (moveExtremities) {
                this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
                this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            }
            if (!moveExtremities) {
                this.rightarm.f_104203_ = armsAngleMoving;
                this.leftarm.f_104203_ = armsAngleMoving;
            }
            this.rightarm.f_104205_ = 0.0f;
            this.leftarm.f_104205_ = 0.0f;
            if (this.f_102608_ > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.1745329f;
            this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.1745329f;
        }
        if (animationState == 1) {
            this.animationThrow();
        }
        float swingSpeed = 0.2f;
        float angleRange = 1.0f;
        float wingDefaultAngleY = 0.7853982f;
        this.leftwing.f_104204_ = Mth.m_14089_((float)(ageInTicks * swingSpeed + (float)Math.PI)) * angleRange * 0.5f;
        this.leftwing.f_104204_ -= wingDefaultAngleY;
        this.rightwing.f_104204_ = Mth.m_14089_((float)(ageInTicks * swingSpeed)) * angleRange * 0.5f;
        this.rightwing.f_104204_ += wingDefaultAngleY;
        this.thorax1.f_104203_ += Mth.m_14089_((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        if (animationState == 0) {
            if (moveExtremities) {
                this.rightleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
                this.leftleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
            }
            float swingSpeed2 = 0.2f;
            float angleRange2 = 0.1f;
            if (!moveExtremities) {
                this.rightleg.f_104203_ = legsAngleMoving;
                this.leftleg.f_104203_ = legsAngleMoving;
            }
            this.rightleg.f_104205_ = Mth.m_14089_((float)(ageInTicks * swingSpeed2 + (float)Math.PI)) * angleRange2 * -0.5f;
            this.leftleg.f_104205_ = Mth.m_14089_((float)(ageInTicks * swingSpeed2)) * angleRange2 * -0.5f;
            this.rightleg.f_104204_ = 0.0f;
            this.leftleg.f_104204_ = 0.0f;
            this.rightleg.f_104205_ = 0.0f;
            this.leftleg.f_104205_ = 0.0f;
        }
        if (this.f_102609_) {
            this.rightarm.f_104203_ -= 0.62831855f;
            this.leftarm.f_104203_ -= 0.62831855f;
            this.rightleg.f_104203_ = -1.4137167f;
            this.rightleg.f_104204_ = 0.31415927f;
            this.rightleg.f_104205_ = 0.07853982f;
            this.leftleg.f_104203_ = -1.4137167f;
            this.leftleg.f_104204_ = -0.31415927f;
            this.leftleg.f_104205_ = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.rightarm.f_104203_ = (float)((double)this.rightarm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.f_104203_ += this.bodytop.f_104204_ * 2.0f;
        this.rightarm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    private void animationThrow() {
        float armsAngleThrow = -1.0471976f;
        float legsAngleThrow = 0.34906584f;
        this.rightarm.f_104203_ = armsAngleThrow;
        this.leftarm.f_104203_ = armsAngleThrow;
        this.rightleg.f_104203_ = legsAngleThrow;
        this.leftleg.f_104203_ = legsAngleThrow;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
        this.getArm(arm).m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -(this.offset * 0.05f), 0.0f);
    }
}

