/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.BoneKnight;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.common.ToolActions;

public class BoneKnightModel
extends EntityModel<BoneKnight>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart shield;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    public boolean shielded;

    public BoneKnightModel(ModelPart root) {
        this.root = root.m_171324_("bone_knight");
        this.head = this.root.m_171324_("head");
        this.body = this.root.m_171324_("body");
        this.rightarm = this.root.m_171324_("rightarm");
        this.shield = this.rightarm.m_171324_("shield");
        this.leftarm = this.root.m_171324_("leftarm");
        this.rightleg = this.root.m_171324_("rightleg");
        this.leftleg = this.root.m_171324_("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone_knight = partdefinition.m_171599_("bone_knight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = bone_knight.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition body = bone_knight.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition chest = body.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(40, 12).m_171481_(-4.0f, 0.0f, 0.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-2.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition chestlower_r1 = chest.m_171599_("chestlower_r1", CubeListBuilder.m_171558_().m_171514_(40, 20).m_171481_(-3.0f, 0.0f, 0.0f, 6.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition waist = body.m_171599_("waist", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-4.5f, 10.0f, -2.5f, 9.0f, 8.0f, 5.0f).m_171514_(0, 45).m_171481_(-5.0f, 12.0f, -2.0f, 10.0f, 6.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bone_knight.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f).m_171514_(40, 28).m_171481_(-1.5f, 4.5f, -1.5f, 3.0f, 6.0f, 3.0f).m_171514_(40, 0).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-1.0f)), PartPose.m_171419_((float)-5.0f, (float)-22.0f, (float)0.0f));
        PartDefinition shield = rightarm.m_171599_("shield", CubeListBuilder.m_171558_().m_171514_(88, 0).m_171480_().m_171481_(-3.0f, -1.5f, -6.0f, 1.0f, 22.0f, 12.0f).m_171555_(false).m_171514_(88, 0).m_171480_().m_171481_(-2.5f, 8.5f, -1.5f, 3.0f, 1.0f, 3.0f).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = bone_knight.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171480_().m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f).m_171555_(false).m_171514_(40, 28).m_171480_().m_171481_(-1.5f, 4.5f, -1.5f, 3.0f, 6.0f, 3.0f).m_171555_(false).m_171514_(40, 0).m_171480_().m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-1.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-22.0f, (float)0.0f));
        PartDefinition rightleg = bone_knight.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f).m_171514_(40, 37).m_171481_(-1.5f, 6.0f, -1.5f, 3.0f, 6.0f, 3.0f), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition leftleg = bone_knight.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f).m_171514_(40, 37).m_171480_().m_171481_(-1.5f, 6.0f, -1.5f, 3.0f, 6.0f, 3.0f).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(BoneKnight boneKnight, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)boneKnight, limbSwing, limbSwingAmount, partialTick);
        this.shielded = boneKnight.m_21205_().canPerformAction(ToolActions.SHIELD_BLOCK);
    }

    public void setupAnim(BoneKnight boneKnight, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.shield.f_104207_ = false;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.f_104205_ = 0.0f;
        this.rightarm.f_104205_ = 0.0f;
        if (this.f_102608_ > 0.0f) {
            this.holdingMelee();
        }
        if (this.shielded) {
            this.rightarm.f_104203_ = this.rightarm.f_104203_ * 0.5f - 0.9424779f;
            this.rightarm.f_104204_ = -0.5235988f;
        } else {
            this.rightarm.f_104204_ = 0.0f;
        }
        this.leftarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
        this.leftarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
        this.rightarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.leftleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.rightleg.f_104204_ = 0.0f;
        this.leftleg.f_104204_ = 0.0f;
        this.rightleg.f_104205_ = 0.0f;
        this.leftleg.f_104205_ = 0.0f;
        if (this.f_102609_) {
            this.leftarm.f_104203_ -= 0.62831855f;
            this.rightarm.f_104203_ -= 0.62831855f;
            this.rightleg.f_104203_ = -1.4137167f;
            this.rightleg.f_104204_ = 0.31415927f;
            this.rightleg.f_104205_ = 0.07853982f;
            this.leftleg.f_104203_ = -1.4137167f;
            this.leftleg.f_104204_ = -0.31415927f;
            this.leftleg.f_104205_ = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.leftarm.f_104203_ = (float)((double)this.leftarm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.leftarm.f_104203_ += this.body.f_104204_ * 2.0f;
        this.leftarm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        poseStack.m_85837_(0.0, 1.5, 0.0);
        this.getArm(arm).m_104299_(poseStack);
    }
}

