/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.EnderEye;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class EnderEyeModel
extends EntityModel<EnderEye> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart eyelid1;
    private final ModelPart eyelid2;
    private final ModelPart tail1;
    private final ModelPart leftwing;
    private final ModelPart rightwing;

    public EnderEyeModel(ModelPart root) {
        this.root = root.m_171324_("ender_eye");
        this.body = this.root.m_171324_("body");
        this.eyelid1 = this.body.m_171324_("eyelid1");
        this.eyelid2 = this.body.m_171324_("eyelid2");
        this.tail1 = this.eyelid2.m_171324_("tail1");
        this.leftwing = this.body.m_171324_("leftwing");
        this.rightwing = this.body.m_171324_("rightwing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition ender_eye = partdefinition.m_171599_("ender_eye", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition body = ender_eye.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -3.0f, 8.0f, 8.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.5f));
        PartDefinition eyelid1 = body.m_171599_("eyelid1", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-5.0f, -5.0f, -9.0f, 10.0f, 5.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)3.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition eyelid2 = body.m_171599_("eyelid2", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171481_(-5.0f, 0.0f, -10.0f, 10.0f, 5.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)4.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = eyelid2.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)-3.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)1.5f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightwing = body.m_171599_("rightwing", CubeListBuilder.m_171558_().m_171514_(98, 38).m_171481_(0.0f, 0.0f, -3.0f, 0.0f, 16.0f, 10.0f), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition leftwing = body.m_171599_("leftwing", CubeListBuilder.m_171558_().m_171514_(98, 38).m_171480_().m_171481_(0.0f, 0.0f, -3.0f, 0.0f, 16.0f, 10.0f).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(EnderEye enderEye, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float floatSpeed = 0.5f;
        float floatRange = 3.0f;
        this.root.f_104201_ = 15.0f - Mth.m_14089_((float)((ageInTicks + 1.5f) * floatSpeed)) * floatRange;
        this.body.f_104204_ = netHeadYaw / 57.295776f;
        float swingSpeed = 0.5f;
        float angleRange = 0.2f;
        this.eyelid1.f_104203_ = Mth.m_14089_((float)(ageInTicks * swingSpeed + (float)Math.PI)) * angleRange * 0.5f;
        this.eyelid2.f_104203_ = Mth.m_14089_((float)(ageInTicks * swingSpeed)) * angleRange * 0.5f;
        this.eyelid2.f_104203_ = 0.34906584f;
        float swingSpeed2 = 0.5f;
        float angleRange2 = 1.0f;
        float wingDefaultAngleZ = 1.570796f;
        this.leftwing.f_104205_ = Mth.m_14089_((float)(ageInTicks * swingSpeed2 + (float)Math.PI)) * angleRange2 * 0.5f;
        this.leftwing.f_104205_ += wingDefaultAngleZ;
        this.rightwing.f_104205_ = Mth.m_14089_((float)(ageInTicks * swingSpeed2)) * angleRange2 * 0.5f;
        this.rightwing.f_104205_ -= wingDefaultAngleZ;
        float tailDefaultAngleX = 0.7853982f;
        this.tail1.f_104203_ = Mth.m_14089_((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.08726646f;
        this.tail1.f_104203_ += tailDefaultAngleX;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

