/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import gaia.config.GaiaConfig;
import gaia.entity.Witch;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class WitchModel
extends EntityModel<Witch>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart broom;
    private final ModelPart bodybottom;
    private final ModelPart bodymiddle;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart hat1;
    private final ModelPart hat3;
    private final ModelPart hat4;
    private final ModelPart hat5;
    private final ModelPart hat6;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;
    private final ModelPart leftleglower;
    private final ModelPart rightleglower;
    private float xRot = 0.0f;
    private float offset = 0.0f;

    public WitchModel(ModelPart root) {
        this.root = root.m_171324_("witch");
        this.broom = this.root.m_171324_("broom");
        this.bodybottom = this.root.m_171324_("bodybottom");
        this.bodymiddle = this.bodybottom.m_171324_("bodymiddle");
        this.bodytop = this.bodymiddle.m_171324_("bodytop");
        ModelPart neck = this.bodytop.m_171324_("neck");
        this.head = neck.m_171324_("head");
        this.headeyes = this.head.m_171324_("headeyes");
        this.hat1 = this.head.m_171324_("hat1");
        this.hat3 = this.hat1.m_171324_("hat2").m_171324_("hat3");
        this.hat4 = this.hat3.m_171324_("hat4");
        this.hat5 = this.hat4.m_171324_("hat5");
        this.hat6 = this.hat5.m_171324_("hat6");
        this.chest = this.bodytop.m_171324_("chest");
        this.leftarm = this.bodytop.m_171324_("leftarm");
        this.rightarm = this.bodytop.m_171324_("rightarm");
        this.leftleg = this.root.m_171324_("leftleg");
        this.rightleg = this.root.m_171324_("rightleg");
        this.leftleglower = this.leftleg.m_171324_("leftleglower");
        this.rightleglower = this.rightleg.m_171324_("rightleglower");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition witch = partdefinition.m_171599_("witch", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = witch.m_171599_("bodybottom", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-13.5f, (float)0.5f));
        PartDefinition skirt1 = bodybottom.m_171599_("skirt1", CubeListBuilder.m_171558_().m_171514_(92, 21).m_171488_(-3.5f, 0.5f, -3.0f, 7.0f, 2.0f, 6.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition skirt2 = skirt1.m_171599_("skirt2", CubeListBuilder.m_171558_().m_171514_(92, 29).m_171488_(-4.0f, -1.0f, -3.5f, 8.0f, 4.0f, 7.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.m_171599_("bodymiddle", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).m_171514_(0, 25).m_171481_(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)1.0f));
        PartDefinition bodytop = bodymiddle.m_171599_("bodytop", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition amulet = bodytop.m_171599_("amulet", CubeListBuilder.m_171558_().m_171514_(36, 55).m_171481_(-1.0f, -1.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition mantle = bodytop.m_171599_("mantle", CubeListBuilder.m_171558_().m_171514_(92, 8).m_171481_(-4.5f, 0.5f, 0.0f, 9.0f, 10.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-1.5f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).m_171514_(36, 0).m_171481_(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.5f));
        PartDefinition headeyes = head.m_171599_("headeyes", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat1 = head.m_171599_("hat1", CubeListBuilder.m_171558_().m_171514_(36, 14).m_171481_(-7.0f, -1.0f, -7.0f, 14.0f, 2.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition hat2 = hat1.m_171599_("hat2", CubeListBuilder.m_171558_().m_171514_(36, 30).m_171481_(-4.0f, -5.0f, 0.0f, 8.0f, 5.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-4.0f));
        PartDefinition hat3 = hat2.m_171599_("hat3", CubeListBuilder.m_171558_().m_171514_(68, 30).m_171481_(-6.0f, -6.0f, 0.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)3.0f, (float)-5.0f, (float)1.0f));
        PartDefinition hat4 = hat3.m_171599_("hat4", CubeListBuilder.m_171558_().m_171514_(36, 43).m_171481_(-4.0f, -4.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)-1.0f, (float)-6.0f, (float)1.0f));
        PartDefinition hat5 = hat4.m_171599_("hat5", CubeListBuilder.m_171558_().m_171514_(52, 43).m_171481_(-3.0f, -3.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-0.5f, (float)-4.0f, (float)0.5f));
        PartDefinition hat6 = hat5.m_171599_("hat6", CubeListBuilder.m_171558_().m_171514_(36, 51).m_171481_(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)-0.5f, (float)-3.0f, (float)0.5f));
        PartDefinition chest = bodytop.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171481_(-2.3f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f).m_171514_(0, 36).m_171480_().m_171481_(0.3f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-4.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171481_(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).m_171514_(92, 0).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)-2.5f, (float)-4.5f, (float)-1.5f));
        PartDefinition rightarmlower = rightarm.m_171599_("rightarmlower", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(16, 12).m_171480_().m_171481_(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).m_171555_(false).m_171514_(92, 0).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f).m_171555_(false), PartPose.m_171419_((float)2.5f, (float)-4.5f, (float)-1.5f));
        PartDefinition leftarmlower = leftarm.m_171599_("leftarmlower", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171480_().m_171481_(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition rightleg = witch.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(24, 22).m_171481_(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.m_171419_((float)-2.0f, (float)-13.0f, (float)0.5f));
        PartDefinition rightleglower = rightleg.m_171599_("rightleglower", CubeListBuilder.m_171558_().m_171514_(24, 32).m_171481_(-1.505f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).m_171514_(92, 40).m_171481_(-2.005f, 3.0f, -0.5f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition leftleg = witch.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(24, 12).m_171480_().m_171481_(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-13.0f, (float)0.5f));
        PartDefinition leftleglower = leftleg.m_171599_("leftleglower", CubeListBuilder.m_171558_().m_171514_(24, 32).m_171480_().m_171481_(-1.495f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).m_171555_(false).m_171514_(92, 40).m_171480_().m_171481_(-1.995f, 3.0f, -0.5f, 4.0f, 4.0f, 4.0f).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition broom = witch.m_171599_("broom", CubeListBuilder.m_171558_().m_171514_(112, 43).m_171481_(-0.5f, -11.0f, -0.5f, 1.0f, 20.0f, 1.0f).m_171514_(116, 43).m_171481_(-1.5f, 8.0f, -1.5f, 3.0f, 10.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)0.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Witch witch, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)witch, limbSwing, limbSwingAmount, partialTick);
        this.chest.f_104207_ = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !witch.m_6162_();
        this.hat1.f_104205_ = -0.5235988f;
        this.hat3.f_104203_ = -0.34906584f;
        this.hat3.f_104205_ = 0.34906584f;
        this.hat4.f_104203_ = -0.34906584f;
        this.hat4.f_104205_ = 0.34906584f;
        this.hat5.f_104203_ = -0.34906584f;
        this.hat5.f_104205_ = 0.34906584f;
        this.hat6.f_104203_ = 0.17453292f;
        this.hat6.f_104205_ = -0.17453292f;
    }

    public void setupAnim(Witch witch, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float leftArmAngleMoving;
        float rightArmAngleMoving;
        boolean moveExtremities;
        this.headeyes.f_104207_ = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.root.f_104201_ = 24.0f;
        float defaultAngle = 0.0f;
        if (witch.isRidingBroom()) {
            moveExtremities = false;
            rightArmAngleMoving = 0.5235988f;
            leftArmAngleMoving = 0.7853982f;
            this.rightarm.f_104203_ = -rightArmAngleMoving;
            this.rightarm.f_104204_ = -rightArmAngleMoving;
            this.rightarm.f_104205_ = 0.0f;
            this.leftarm.f_104203_ = -leftArmAngleMoving;
            this.leftarm.f_104204_ = leftArmAngleMoving;
            this.leftarm.f_104205_ = 0.0f;
            this.bodytop.f_104203_ = 0.43633232f;
            this.bodymiddle.f_104203_ = 0.17453292f;
            this.bodybottom.f_104203_ = 0.2617994f;
            this.rightleg.f_104203_ = -1.3962634f;
            this.rightleg.f_104204_ = -0.08726646f;
            this.leftleg.f_104203_ = -1.0471976f;
            this.leftleg.f_104204_ = 0.08726646f;
            this.rightleglower.f_104203_ = 0.7853982f;
            this.leftleglower.f_104203_ = 1.3089969f;
            this.broom.f_104207_ = true;
            this.xRot = Mth.m_14089_((float)(0.10471976f * ageInTicks)) * 0.1f;
            this.root.f_104203_ = this.xRot - 0.3f;
            this.offset = Mth.m_14089_((float)(ageInTicks * 0.18f)) * 0.9f;
            this.root.f_104201_ = 24.0f - this.offset;
        } else {
            moveExtremities = true;
            rightArmAngleMoving = defaultAngle;
            leftArmAngleMoving = defaultAngle;
            this.rightarm.f_104203_ = defaultAngle;
            this.rightarm.f_104204_ = defaultAngle;
            this.leftarm.f_104203_ = defaultAngle;
            this.leftarm.f_104204_ = defaultAngle;
            this.bodytop.f_104203_ = defaultAngle;
            this.bodymiddle.f_104203_ = defaultAngle;
            this.bodybottom.f_104203_ = defaultAngle;
            this.rightleg.f_104203_ = defaultAngle;
            this.rightleg.f_104204_ = defaultAngle;
            this.rightleg.f_104205_ = defaultAngle;
            this.leftleg.f_104203_ = defaultAngle;
            this.leftleg.f_104204_ = defaultAngle;
            this.leftleg.f_104205_ = defaultAngle;
            this.rightleglower.f_104203_ = defaultAngle;
            this.leftleglower.f_104203_ = defaultAngle;
            this.broom.f_104207_ = false;
            this.xRot = 0.0f;
            this.root.f_104203_ = 0.0f;
        }
        if (moveExtremities) {
            this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
            this.leftarm.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.025f;
            this.rightarm.f_104205_ = 0.0f;
            this.leftarm.f_104205_ = 0.0f;
            if (this.f_102608_ > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
            this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        }
        if (!moveExtremities) {
            this.rightarm.f_104203_ = -rightArmAngleMoving;
            this.leftarm.f_104203_ = -leftArmAngleMoving;
        }
        if (moveExtremities) {
            this.rightleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
            this.leftleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        }
        if (this.f_102609_ && !witch.isRidingBroom()) {
            this.rightarm.f_104203_ -= 0.62831855f;
            this.leftarm.f_104203_ -= 0.62831855f;
            this.rightleg.f_104203_ = -1.4137167f;
            this.rightleg.f_104204_ = 0.31415927f;
            this.rightleg.f_104205_ = 0.07853982f;
            this.leftleg.f_104203_ = -1.4137167f;
            this.leftleg.f_104204_ = -0.31415927f;
            this.leftleg.f_104205_ = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.f_102608_;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.m_14031_((float)(f6 * (float)Math.PI));
        float f8 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
        this.rightarm.f_104203_ = (float)((double)this.rightarm.f_104203_ - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.f_104203_ += this.bodytop.f_104204_ * 2.0f;
        this.rightarm.f_104205_ = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        poseStack.m_85837_(0.0, 0.5, 0.25);
        poseStack.m_252781_(Axis.f_252529_.m_252961_(this.xRot));
        poseStack.m_252880_(0.0f, -this.offset * 0.0725f, 0.0f);
        this.getArm(arm).m_104299_(poseStack);
    }
}

