/*
 * Decompiled with CFR 0.152.
 */
package gaia.compat.curios;

import gaia.item.accessory.AbstractAccessoryItem;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosCompat {
    public static void sendImc(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("hands").size(1).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("body").size(1).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("head").size(1).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("necklace").size(1).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("ring").size(1).build());
    }

    public static ICapabilityProvider getCapability(final ItemStack stack) {
        final ICurio curio = new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                Item item = stack.m_41720_();
                if (item instanceof AbstractAccessoryItem) {
                    AbstractAccessoryItem accessoryItem = (AbstractAccessoryItem)item;
                    accessoryItem.onEquip(slotContext.entity(), stack);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                Item item = stack.m_41720_();
                if (item instanceof AbstractAccessoryItem) {
                    AbstractAccessoryItem accessoryItem = (AbstractAccessoryItem)item;
                    accessoryItem.onUnequip(slotContext.entity(), stack);
                }
            }

            public void curioTick(SlotContext slotContext) {
                Item item = stack.m_41720_();
                if (item instanceof AbstractAccessoryItem) {
                    AbstractAccessoryItem accessoryItem = (AbstractAccessoryItem)item;
                    accessoryItem.onTick(slotContext.entity(), stack);
                }
            }

            public boolean canEquipFromUse(SlotContext ctx) {
                return true;
            }
        };
        ICapabilityProvider provider = new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
        return provider;
    }
}

