/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen.client.helper;

import gaia.registry.helper.GaiaMobType;
import gaia.registry.helper.MobReg;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.SoundDefinition;

public class MobSoundHelper {
    private final MobReg<?> mobReg;
    private final SoundDefinition.Sound[] say;
    private final SoundDefinition.Sound[] hurt;
    private final SoundDefinition.Sound[] death;
    private final SoundDefinition.Sound[] step;
    private final SoundDefinition.Sound[] sayMale;
    private final SoundDefinition.Sound[] hurtMale;
    private final SoundDefinition.Sound[] deathMale;
    private final SoundDefinition.Sound[] stepMale;

    public MobReg<?> getMobReg() {
        return this.mobReg;
    }

    public SoundDefinition.Sound[] getSay() {
        return this.say;
    }

    public SoundDefinition.Sound[] getHurt() {
        return this.hurt;
    }

    public SoundDefinition.Sound[] getDeath() {
        return this.death;
    }

    public SoundDefinition.Sound[] getStep() {
        return this.step;
    }

    public SoundDefinition.Sound[] getMaleSay() {
        return this.sayMale;
    }

    public SoundDefinition.Sound[] getMaleHurt() {
        return this.hurtMale;
    }

    public SoundDefinition.Sound[] getMaleDeath() {
        return this.deathMale;
    }

    public SoundDefinition.Sound[] getMaleStep() {
        return this.stepMale;
    }

    public MobSoundHelper(MobReg<?> mobReg, SoundDefinition.Sound[] say, SoundDefinition.Sound[] hurt, SoundDefinition.Sound[] death, SoundDefinition.Sound[] step, SoundDefinition.Sound[] sayMale, SoundDefinition.Sound[] hurtMale, SoundDefinition.Sound[] deathMale, SoundDefinition.Sound[] stepMale) {
        this.mobReg = mobReg;
        this.say = say;
        this.hurt = hurt;
        this.death = death;
        this.step = step;
        this.sayMale = sayMale;
        this.hurtMale = hurtMale;
        this.deathMale = deathMale;
        this.stepMale = stepMale;
    }

    public static class Builder {
        private final MobReg<?> mobReg;
        private SoundDefinition.Sound[] say = new SoundDefinition.Sound[0];
        private SoundDefinition.Sound[] hurt = new SoundDefinition.Sound[0];
        private SoundDefinition.Sound[] death = new SoundDefinition.Sound[0];
        private SoundDefinition.Sound[] step = new SoundDefinition.Sound[0];
        private SoundDefinition.Sound[] sayMale = new SoundDefinition.Sound[0];
        private SoundDefinition.Sound[] hurtMale = new SoundDefinition.Sound[0];
        private SoundDefinition.Sound[] deathMale = new SoundDefinition.Sound[0];
        private SoundDefinition.Sound[] stepMale = new SoundDefinition.Sound[0];

        public Builder(MobReg<?> reg) {
            this.mobReg = reg;
        }

        public Builder withDefaults() {
            String base = "aggressive_";
            GaiaMobType mobType = this.mobReg.getGaiaSoundType();
            if (mobType == GaiaMobType.ASSIST) {
                base = "assist_";
            } else if (mobType == GaiaMobType.PASSIVE) {
                base = "passive_";
            }
            if (this.mobReg.getSay() != null) {
                this.say = new SoundDefinition.Sound[]{this.sound(base + "say1"), this.sound(base + "say2"), this.sound(base + "say3")};
            }
            if (this.mobReg.getHurt() != null) {
                this.hurt = new SoundDefinition.Sound[]{this.sound(base + "hurt1"), this.sound(base + "hurt2"), this.sound(base + "hurt3")};
            }
            if (this.mobReg.getDeath() != null) {
                this.death = new SoundDefinition.Sound[]{this.sound(base + "death")};
            }
            return this;
        }

        public Builder withSay(SoundDefinition.Sound ... sounds) {
            this.say = sounds;
            return this;
        }

        public Builder withHurt(SoundDefinition.Sound ... sounds) {
            this.hurt = sounds;
            return this;
        }

        public Builder withDeath(SoundDefinition.Sound ... sounds) {
            this.death = sounds;
            return this;
        }

        public Builder withStep(SoundDefinition.Sound ... sounds) {
            this.step = sounds;
            return this;
        }

        public Builder withSayMale(SoundDefinition.Sound ... sounds) {
            this.sayMale = sounds;
            return this;
        }

        public Builder withHurtMale(SoundDefinition.Sound ... sounds) {
            this.hurtMale = sounds;
            return this;
        }

        public Builder withDeathMale(SoundDefinition.Sound ... sounds) {
            this.deathMale = sounds;
            return this;
        }

        public Builder withStepMale(SoundDefinition.Sound ... sounds) {
            this.stepMale = sounds;
            return this;
        }

        private SoundDefinition.Sound sound(String name) {
            return SoundDefinition.Sound.sound((ResourceLocation)new ResourceLocation("grimoireofgaia", name), (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND);
        }

        public MobSoundHelper build() {
            return new MobSoundHelper(this.mobReg, this.say, this.hurt, this.death, this.step, this.sayMale, this.hurtMale, this.deathMale, this.stepMale);
        }
    }
}

