/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen.server;

import gaia.registry.GaiaLootTables;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;

public class GaiaLoot
extends LootTableProvider {
    public GaiaLoot(PackOutput packOutput) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(GaiaBlockTables::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(GaiaEntityLoot::new, LootContextParamSets.f_81415_), new LootTableProvider.SubProviderEntry(GaiaBoxLoot::new, LootContextParamSets.f_81416_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
        List<ResourceLocation> ignored = List.of(GaiaLootTables.CHEST_TABLES, GaiaRegistry.CHEST.getEntityType().m_20677_(), GaiaRegistry.HORSE.getEntityType().m_20677_(), GaiaRegistry.MIMIC.getEntityType().m_20677_(), GaiaRegistry.NAGA.getEntityType().m_20677_(), GaiaRegistry.SIREN.getEntityType().m_20677_());
        map.forEach((name, table) -> {
            if (!ignored.contains(name)) {
                table.m_79136_(validationContext);
            }
        });
    }

    private static class GaiaBoxLoot
    implements LootTableSubProvider {
        private GaiaBoxLoot() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(GaiaLootTables.BAG_ARROW, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42738_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)16.0f))).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43615_)).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42738_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)16.0f))).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43582_)).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42738_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)16.0f))).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43584_)).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42738_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)16.0f))).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43593_)).m_79707_(10))));
            consumer.accept(GaiaLootTables.BAG_BOOK, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)20.0f)).m_80499_()))));
            consumer.accept(GaiaLootTables.BAG_RECORD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.RECORDS))));
            consumer.accept(GaiaLootTables.BOXES_HAT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HEADGEAR_BOOK.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HEADGEAR_MOB.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HEADGEAR_BOLT.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HEADGEAR_ARROW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HEADGEAR_DOLL.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HEADGEAR_EARS_ELF.get())))));
            consumer.accept(GaiaLootTables.BOXES_OLD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.GIGA_GEAR.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_WITHER.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_EGG.get())))));
            consumer.accept(GaiaLootTables.BOXES_IRON, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)9.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42386_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42385_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42384_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42384_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42468_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42469_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42470_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42471_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42651_).m_79707_(10))));
            consumer.accept(GaiaLootTables.BOXES_GOLD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)9.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42433_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42432_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42431_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42431_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42476_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42477_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42478_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42479_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42652_).m_79707_(10))));
            consumer.accept(GaiaLootTables.BOXES_DIAMOND, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)9.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42391_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42390_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42389_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42389_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42472_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42473_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42474_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42475_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_()).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42653_).m_79707_(10))));
            consumer.accept(GaiaLootTables.BOXES_OVERWORLD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41833_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41834_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_150965_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41835_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)8.0f))).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41853_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42010_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41977_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)8.0f))).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42107_).m_79707_(5))));
            consumer.accept(GaiaLootTables.BOXES_END, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41999_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)8.0f))).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42102_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)8.0f))).m_79707_(15))));
            consumer.accept(GaiaLootTables.BOXES_NETHER, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42054_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42154_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)8.0f))).m_79707_(15)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41836_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)8.0f))).m_79707_(15))));
            consumer.accept(GaiaLootTables.BOXES_EGG, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("main").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.CREEPER_GIRL.getSpawnEgg().get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ENDER_GIRL.getSpawnEgg().get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SLIME_GIRL.getSpawnEgg().get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TRADER.getSpawnEgg().get())))));
        }
    }

    private static class GaiaEntityLoot
    extends EntityLootSubProvider {
        protected GaiaEntityLoot() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            this.m_245309_(GaiaRegistry.ANT_HILL.getEntityType(), LootTable.m_79147_());
            this.m_245309_(GaiaRegistry.ANT_WORKER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42496_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HONEYDEW.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.ANT_SALVAGER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42517_).m_79078_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_(Enchantments.f_44982_, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.ANUBIS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.ARACHNE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.STONE_COAL.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.BANSHEE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SOULFIRE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_NIGHTMARE.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.BEE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42499_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HONEYDEW.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.BEHENDER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_END.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_ENDER.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.BONE_KNIGHT.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get()))).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.STORAGE_BLOCKS_REDSTONE))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42678_).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.CECAELIA.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SHINY_PEARL.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41983_).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.25f, (float)0.01f))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42517_).m_79078_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_(Enchantments.f_44953_, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.CENTAUR.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.CHEST.getEntityType(), LootTable.m_79147_());
            this.m_247520_(GaiaRegistry.CHEST.getEntityType(), GaiaLootTables.CHEST_TABLES, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78742_))));
            this.m_245309_(GaiaRegistry.COBBLE_GOLEM.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.COBBLESTONE_GOLEM.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.CHEST_JUNGLE.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TOTEM_FRAGMENT.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_METAL.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.CREEP.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42403_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.CREEPER_GIRL.getSpawnEgg().get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_CREEPER_GIRL.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.CYAN_FLOWER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_41939_).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.1f, (float)0.01f))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41940_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MANDRAKE.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.0625f, (float)0.01f))).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_204145_(GaiaTags.TOOLS_SHOVELS).m_45077_()).m_32207_()))))));
            this.m_245309_(GaiaRegistry.CYCLOPS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FUR.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42517_).m_79078_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_(Enchantments.f_44977_, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.KNUCKLES.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.DEATHWORD.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42516_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.DRYAD.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TAPROOT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)ItemTags.f_13181_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_204145_(GaiaTags.TOOLS_AXES).m_45077_()).m_32207_())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_DRYAD.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.DULLAHAN.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SOULFIRE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_DULLAHAN.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.DWARF.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))));
            this.m_247520_(GaiaRegistry.DWARF.getEntityType(), GaiaLootTables.DWARF_RANGED, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42412_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_247520_(GaiaRegistry.DWARF.getEntityType(), GaiaLootTables.DWARF_MINER, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.1f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))));
            this.m_245309_(GaiaRegistry.ENDER_EYE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_ENDER_GIRL.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.ENDER_DRAGON_GIRL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_END.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_ENDER_GIRL.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ENDER_GIRL.getSpawnEgg().get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ELYTRA_FRAGMENT.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.FLESH_LICH.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.GEMS_LAPIS).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get()))).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.STORAGE_BLOCKS_LAPIS))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42681_).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.GELATINOUS_SLIME.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42518_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SLIME_GIRL.getSpawnEgg().get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_SLIME_GIRL.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.GOBLIN.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.GOBLIN_FERAL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))));
            this.m_245309_(GaiaRegistry.GRYPHON.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.HARPY.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DECO_NEST_HARPY.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.HUNTER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ROTTEN_HEART.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.KOBOLD.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FUR.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.MANDRAGORA.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TAPROOT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MANDRAKE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_204145_(GaiaTags.TOOLS_SHOVELS).m_45077_()).m_32207_())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DECO_GARDEN_GNOME.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.MATANGO.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.MUSHROOMS).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.MERMAID.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SHINY_PEARL.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42695_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OLD.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_MERMAID.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SEASHELL_HAIRPIN.get())))));
            this.m_245309_(GaiaRegistry.MINOTAUR.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_DIAMOND).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_EMERALD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_DIAMOND.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BUST_MINOTAUR_ITEM.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.HEAVY_BARBELL.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.RING_OF_HASTE.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.MINOTAURUS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_BATTLE.get())))));
            this.m_247520_(GaiaRegistry.MINOTAURUS.getEntityType(), GaiaLootTables.MINOTAURUS_RANGED, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42412_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())))));
            this.m_245309_(GaiaRegistry.MIMIC.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20558_.m_20677_())).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20479_.m_20677_())).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20566_.m_20677_())).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20526_.m_20677_())).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20501_.m_20677_())).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20524_.m_20677_()))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.PREMIUM_MONSTER_FEED.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TRADER.getSpawnEgg().get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_RECORD.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_HUNGER.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.GRAVEMITE.getEntityType(), LootTable.m_79147_());
            this.m_245309_(GaiaRegistry.MUMMY.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42500_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42583_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.NAGA.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78723_).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))));
            this.m_245309_(GaiaRegistry.NINE_TAILS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SOULFIRE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FAN_FIRE.get())).m_79078_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_(Enchantments.f_44981_, (NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_165374_(Enchantments.f_44980_, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DOLL_NINE_TAILS.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.ONI.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SOULFIRE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42517_).m_79078_((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().m_165374_(Enchantments.f_44977_, (NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.ORC.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))));
            this.m_245309_(GaiaRegistry.SATYRESS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.SHAMAN.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ROTTEN_HEART.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.SHARKO.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SHINY_PEARL.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42695_).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.25f, (float)0.01f))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_OVERWORLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_BUFF.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.SIREN.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78723_).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_ARROWS.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.SLUDGE_GIRL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42518_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.SPHINX.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_DIAMOND).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_EMERALD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_DIAMOND.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BUST_SPHINX.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.RING_OF_JUMP.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.CHEST_DESERT.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.SPORELING.getEntityType(), LootTable.m_79147_());
            this.m_245309_(GaiaRegistry.SPRIGGAN.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TAPROOT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41837_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_204145_(GaiaTags.TOOLS_AXES).m_45077_()).m_32207_())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WEAPON_BOOK_NATURE.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.SUCCUBUS.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FIRESHARD.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_NETHER.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.TOAD.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42518_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.VALKYRIE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_DIAMOND).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(GaiaTags.NUGGETS_EMERALD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_DIAMOND.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BUST_VALKYRIE.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.RING_OF_SPEED.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.WERECAT.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.MEAT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.WITCH.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.NETHER_WART_JAM.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.DECO_MANDRAGORA_POT.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.WITHER_COW.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.WITHERED_BRAIN.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_NETHER.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.WIZARD_HARPY.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SOULFIRE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_IRON).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_IRON.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOOK_OF_MEMORY.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.YUKI_ONNA.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FUR.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.NUGGETS_GOLD).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BOX_GOLD.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.BAG_BOOK.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.FAN_ICE.get())).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.01f, (float)0.01f)))));
            this.m_245309_(GaiaRegistry.HORSE.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20502_.m_20677_()))));
            this.m_245309_(GaiaRegistry.TRADER.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.TRADER.getSpawnEgg().get())))));
            this.m_245309_(GaiaRegistry.CREEPER_GIRL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.CREEPER_GIRL.getSpawnEgg().get())))));
            this.m_245309_(GaiaRegistry.ENDER_GIRL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.ENDER_GIRL.getSpawnEgg().get())))));
            this.m_245309_(GaiaRegistry.SLIME_GIRL.getEntityType(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GaiaRegistry.SLIME_GIRL.getSpawnEgg().get())))));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return GaiaRegistry.ENTITIES.getEntries().stream().map(RegistryObject::get);
        }
    }

    public static class GaiaBlockTables
    extends BlockLootSubProvider {
        protected GaiaBlockTables() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        public void m_245660_() {
            this.m_245724_((Block)GaiaRegistry.BUST_GORGON.get());
            this.m_245724_((Block)GaiaRegistry.BUST_SPHINX.get());
            this.m_245724_((Block)GaiaRegistry.BUST_VALKYRIE.get());
            this.m_245724_((Block)GaiaRegistry.BUST_VAMPIRE.get());
            this.m_245724_((Block)GaiaRegistry.BUST_MINOTAUR.get());
            this.m_245724_((Block)GaiaRegistry.DOLL_CREEPER_GIRL.get());
            this.m_245724_((Block)GaiaRegistry.DOLL_ENDER_GIRL.get());
            this.m_245724_((Block)GaiaRegistry.DOLL_SLIME_GIRL.get());
            this.m_245724_((Block)GaiaRegistry.DOLL_MAID.get());
            this.m_245724_((Block)GaiaRegistry.DOLL_DULLAHAN.get());
            this.m_245724_((Block)GaiaRegistry.DOLL_MERMAID.get());
            this.m_245724_((Block)GaiaRegistry.DOLL_NINE_TAILS.get());
            this.m_245724_((Block)GaiaRegistry.DOLL_DRYAD.get());
            this.m_245724_((Block)GaiaRegistry.DECO_GARDEN_GNOME.get());
            this.m_245724_((Block)GaiaRegistry.DECO_MANDRAGORA_POT.get());
            this.m_245724_((Block)GaiaRegistry.DECO_NEST_HARPY.get());
            this.m_245724_((Block)GaiaRegistry.PEARL_BLOCK.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return GaiaRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
        }
    }
}

