/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.capability.CapabilityHandler;
import gaia.capability.friended.IFriended;
import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.GaiaHorse;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGaiaEntity
extends Monster {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(AbstractGaiaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected Goal targetPlayerGoal;
    protected final Goal targetMobGoal = new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, livingEntity -> {
        AbstractAssistGaiaEntity assistMob;
        return livingEntity instanceof Enemy && !(livingEntity instanceof Creeper) && livingEntity instanceof AbstractAssistGaiaEntity && (assistMob = (AbstractAssistGaiaEntity)((Object)livingEntity)).m_21674_((LivingEntity)this);
    });

    public AbstractGaiaEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
    }

    public void finalizeAttributes() {
        switch (this.getGaiaLevel()) {
            default: {
                this.m_21051_(Attributes.f_22276_).m_22100_((double)SharedEntityData.getMaxHealth1());
                this.m_21051_(Attributes.f_22281_).m_22100_((double)SharedEntityData.getAttackDamage1());
                break;
            }
            case 2: {
                this.m_21051_(Attributes.f_22276_).m_22100_((double)SharedEntityData.getMaxHealth2());
                this.m_21051_(Attributes.f_22281_).m_22100_((double)SharedEntityData.getAttackDamage2());
                break;
            }
            case 3: {
                this.m_21051_(Attributes.f_22276_).m_22100_((double)SharedEntityData.getMaxHealth3());
                this.m_21051_(Attributes.f_22281_).m_22100_((double)SharedEntityData.getAttackDamage3());
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public int getGaiaLevel() {
        return 1;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int index) {
        this.f_19804_.m_135381_(VARIANT, (Object)Mth.m_14045_((int)index, (int)0, (int)this.maxVariants()));
    }

    public int maxVariants() {
        return 0;
    }

    public abstract float getBaseDefense();

    protected float getBaseDamage(DamageSource source, float damage) {
        if (this.getBaseDefense() > 0.0f) {
            return source.m_276093_(DamageTypes.f_268724_) ? damage : Math.min(damage, this.getBaseDefense());
        }
        return damage;
    }

    protected void spawnLingeringCloud(List<MobEffectInstance> effectInstances) {
        if (!effectInstances.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : effectInstances) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.m_9236_().m_7967_((Entity)areaeffectcloud);
        }
    }

    protected GaiaHorse createHorse(DifficultyInstance difficulty) {
        Entity entity = GaiaRegistry.HORSE.getEntityType().m_20615_(this.m_9236_());
        if (entity instanceof GaiaHorse) {
            GaiaHorse horse = (GaiaHorse)entity;
            horse.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), difficulty, MobSpawnType.JOCKEY, null, null);
            horse.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            horse.m_30651_(true);
            horse.m_146762_(0);
            this.m_9236_().m_7967_((Entity)horse);
            return horse;
        }
        return null;
    }

    protected static boolean isHalloween() {
        LocalDate localdate = LocalDate.now();
        int i = localdate.get(ChronoField.DAY_OF_MONTH);
        int j = localdate.get(ChronoField.MONTH_OF_YEAR);
        return j == 10 && i >= 20 || j == 11 && i <= 3;
    }

    protected boolean playerDetection(int range, TargetingConditions conditions) {
        AABB box = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0).m_82400_((double)range);
        List list = this.m_9236_().m_45955_(conditions, (LivingEntity)this, box);
        return !list.isEmpty();
    }

    protected void beaconMonster(int range, Consumer<LivingEntity> action) {
        if (!this.m_9236_().f_46443_) {
            AABB aabb = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0).m_82400_((double)range);
            List entities = this.m_9236_().m_45976_(LivingEntity.class, aabb);
            for (LivingEntity livingEntity : entities) {
                action.accept(livingEntity);
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        this.finalizeAttributes();
        switch (this.getGaiaLevel()) {
            default: {
                AttributeInstance damageAttribute;
                AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
                if (healthAttribute != null) {
                    healthAttribute.m_22100_((double)SharedEntityData.getMaxHealth1());
                }
                if ((damageAttribute = this.m_21051_(Attributes.f_22281_)) == null) break;
                damageAttribute.m_22100_((double)SharedEntityData.getAttackDamage1());
                break;
            }
            case 2: {
                AttributeInstance damageAttribute;
                AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
                if (healthAttribute != null) {
                    healthAttribute.m_22100_((double)SharedEntityData.getMaxHealth2());
                }
                if ((damageAttribute = this.m_21051_(Attributes.f_22281_)) == null) break;
                damageAttribute.m_22100_((double)SharedEntityData.getAttackDamage2());
                break;
            }
            case 3: {
                AttributeInstance damageAttribute;
                AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
                if (healthAttribute != null) {
                    healthAttribute.m_22100_((double)SharedEntityData.getMaxHealth3());
                }
                if ((damageAttribute = this.m_21051_(Attributes.f_22281_)) == null) break;
                damageAttribute.m_22100_((double)SharedEntityData.getAttackDamage3());
            }
        }
        this.m_21153_(this.m_21233_());
        if (((Boolean)GaiaConfig.COMMON.passiveHostileMobs.get()).booleanValue()) {
            this.f_21345_.m_25363_(this.targetPlayerGoal);
        }
        return data;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            int variant = tag.m_128451_("Variant");
            this.setVariant(variant);
        }
        this.setupFriendGoals(this.isFriendly());
    }

    public boolean isFriendly() {
        return this.getCapability(CapabilityHandler.CAPABILITY_FRIENDED).map(cap -> cap.isFriendly()).orElse(false);
    }

    public void setFriendly(boolean value, UUID friendedBy) {
        this.getCapability(CapabilityHandler.CAPABILITY_FRIENDED).ifPresent(cap -> {
            this.m_6710_(null);
            cap.setFriendly(value);
            cap.setFriendedBy(friendedBy);
            this.setupFriendGoals(value);
            if (((Boolean)GaiaConfig.COMMON.friendlyPersistence.get()).booleanValue()) {
                this.m_21530_();
            }
        });
    }

    protected void setupFriendGoals(boolean friendly) {
        if (this.targetPlayerGoal == null) {
            this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        }
        switch (this.getGaiaLevel()) {
            case 1: {
                if (friendly) {
                    this.f_21346_.m_25363_(this.targetPlayerGoal);
                    this.f_21346_.m_25352_(2, this.targetMobGoal);
                    break;
                }
                this.f_21346_.m_25363_(this.targetMobGoal);
                if (this instanceof AbstractAssistGaiaEntity) {
                    if (!((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) break;
                    this.f_21346_.m_25352_(2, this.targetPlayerGoal);
                    break;
                }
                if (((Boolean)GaiaConfig.COMMON.passiveHostileMobs.get()).booleanValue()) break;
                this.f_21346_.m_25352_(2, this.targetPlayerGoal);
                break;
            }
            case 2: {
                if (friendly) {
                    this.f_21346_.m_25363_(this.targetPlayerGoal);
                    break;
                }
                if (this instanceof AbstractAssistGaiaEntity) {
                    if (!((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) break;
                    this.f_21346_.m_25352_(2, this.targetPlayerGoal);
                    break;
                }
                if (((Boolean)GaiaConfig.COMMON.passiveHostileMobs.get()).booleanValue()) break;
                this.f_21346_.m_25352_(2, this.targetPlayerGoal);
            }
        }
    }

    public void m_8107_() {
        IFriended cap;
        if (this.getCapability(CapabilityHandler.CAPABILITY_FRIENDED).isPresent() && (cap = (IFriended)this.getCapability(CapabilityHandler.CAPABILITY_FRIENDED).orElse(null)) != null && cap.isChanged()) {
            this.onFriendlyChange(cap);
            cap.setChanged(false);
        }
        super.m_8107_();
    }

    public void onFriendlyChange(IFriended cap) {
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.6;
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_20202_();
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfindermob = (PathfinderMob)entity;
            this.f_20883_ = pathfindermob.f_20883_;
        }
    }

    public boolean m_6549_(EntityType<?> type) {
        if (this instanceof AbstractAssistGaiaEntity) {
            return type != this.m_6095_() && type != EntityType.f_20558_ && super.m_6549_(type);
        }
        return super.m_6549_(type);
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        return this instanceof IDayMob ? 0.0f : super.m_5610_(pos, levelReader);
    }

    public static boolean checkGaiaDaySpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AbstractGaiaEntity.checkDaylight(levelAccessor, pos) && AbstractGaiaEntity.m_219019_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected static boolean checkDaylight(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return levelAccessor.m_45527_(pos) && levelAccessor.m_45517_(LightLayer.BLOCK, pos) == 0;
    }

    protected static boolean checkUnderwaterDaylight(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return levelAccessor.m_46861_(pos) && levelAccessor.m_45517_(LightLayer.BLOCK, pos) == 0;
    }

    protected static boolean checkAboveSeaLevel(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return AbstractGaiaEntity.checkAboveY(pos, levelAccessor.m_5736_());
    }

    protected static boolean checkAboveY(BlockPos pos, int yLevel) {
        return (Boolean)GaiaConfig.COMMON.disableYRestriction.get() != false || pos.m_123342_() > yLevel;
    }

    protected static boolean checkBelowSeaLevel(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return AbstractGaiaEntity.checkBelowY(pos, levelAccessor.m_5736_());
    }

    public static boolean checkInWater(LevelAccessor levelAccessor, BlockPos pos, int yOffset) {
        int seaLevel = levelAccessor.m_5736_();
        int belowSeaLevel = seaLevel - yOffset;
        boolean below = pos.m_123342_() <= belowSeaLevel;
        boolean inWater = levelAccessor.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && levelAccessor.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
        return below && inWater;
    }

    public static boolean checkNotPeaceful(LevelAccessor levelAccessor) {
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL;
    }

    public static boolean checkSpawner(LevelAccessor levelAccessor) {
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL;
    }

    protected static boolean checkBelowY(BlockPos pos, int yLevel) {
        return (Boolean)GaiaConfig.COMMON.disableYRestriction.get() != false || pos.m_123342_() < yLevel;
    }

    protected static boolean checkTagBlocks(ServerLevelAccessor levelAccessor, BlockPos pos, TagKey<Block> blockTag) {
        return levelAccessor.m_8055_(pos.m_7495_()).m_204336_(blockTag);
    }

    protected static boolean checkDaytime(ServerLevelAccessor levelAccessor) {
        return !levelAccessor.m_6042_().m_63967_() && levelAccessor.m_7445_() < 4;
    }

    protected static boolean checkRaining(ServerLevelAccessor levelAccessor) {
        return (Boolean)GaiaConfig.COMMON.spawnWeather.get() != false || levelAccessor.m_6106_().m_6533_();
    }

    protected static boolean checkDaysPassed(ServerLevelAccessor levelAccessor) {
        if (((Boolean)GaiaConfig.COMMON.spawnDaysPassed.get()).booleanValue()) {
            return (int)(levelAccessor.m_8044_() / 24000L) >= (Integer)GaiaConfig.COMMON.spawnDaysSet.get();
        }
        return true;
    }

    protected boolean hasShield() {
        ItemStack offStack = this.m_6844_(EquipmentSlot.OFFHAND);
        return offStack.canPerformAction(ToolActions.SHIELD_BLOCK);
    }
}

