/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Cecaelia
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> THROWING = SynchedEntityData.m_135353_(Cecaelia.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 60, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    private int timer;
    private int switchDetect;
    private int switchEquip;
    private boolean animationPlay;
    private int animationTimer;
    private byte inWaterTimer;

    public Cecaelia(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new CecaeliaMermaidMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 8.0f);
        this.timer = 0;
        this.switchDetect = 0;
        this.switchEquip = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
        this.inWaterTimer = 0;
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 1;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(THROWING, (Object)false);
    }

    public boolean isThrowing() {
        return (Boolean)this.f_19804_.m_135370_(THROWING);
    }

    public void setThrowing(boolean flag) {
        this.f_19804_.m_135381_(THROWING, (Object)flag);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.bubble(target, (LivingEntity)this, distanceFactor);
            this.setThrowing(true);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, effectTime * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_20069_()) {
            if (this.inWaterTimer <= 100) {
                this.inWaterTimer = (byte)(this.inWaterTimer + 1);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)8);
                this.m_5634_(this.m_21233_() * 0.1f);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 0));
                this.inWaterTimer = 0;
            }
        }
        if (this.playerDetection(3, TargetingConditions.m_148352_())) {
            if (this.switchDetect == 0) {
                this.switchDetect = 1;
            }
        } else if (this.switchDetect == 1) {
            this.switchDetect = 0;
        }
        if (this.switchDetect == 1 && this.switchEquip == 0) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                if (!this.m_21023_(MobEffects.f_19596_)) {
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 0));
                }
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.METAL_DAGGER.get()));
                this.setGoals(1);
                this.timer = 0;
                this.switchEquip = 1;
            }
        }
        if (this.switchDetect == 0 && this.switchEquip == 1) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                if (this.m_21023_(MobEffects.f_19596_)) {
                    this.m_21195_(MobEffects.f_19596_);
                }
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                this.setGoals(0);
                this.timer = 0;
                this.switchEquip = 0;
            }
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setThrowing(false);
                this.animationPlay = false;
            }
        }
        super.m_8107_();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_((Goal)this.rangedAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.mobAttackGoal);
        } else {
            this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.rangedAttackGoal);
            this.setThrowing(false);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    boolean wantsToSwim() {
        LivingEntity livingentity = this.m_5448_();
        return livingentity != null && livingentity.m_20069_();
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        ItemStack itemstack = this.m_21205_();
        if (itemstack.m_41619_()) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
        ItemStack swimmingBoots = new ItemStack((ItemLike)Items.f_42463_);
        this.m_8061_(EquipmentSlot.FEET, swimmingBoots);
        swimmingBoots.m_41663_(Enchantments.f_44973_, 2);
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.CECAELIA.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.CECAELIA.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.CECAELIA.getDeath();
    }

    public int m_5792_() {
        return 2;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public boolean m_6549_(EntityType<?> type) {
        return super.m_6549_(type) && type != GaiaRegistry.CECAELIA.getEntityType();
    }

    public boolean m_6914_(LevelReader reader) {
        return reader.m_45784_((Entity)this);
    }

    public static boolean checkCecaeliaSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean daysPassed = Cecaelia.checkDaysPassed(levelAccessor);
        boolean isNight = !Cecaelia.checkDaytime(levelAccessor);
        boolean inWater = Cecaelia.checkInWater((LevelAccessor)levelAccessor, pos, 5);
        boolean darkEnough = Cecaelia.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)random);
        boolean notPeaceful = Cecaelia.checkNotPeaceful((LevelAccessor)levelAccessor);
        boolean matchRandom = random.m_188503_(15) == 0;
        return matchRandom && daysPassed && isNight && inWater && darkEnough && notPeaceful;
    }

    static class CecaeliaMermaidMoveControl
    extends MoveControl {
        private final Cecaelia cecaelia;

        public CecaeliaMermaidMoveControl(Cecaelia cecaelia) {
            super((Mob)cecaelia);
            this.cecaelia = cecaelia;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.cecaelia.m_5448_();
            if (this.cecaelia.wantsToSwim() && this.cecaelia.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.cecaelia.m_20186_()) {
                    this.cecaelia.m_20256_(this.cecaelia.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.cecaelia.m_21573_().m_26571_()) {
                    this.cecaelia.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.cecaelia.m_20185_();
                double d1 = this.f_24976_ - this.cecaelia.m_20186_();
                double d2 = this.f_24977_ - this.cecaelia.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.cecaelia.m_146922_(this.m_24991_(this.cecaelia.m_146908_(), f, 90.0f));
                this.cecaelia.f_20883_ = this.cecaelia.m_146908_();
                float f1 = (float)(this.f_24978_ * this.cecaelia.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.cecaelia.m_6113_(), (float)f1);
                this.cecaelia.m_7910_(f2);
                this.cecaelia.m_20256_(this.cecaelia.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.cecaelia.m_20096_()) {
                    this.cecaelia.m_20256_(this.cecaelia.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }
}

