/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaSounds;
import gaia.util.SharedEntityData;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.Nullable;

public class EnderDragonGirl
extends AbstractAssistGaiaEntity {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("411AF4FD-812A-4D90-802A-6FD57A7777C2");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.15, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> SCREAMING = SynchedEntityData.m_135353_(EnderDragonGirl.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int targetChangeTime;

    public EnderDragonGirl(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MobAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new LookForPlayerGoal(this, this::m_21674_));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.f_21346_.m_25352_(2, this.targetPlayerGoal);
        }
    }

    public boolean m_21674_(LivingEntity livingEntity) {
        if (!this.m_6779_(livingEntity)) {
            return false;
        }
        return this.m_5448_() != null && livingEntity.m_6095_() == EntityType.f_20532_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (livingEntity == null) {
            this.targetChangeTime = 0;
            this.f_19804_.m_135381_(SCREAMING, (Object)false);
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        } else {
            this.targetChangeTime = this.f_19797_;
            this.f_19804_.m_135381_(SCREAMING, (Object)true);
            if (!attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        }
        super.m_6710_(livingEntity);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCREAMING, (Object)false);
    }

    public boolean isScreaming() {
        return (Boolean)this.f_19804_.m_135370_(SCREAMING);
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269014_()) {
            Entity entity = source.m_7640_();
            boolean flag1 = entity instanceof ThrownPotion ? this.hurtWithCleanWater(source, (ThrownPotion)entity, input) : false;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return flag1;
        }
        boolean flag = super.m_6469_(source, input);
        if (!this.m_9236_().m_5776_() && !(source.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }

    private boolean hurtWithCleanWater(DamageSource damageSource, ThrownPotion thrownPotion, float damage) {
        ItemStack itemstack = thrownPotion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
        List list = PotionUtils.m_43547_((ItemStack)itemstack);
        boolean flag = potion == Potions.f_43599_ && list.isEmpty();
        return flag && super.m_6469_(damageSource, damage);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        this.f_20899_ = false;
        super.m_8107_();
    }

    @Override
    protected void m_8024_() {
        float f;
        if (this.m_20070_()) {
            this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
        }
        if (this.m_9236_().m_46461_() && this.f_19797_ >= this.targetChangeTime + 600 && (f = this.m_213856_()) > 0.5f && this.m_9236_().m_45527_(this.m_20183_()) && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f) {
            this.m_6710_(null);
            this.teleportRandomly();
        }
        super.m_8024_();
    }

    public boolean shouldAttackPlayer(Player player) {
        ItemStack itemstack = (ItemStack)player.m_150109_().f_35975_.get(3);
        if (itemstack.isEnderMask(player, null)) {
            return false;
        }
        Vec3 vec3 = player.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_20188_() - player.m_20188_(), this.m_20189_() - player.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && player.m_142582_((Entity)this);
    }

    protected boolean teleportRandomly() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)GaiaSounds.ENDER_DRAGON_GIRL_TELEPORT.get(), this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_((SoundEvent)GaiaSounds.ENDER_DRAGON_GIRL_TELEPORT.get(), 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    boolean teleportTowards(Entity entity) {
        Vec3 vec3 = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
        vec3 = vec3.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    public boolean m_142535_(float distance, float multiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState state, BlockPos pos) {
    }

    protected SoundEvent m_7515_() {
        return this.isScreaming() ? (SoundEvent)GaiaSounds.ENDER_DRAGON_GIRL_SCREAM.get() : GaiaRegistry.ENDER_DRAGON_GIRL.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.ENDER_DRAGON_GIRL.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.ENDER_DRAGON_GIRL.getDeath();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    public boolean m_5825_() {
        return true;
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkEnderDragonGirlSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return EnderDragonGirl.checkDaysPassed(levelAccessor) && EnderDragonGirl.m_219019_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    static class LookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final EnderDragonGirl enderDragonGirl;
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public LookForPlayerGoal(EnderDragonGirl enderDragonGirl, @Nullable Predicate<LivingEntity> livingEntityPredicate) {
            super((Mob)enderDragonGirl, Player.class, 10, false, false, livingEntityPredicate);
            this.enderDragonGirl = enderDragonGirl;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(livingEntity -> enderDragonGirl.shouldAttackPlayer((Player)livingEntity));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.enderDragonGirl.m_9236_().m_45946_(this.startAggroTargetConditions, (LivingEntity)this.enderDragonGirl);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = this.m_183277_(5);
            this.teleportTime = 0;
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.enderDragonGirl.shouldAttackPlayer(this.pendingTarget)) {
                    return false;
                }
                this.enderDragonGirl.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.enderDragonGirl, this.f_26050_) || super.m_8045_();
        }

        public void m_8037_() {
            if (this.enderDragonGirl.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            } else {
                if (this.f_26050_ != null && !this.enderDragonGirl.m_20159_()) {
                    if (this.enderDragonGirl.shouldAttackPlayer((Player)this.f_26050_)) {
                        if (this.f_26050_.m_20280_((Entity)this.enderDragonGirl) < 16.0) {
                            this.enderDragonGirl.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (this.f_26050_.m_20280_((Entity)this.enderDragonGirl) > 256.0 && this.teleportTime++ >= this.m_183277_(30) && this.enderDragonGirl.teleportTowards((Entity)this.f_26050_)) {
                        this.teleportTime = 0;
                    }
                }
                super.m_8037_();
            }
        }
    }
}

