/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class Kobold
extends AbstractGaiaEntity
implements RangedAttackMob {
    private final RangedBowAttackGoal<Kobold> bowAttackGoal = new RangedBowAttackGoal((Monster)this, 1.25, 20, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    private int timer = 0;
    private int switchDetect = 0;
    private int switchEquip = 0;

    public Kobold(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public int maxVariants() {
        return 1;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.m_6469_(source, input);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, effectTime * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (this.playerDetection(3, TargetingConditions.m_148352_())) {
            if (this.switchDetect == 0) {
                this.switchDetect = 1;
            }
        } else if (this.switchDetect == 1) {
            this.switchDetect = 0;
        }
        if (this.switchDetect == 1 && this.switchEquip == 0) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                if (!this.m_21023_(MobEffects.f_19596_)) {
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 0));
                }
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.METAL_DAGGER.get()));
                this.setGoals(1);
                this.timer = 0;
                this.switchEquip = 1;
            }
        }
        if (this.switchDetect == 0 && this.switchEquip == 1) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                if (this.m_21023_(MobEffects.f_19596_)) {
                    this.m_21195_(MobEffects.f_19596_);
                }
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                this.setGoals(0);
                this.timer = 0;
                this.switchEquip = 0;
            }
        }
        super.m_8107_();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.f_21345_.m_25363_(this.bowAttackGoal);
            this.f_21345_.m_25352_(1, (Goal)this.mobAttackGoal);
        } else {
            this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
            this.f_21345_.m_25352_(1, this.bowAttackGoal);
        }
    }

    private void setCombatTask(Difficulty difficulty) {
        this.f_21345_.m_25363_((Goal)this.mobAttackGoal);
        this.f_21345_.m_25363_(this.bowAttackGoal);
        if (this.m_21205_().m_41720_() == Items.f_42411_) {
            int i = difficulty != Difficulty.HARD ? 40 : 20;
            this.bowAttackGoal.m_25797_(i);
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    @Override
    public boolean m_6549_(EntityType<?> type) {
        return super.m_6549_(type) && type != GaiaRegistry.KOBOLD.getEntityType();
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (target.m_6084_()) {
            RangedUtil.rangedAttack(target, (LivingEntity)this, distanceFactor);
        }
    }

    protected void m_213945_(RandomSource random, DifficultyInstance instance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        if (random.m_188499_()) {
            if (random.m_188503_(2) == 0) {
                this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)Potions.f_43615_));
            } else {
                this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)Potions.f_43593_));
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
        if (this.f_19796_.m_188503_(4) == 0) {
            this.setVariant(1);
        }
        this.m_213945_(this.f_19796_, difficultyInstance);
        this.m_213945_(this.f_19796_, difficultyInstance);
        this.setCombatTask(difficultyInstance.m_19048_());
        return data;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCombatTask(this.m_9236_().m_46791_());
    }

    protected SoundEvent m_7515_() {
        return GaiaRegistry.KOBOLD.getSay();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return GaiaRegistry.KOBOLD.getHurt();
    }

    protected SoundEvent m_5592_() {
        return GaiaRegistry.KOBOLD.getDeath();
    }

    protected int m_6101_() {
        return 10;
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkKoboldSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Kobold.checkDaysPassed(levelAccessor) && Kobold.checkAboveSeaLevel(levelAccessor, pos) && Kobold.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

