/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.prop;

import gaia.config.GaiaConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPropEntity
extends AgeableMob {
    protected AbstractPropEntity(EntityType<? extends AgeableMob> type, Level level) {
        super(type, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_20159_()) {
            this.m_8127_();
        }
    }

    public void finalizeAttributes() {
    }

    public static boolean checkAnyLightMonsterSpawnRules(EntityType<? extends AgeableMob> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && AbstractPropEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean checkPropSpawnRules(EntityType<? extends AgeableMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AbstractPropEntity.isDarkEnoughToSpawn(levelAccessor, pos, random) && AbstractPropEntity.checkAnyLightMonsterSpawnRules(entityType, (LevelAccessor)levelAccessor, spawnType, pos, random);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor levelAccessor, BlockPos pos, RandomSource random) {
        if (levelAccessor.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        if (levelAccessor.m_45517_(LightLayer.BLOCK, pos) > 0) {
            return false;
        }
        int i = levelAccessor.m_6018_().m_46470_() ? levelAccessor.m_46849_(pos, 10) : levelAccessor.m_46803_(pos);
        return i <= random.m_188503_(8);
    }

    public static boolean checkDayPropSpawnRules(EntityType<? extends AgeableMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AbstractPropEntity.checkDaylight(levelAccessor, pos) && AbstractPropEntity.checkAnyLightMonsterSpawnRules(entityType, (LevelAccessor)levelAccessor, spawnType, pos, random);
    }

    protected static boolean checkDaylight(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return levelAccessor.m_45527_(pos) && levelAccessor.m_45517_(LightLayer.BLOCK, pos) == 0;
    }

    protected static boolean checkAboveSeaLevel(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return AbstractPropEntity.checkAboveY(pos, levelAccessor.m_5736_());
    }

    protected static boolean checkAboveY(BlockPos pos, int yLevel) {
        return (Boolean)GaiaConfig.COMMON.disableYRestriction.get() != false || pos.m_123342_() > yLevel;
    }

    protected static boolean checkBelowSeaLevel(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return AbstractPropEntity.checkBelowY(pos, levelAccessor.m_5736_());
    }

    protected static boolean checkBelowY(BlockPos pos, int yLevel) {
        return (Boolean)GaiaConfig.COMMON.disableYRestriction.get() != false || pos.m_123342_() < yLevel;
    }

    protected static boolean checkTagBlocks(ServerLevelAccessor levelAccessor, BlockPos pos, TagKey<Block> blockTag) {
        return levelAccessor.m_8055_(pos.m_7495_()).m_204336_(blockTag);
    }

    protected static boolean checkDaysPassed(ServerLevelAccessor levelAccessor) {
        if (((Boolean)GaiaConfig.COMMON.spawnDaysPassed.get()).booleanValue()) {
            return (int)(levelAccessor.m_8044_() / 24000L) >= (Integer)GaiaConfig.COMMON.spawnDaysSet.get();
        }
        return true;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.finalizeAttributes();
        return super.m_6518_(levelAccessor, difficultyInstance, spawnType, groupData, tag);
    }
}

