/*
 * Decompiled with CFR 0.152.
 */
package gaia.modifier;

import com.mojang.serialization.Codec;
import gaia.registry.GaiaModifiers;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record AddGaiaSpawnModifier(List<HolderSet<Biome>> biomes, List<HolderSet<Biome>> biomeBlacklist, List<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
{
    public static AddGaiaSpawnModifier singleSpawn(List<HolderSet<Biome>> biomes, List<HolderSet<Biome>> blacklistBiomes, MobSpawnSettings.SpawnerData spawner) {
        return new AddGaiaSpawnModifier(biomes, blacklistBiomes, List.of(spawner));
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            if (this.biomes.stream().allMatch(biomeSet -> biomeSet.m_203333_(biome)) && (this.biomeBlacklist.isEmpty() || !this.biomeBlacklist.isEmpty() && this.biomeBlacklist.stream().noneMatch(biomeSet -> biomeSet.m_203333_(biome)))) {
                for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                    spawns.m_48376_(MobCategory.MONSTER, spawner);
                }
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)GaiaModifiers.ADD_GAIA_SPAWN.get();
    }
}

