/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.entity.custom.kraken;

import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.multipart_entities.entity.EntityBounds;
import com.cerbon.cerbons_api.api.multipart_entities.entity.MultipartAwareEntity;
import com.cerbon.cerbons_api.api.multipart_entities.util.CompoundOrientedBox;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.myths_of_the_sea.entity.custom.kraken.KrakenBodyRotationControl;
import com.cerbon.myths_of_the_sea.entity.custom.kraken.KrakenEntityHitboxes;
import com.cerbon.myths_of_the_sea.entity.custom.kraken.goal.KrakenMeleeAttackGoal;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.LeviathanMoveControl;
import com.cerbon.myths_of_the_sea.entity.custom.util.BreachingWaterBoundPathNavigation;
import com.cerbon.myths_of_the_sea.entity.custom.util.ExtraReachNearestAttackGoal;
import com.cerbon.myths_of_the_sea.item.MTSItems;
import com.cerbon.myths_of_the_sea.sound.MTSSounds;
import com.cerbon.myths_of_the_sea.util.GeoControllersUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KrakenEntity
extends WaterAnimal
implements GeoEntity,
MultipartAwareEntity {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SIMPLE_ATTACK_ANIM = RawAnimation.begin().thenPlay("attack_simple");
    private static final RawAnimation GRAB_ATTACK_ANIM = RawAnimation.begin().thenPlay("attack_grab");
    private static final RawAnimation MOVE_GROUND = RawAnimation.begin().then("move_ground", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation IDLE_GROUND = RawAnimation.begin().then("idle_ground", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation JUMP = RawAnimation.begin().thenPlayAndHold("jump_start");
    public static final RawAnimation LANDING = RawAnimation.begin().thenPlay("jump_landing");
    private static final int ATTACK_ANIM_TIME = 21;
    private final KrakenEntityHitboxes hitboxManager = new KrakenEntityHitboxes(this);
    public static final EntityDataAccessor<Float> HEALTH_WHEN_START_RIDING = SynchedEntityData.m_135353_(KrakenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> FALLING = SynchedEntityData.m_135353_(KrakenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float vehicleRotationProgress = 1.0f;
    private final float healthLossToBeReleased = 2.5f;

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FALLING, (Object)false);
    }

    public float getHealthWhenStartRiding() {
        return ((Float)this.f_19804_.m_135370_(HEALTH_WHEN_START_RIDING)).floatValue();
    }

    public void setHealthWhenStartRiding(float healthWhenStartRiding) {
        this.f_19804_.m_135381_(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(healthWhenStartRiding));
    }

    public void setIsFalling(boolean isFalling) {
        this.f_19804_.m_135381_(FALLING, (Object)isFalling);
    }

    public boolean isFalling() {
        return (Boolean)this.f_19804_.m_135370_(FALLING);
    }

    public KrakenEntity(EntityType<? extends WaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 50;
        this.f_21342_ = new LeviathanMoveControl((Mob)this, 85, 10, 0.3f, 0.5f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 20);
    }

    public static AttributeSupplier createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, (double)0.21f).m_22268_(Attributes.f_22277_, 64.0).m_22265_();
    }

    public static boolean surfaceWaterSpawnRulesDeepAndNotNearKraken(EntityType<? extends WaterAnimal> waterAnimal, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        int radiusToSearchKraken = 200;
        int seaLevel = level.m_5736_();
        int spawnLevel = seaLevel - 70;
        return random.m_188501_() <= 0.1f && pos.m_123342_() >= spawnLevel && pos.m_123342_() <= seaLevel && level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_) && level.m_6443_(KrakenEntity.class, new AABB((double)(pos.m_123341_() - radiusToSearchKraken), (double)(pos.m_123342_() - radiusToSearchKraken), (double)(pos.m_123343_() - radiusToSearchKraken), (double)(pos.m_123341_() + radiusToSearchKraken), (double)(pos.m_123342_() + radiusToSearchKraken), (double)(pos.m_123343_() + radiusToSearchKraken)), kraken -> true).isEmpty();
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new KrakenMeleeAttackGoal(this, 2.0, false));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new ExtraReachNearestAttackGoal<Player>((Mob)this, Player.class, 10, false, false, target -> target.m_20069_() || target.m_20202_() != null && target.m_20202_() instanceof Boat));
        this.f_21346_.m_25352_(2, new ExtraReachNearestAttackGoal<Villager>((Mob)this, Villager.class, 10, false, false, target -> target.m_20069_() || target.m_20202_() != null && target.m_20202_() instanceof Boat));
    }

    public boolean m_6779_(@NotNull LivingEntity target) {
        return super.m_6779_(target) && !(target.m_20202_() instanceof KrakenEntity) && !this.m_20160_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_20160_()) {
            this.vehicleRotationProgress = 0.0f;
        } else if (this.vehicleRotationProgress < 1.0f) {
            float speed = 0.05f;
            this.vehicleRotationProgress = Mth.m_14036_((float)(this.vehicleRotationProgress + speed), (float)0.0f, (float)1.0f);
        }
        if (this.m_20160_() && this.f_19797_ % 20 == 0) {
            Entity passenger = (Entity)this.m_20197_().get(0);
            passenger.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 2.0f);
            if (this.m_21223_() < this.m_21233_()) {
                double f;
                double e;
                double d;
                int i;
                this.m_5634_(2.0f);
                for (i = 0; i < 6; ++i) {
                    d = this.f_19796_.m_188583_() * 0.02;
                    e = this.f_19796_.m_188583_() * 0.02;
                    f = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123798_, passenger.m_20208_(1.0), passenger.m_20187_(), passenger.m_20262_(1.0), d, e, f);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, passenger.m_20208_(1.0), passenger.m_20187_(), passenger.m_20262_(1.0), d, e, f);
                }
                for (i = 0; i < 6; ++i) {
                    d = this.f_19796_.m_188583_() * 0.02;
                    e = this.f_19796_.m_188583_() * 0.02;
                    f = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175827_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d, e, f);
                }
                this.setHealthWhenStartRiding(this.getHealthWhenStartRiding() + 2.0f);
            }
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.m_20160_() && this.m_21223_() < this.getHealthWhenStartRiding() - 2.5f) {
            ((Entity)this.m_20197_().get(0)).m_8127_();
        }
        return super.m_6469_(source, amount);
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity passenger) {
        return new Vec3(passenger.m_20185_(), passenger.m_20191_().f_82292_, passenger.m_20189_());
    }

    protected void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            double y = this.m_20186_() + this.m_6048_() + passenger.m_6049_() - (GeoControllersUtil.isMoving((LivingEntity)this, 0.0015f) ? 4.8 : 2.8);
            float bodyYawRad = this.f_20883_ * ((float)Math.PI / 180);
            double forwardOffset = GeoControllersUtil.isMoving((LivingEntity)this, 0.0015f) ? -1.8 : -0.9;
            double sideOffset = GeoControllersUtil.isMoving((LivingEntity)this, 0.0015f) ? -3.2 : -2.1;
            double x = this.m_20185_() + (double)Mth.m_14031_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14089_((float)bodyYawRad) * sideOffset;
            double z = this.m_20189_() - (double)Mth.m_14089_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14031_((float)bodyYawRad) * sideOffset;
            callback.m_20372_(passenger, x, y, z);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 5, state -> {
            if (this.f_20911_ && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                state.getController().forceAnimationReset();
                state.getController().setAnimation(this.f_20912_.equals((Object)InteractionHand.OFF_HAND) ? GRAB_ATTACK_ANIM : SIMPLE_ATTACK_ANIM);
                CapabilityUtils.getLevelEventScheduler((Level)this.m_9236_()).addEvent((IEvent)new TimedEvent(() -> {
                    this.f_20911_ = false;
                }, 21));
            }
            return PlayState.CONTINUE;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Movement", 10, state -> {
            if (this.f_20911_) {
                return PlayState.STOP;
            }
            if (!state.isMoving()) {
                return state.setAndContinue(this.m_20069_() ? GeoControllersUtil.IDLE_ANIM : IDLE_GROUND);
            }
            if (state.isMoving()) {
                return state.setAndContinue(this.m_20069_() ? GeoControllersUtil.MOVE_ANIM : MOVE_GROUND);
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "JumpController", 1, state -> {
            if (this.isFalling()) {
                state.setAnimation(JUMP);
                return PlayState.CONTINUE;
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "LandingController", 1, state -> PlayState.STOP).triggerableAnim("landing", LANDING)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Die", 0, state -> GeoControllersUtil.commonWaterAnimalDie(state, (Mob)this))});
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new KrakenBodyRotationControl(this);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new BreachingWaterBoundPathNavigation((Mob)this, level);
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    public int m_21529_() {
        return 1;
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.008, 0.0));
            }
        } else {
            if (!this.m_20069_() && !this.isFalling()) {
                BlockPos waterPos = this.findNearestWater(this.m_20183_(), 64);
                if (waterPos != null && (this.m_9236_().m_8055_(waterPos.m_7494_()).m_60795_() || this.m_9236_().m_6425_(waterPos.m_7494_()).m_192917_((Fluid)Fluids.f_76193_))) {
                    waterPos = waterPos.m_122030_(this.f_19796_.m_216339_(0, 20));
                    waterPos = waterPos.m_122025_(this.f_19796_.m_216339_(0, 20));
                    waterPos = waterPos.m_122020_(this.f_19796_.m_216339_(0, 20));
                    waterPos = waterPos.m_122013_(this.f_19796_.m_216339_(0, 20));
                    Vec3 direction = Vec3.m_82512_((Vec3i)waterPos).m_82546_(this.m_20182_()).m_82541_();
                    Vec3 jumpVec = new Vec3(direction.f_82479_ * 0.8, 0.8, direction.f_82481_ * 0.8);
                    this.m_20256_(jumpVec);
                } else {
                    waterPos = new BlockPos(this.m_20183_().m_123341_() + this.f_19796_.m_216332_(1, 20), this.m_20183_().m_123342_(), this.m_20183_().m_123343_() + this.f_19796_.m_216332_(1, 20));
                    Vec3 direction = Vec3.m_82512_((Vec3i)waterPos).m_82546_(this.m_20182_()).m_82541_();
                    this.m_20256_(new Vec3(direction.f_82479_ * 0.8, 0.8, direction.f_82481_ * 0.8));
                }
                this.m_6135_();
                this.setIsFalling(true);
            }
            super.m_7023_(travelVector);
        }
    }

    @Nullable
    private BlockPos findNearestWater(BlockPos origin, int radius) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    mutable.m_122178_(origin.m_123341_() + dx, origin.m_123342_() + dy, origin.m_123343_() + dz);
                    if (!this.m_9236_().m_8055_((BlockPos)mutable).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) continue;
                    return mutable.m_7949_();
                }
            }
        }
        return null;
    }

    protected float m_6118_() {
        return 1.5f * this.m_20098_() + this.m_285755_();
    }

    public void m_183634_() {
        if (this.isFalling()) {
            this.setIsFalling(false);
            this.triggerAnim("LandingController", "landing");
            this.m_5496_(SoundEvents.f_12037_, 1.0f, 1.0f);
        }
        super.m_183634_();
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        return super.m_5639_(fallDistance, damageMultiplier) - 20;
    }

    public boolean m_7327_(@NotNull Entity target) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SoundUtils.playSound((ServerLevel)serverLevel, (Vec3)this.m_20182_(), (SoundEvent)((SoundEvent)MTSSounds.KRAKEN_ATTACK.get()), (SoundSource)SoundSource.HOSTILE, (float)3.0f, (double)6.0);
        }
        return super.m_7327_(target);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MTSSounds.KRAKEN_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)MTSSounds.KRAKEN_DAMAGE.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)MTSSounds.KRAKEN_DEATH.get();
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public EntityBounds getBounds() {
        return this.hitboxManager.getHitbox();
    }

    public void onSetPos(double x, double y, double z) {
        if (this.hitboxManager != null) {
            this.hitboxManager.updatePosition();
        }
    }

    public void setNextDamagedPart(@Nullable String part) {
    }

    public CompoundOrientedBox getCompoundBoundingBox(AABB bounds) {
        return this.hitboxManager.getHitbox().getBox(bounds);
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.5f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    protected void m_6153_() {
        if (this.m_20160_()) {
            Entity prey = (Entity)this.m_20197_().get(0);
            prey.m_8127_();
        }
        CapabilityUtils.getLevelEventScheduler((Level)this.m_9236_()).addEvent((IEvent)new TimedEvent(() -> super.m_6153_(), 80));
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("HealthWhenStarted", this.getHealthWhenStartRiding());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setHealthWhenStartRiding(compound.m_128457_("HealthWhenStarted"));
    }

    protected void m_6229_(int airSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(this.m_6062_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21525_()) {
            this.m_20301_(this.m_6062_());
        }
        if (this.m_20096_() && !this.m_20069_() && !this.m_21224_()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.8, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_6853_(false);
            this.f_19812_ = true;
        }
    }

    public int m_6062_() {
        return 4800;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)MTSItems.KRAKEN_SPAWN_EGG.get());
    }
}

