/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.forge.datagen.providers;

import com.cerbon.cerbons_api.api.registry.RegistryEntry;
import com.cerbon.myths_of_the_sea.sound.MTSSounds;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;

public class MTSSoundDefinitionsProvider
extends SoundDefinitionsProvider {
    public MTSSoundDefinitionsProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "myths_of_the_sea", helper);
    }

    public void registerSounds() {
        this.addSound(MTSSounds.ABAIA_IDLE, 4);
        this.addSound(MTSSounds.ABAIA_MOVEMENT, 1);
        this.addSound(MTSSounds.ABAIA_DAMAGE, 3);
        this.addSound(MTSSounds.ABAIA_ATTACK, 3);
        this.addSound(MTSSounds.ABAIA_DEATH, 3);
        this.addSpecificSound(MTSSounds.ABAIA_FLOP, List.of("minecraft:mob/guardian/flop1", "minecraft:mob/guardian/flop2", "minecraft:mob/guardian/flop3", "minecraft:mob/guardian/flop4"));
        this.addSound(MTSSounds.BAKE_KUJIRA_IDLE, 3);
        this.addSound(MTSSounds.BAKE_KUJIRA_MOVEMENT, 4);
        this.addSound(MTSSounds.BAKE_KUJIRA_DAMAGE, 4);
        this.addSound(MTSSounds.BAKE_KUJIRA_ATTACK, 4);
        this.addSound(MTSSounds.BAKE_KUJIRA_DEATH, 4);
        this.addSpecificSound(MTSSounds.BAKE_KUJIRA_FLOP, List.of("minecraft:entity/fish/flop1", "minecraft:entity/fish/flop2", "minecraft:entity/fish/flop3", "minecraft:entity/fish/flop4"));
        this.addSound(MTSSounds.BUNYIP_IDLE, 4);
        this.addSound(MTSSounds.BUNYIP_MOVEMENT, 5);
        this.addSound(MTSSounds.BUNYIP_DAMAGE, 3);
        this.addSound(MTSSounds.BUNYIP_ATTACK, 5);
        this.addSound(MTSSounds.BUNYIP_DEATH, 3);
        this.addSound(MTSSounds.LEVIATHAN_IDLE, 6);
        this.addSound(MTSSounds.LEVIATHAN_MOVEMENT, 3);
        this.addSound(MTSSounds.LEVIATHAN_DAMAGE, 3);
        this.addSound(MTSSounds.LEVIATHAN_ATTACK, 3);
        this.addSound(MTSSounds.LEVIATHAN_DEATH, 3);
        this.addSound(MTSSounds.HIPPOCAMPUS_IDLE, 3);
        this.addSound(MTSSounds.HIPPOCAMPUS_DAMAGE, 3);
        this.addSound(MTSSounds.HIPPOCAMPUS_ATTACK, 3);
        this.addSound(MTSSounds.HIPPOCAMPUS_DEATH, 3);
        this.addSpecificSound(MTSSounds.HIPPOCAMPUS_FLOP, List.of("minecraft:mob/guardian/flop1", "minecraft:mob/guardian/flop2", "minecraft:mob/guardian/flop3", "minecraft:mob/guardian/flop4"));
        this.addSpecificSound(MTSSounds.HIPPOCAMPUS_EAT, List.of("minecraft:mob/dolphin/eat1", "minecraft:mob/dolphin/eat2", "minecraft:mob/dolphin/eat3"));
        this.addSound(MTSSounds.KRAKEN_IDLE, 3);
        this.addSound(MTSSounds.KRAKEN_DAMAGE, 3);
        this.addSound(MTSSounds.KRAKEN_ATTACK, 3);
        this.addSound(MTSSounds.KRAKEN_DEATH, 3);
    }

    private void addSpecificSound(RegistryEntry<SoundEvent> sound, List<String> names) {
        SoundDefinition definition = MTSSoundDefinitionsProvider.definition().subtitle("subtitles.myths_of_the_sea." + sound.getId().m_135815_());
        for (String name : names) {
            definition.with(MTSSoundDefinitionsProvider.sound((String)name));
        }
        this.add((SoundEvent)sound.get(), definition);
    }

    private void addSound(RegistryEntry<SoundEvent> sound, int soundVariationAmount) {
        SoundDefinition definition = MTSSoundDefinitionsProvider.definition().subtitle("subtitles.myths_of_the_sea." + sound.getId().m_135815_());
        for (int i = 1; i <= soundVariationAmount; ++i) {
            definition.with(MTSSoundDefinitionsProvider.sound((String)("myths_of_the_sea:" + sound.getId().m_135815_() + i)));
        }
        this.add((SoundEvent)sound.get(), definition);
    }
}

