/*
 * Decompiled with CFR 0.152.
 */
package com.alrexu.parcool.compat.extern;

import com.alrexu.parcool.compat.extern.IModManager;
import com.alrexu.parcool.compat.extern.bettercombat.BetterCombatManager;
import com.alrexu.parcool.compat.extern.carryon.CarryOnManager;
import com.alrexu.parcool.compat.extern.firstpersonmodel.FirstPersonModelManager;
import com.alrexu.parcool.compat.extern.playeranimator.PlayerAnimatorManager;
import com.alrexu.parcool.compat.extern.realcamera.RealCameraManager;
import com.alrexu.parcool.compat.extern.tacz.TaCZManager;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;

public class ExternalModManager {
    private static final List<IModManager> MOD_MANAGERS = List.of(new BetterCombatManager(), new TaCZManager(), new PlayerAnimatorManager(), new CarryOnManager(), new RealCameraManager(), new FirstPersonModelManager());

    public static void init(IEventBus modBus, IEventBus forgeBus) {
        for (IModManager manager : MOD_MANAGERS) {
            manager.init(modBus, forgeBus);
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MOD_MANAGERS.forEach(manager -> manager.initInClient(modBus, forgeBus)));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> MOD_MANAGERS.forEach(manager -> manager.initInDedicatedServer(modBus, forgeBus)));
    }

    public static <T extends IModManager> T get(Class<T> clazz) {
        for (IModManager manager : MOD_MANAGERS) {
            if (!clazz.isInstance(manager)) continue;
            return (T)manager;
        }
        throw new IllegalArgumentException("ModManager [" + clazz.getSimpleName() + "] is not registered");
    }
}

