/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.crafting.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class TypeDisabledCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("spartanshields", "type_disabled");
    private static final Set<String> disabledRecipeTypes = new HashSet<String>();
    public static final String MODDED = "modded";
    public static final String OBSIDIAN = "obsidian";
    public static final String COPPER = "copper";
    public static final String TIN = "tin";
    public static final String BRONZE = "bronze";
    public static final String STEEL = "steel";
    public static final String SILVER = "silver";
    public static final String ELECTRUM = "electrum";
    public static final String LEAD = "lead";
    public static final String NICKEL = "nickel";
    public static final String INVAR = "invar";
    public static final String CONSTANTAN = "constantan";
    public static final String PLATINUM = "platinum";
    public static final String ALUMINUM = "aluminum";
    public static final String SIGNALUM = "signalum";
    public static final String LUMIUM = "lumium";
    public static final String ENDERIUM = "enderium";
    private final List<String> types;

    public TypeDisabledCondition(List<String> types) {
        this.types = types;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        for (String type : this.types) {
            if (!disabledRecipeTypes.contains(type)) continue;
            return false;
        }
        return true;
    }

    public static void clear() {
        disabledRecipeTypes.clear();
    }

    public static void updateType(String type, boolean disabled) {
        boolean containsValue = disabledRecipeTypes.contains(type);
        if (!containsValue && disabled) {
            disabledRecipeTypes.add(type);
        } else if (containsValue) {
            disabledRecipeTypes.remove(type);
        }
    }

    public static class Serializer
    implements IConditionSerializer<TypeDisabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, TypeDisabledCondition value) {
            JsonArray array = new JsonArray();
            for (String type : value.types) {
                array.add(type);
            }
            json.add("disabled", (JsonElement)array);
        }

        public TypeDisabledCondition read(JsonObject json) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"disabled");
            ArrayList<String> typeList = new ArrayList<String>();
            for (int i = 0; i < array.size(); ++i) {
                String str = array.get(i).getAsString();
                typeList.add(str);
            }
            return new TypeDisabledCondition(typeList);
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

