/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import com.oblivioussp.spartanweaponry.api.IReloadable;
import com.oblivioussp.spartanweaponry.api.ReloadableHandler;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.client.OilCoatingColours;
import com.oblivioussp.spartanweaponry.init.ModOilRecipes;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.WeaponArchetype;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ReloadResourceEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onUpdateTags(TagsUpdatedEvent ev) {
        List<WeaponMaterial> materialReloadList = ReloadableHandler.getMaterialReloadList();
        List<IReloadable> itemReloadList = ReloadableHandler.getItemReloadList();
        Log.debug("Initaliasing reloadables for " + materialReloadList.size() + " materials, " + WeaponArchetype.ALL_ARCHETYPES.size() + " archetypes and " + itemReloadList.size() + " items");
        long start = System.nanoTime();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> OilCoatingColours::reload);
        materialReloadList.forEach(material -> material.reload());
        WeaponArchetype.ALL_ARCHETYPES.forEach(archetype -> archetype.reload());
        itemReloadList.forEach(item -> item.reload());
        long end = System.nanoTime();
        double milliseconds = (double)(end - start) / 1000000.0;
        ModOilRecipes.loadOilMixes();
        Log.info("Finished initialising Weapon Traits & Attributes! Took " + milliseconds + "ms");
    }
}

