/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.oblivioussp.spartanweaponry.api.IReloadable;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.ReloadableHandler;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.IGenericTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IThrowingTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.client.ClientHelper;
import com.oblivioussp.spartanweaponry.client.gui.HudCrosshairThrowingWeapon;
import com.oblivioussp.spartanweaponry.client.gui.ICrosshairOverlay;
import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import com.oblivioussp.spartanweaponry.item.IHudCrosshair;
import com.oblivioussp.spartanweaponry.util.ClientConfig;
import com.oblivioussp.spartanweaponry.util.WeaponArchetype;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class ThrowingWeaponItem
extends Item
implements IWeaponTraitContainer<ThrowingWeaponItem>,
IReloadable,
IHudCrosshair {
    public static final String NBT_AMMO_USED = "AmmoUsed";
    public static final String NBT_UUID = "UUID";
    public static final String NBT_ORIGINAL = "Original";
    protected float attackDamage = 1.0f;
    protected double attackSpeed = 0.0;
    protected float throwVelocity = 2.0f;
    protected float throwDamageMultiplier = 2.0f;
    protected WeaponMaterial material;
    protected String customDisplayName = null;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;
    protected int maxAmmo = 1;
    protected int maxChargeTicks = 5;
    protected Multimap<Attribute, AttributeModifier> modifiers;
    protected final WeaponArchetype archetype;
    protected List<WeaponTrait> traits;

    public ThrowingWeaponItem(Item.Properties prop, WeaponMaterial materialIn, WeaponArchetype archetypeIn, float weaponBaseDamage, float weaponDamageMultiplier, float weaponSpeed, int maxAmmoCapacity, int chargeTicks) {
        super(prop.m_41503_(materialIn.m_6609_() / 4));
        this.material = materialIn;
        this.setAttackDamage(weaponBaseDamage, weaponDamageMultiplier);
        this.setAttackSpeed(weaponSpeed);
        this.maxAmmo = maxAmmoCapacity;
        this.setChargeTicks(chargeTicks);
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerThrowingWeaponPropertyOverrides(this);
        }
        this.archetype = archetypeIn;
        ReloadableHandler.addToItemReloadList(this);
    }

    public ThrowingWeaponItem(Item.Properties prop, WeaponMaterial material, WeaponArchetype archetypeIn, float weaponBaseDamage, float weaponDamageMultiplier, float weaponSpeed, int maxAmmoCapacity, int chargeTicks, String customDisplayNameIn) {
        this(prop, material, archetypeIn, weaponBaseDamage, weaponDamageMultiplier, weaponSpeed, maxAmmoCapacity, chargeTicks);
        if (material.useCustomDisplayName()) {
            this.customDisplayName = customDisplayNameIn;
        }
    }

    @Override
    public void reload() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.archetype.getTraits());
        builder.addAll(this.material.getBonusTraits(this.archetype.getType()));
        this.traits = builder.build();
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        mapBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getDirectAttackDamage(), AttributeModifier.Operation.ADDITION));
        mapBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.attackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
        this.traits.forEach(trait -> this.getGenericCallback((WeaponTrait)trait).ifPresent(callback -> callback.onModifyAttributes((ImmutableMultimap.Builder<Attribute, AttributeModifier>)mapBuilder)));
        this.modifiers = mapBuilder.build();
        WeaponTrait extraDamageTrait = this.getFirstWeaponTraitWithType("extra_damage_thrown");
        this.throwDamageMultiplier = extraDamageTrait != null ? extraDamageTrait.getMagnitude() : 1.0f;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return this.modifiers != null && slot == EquipmentSlot.MAINHAND ? this.modifiers : super.getAttributeModifiers(slot, stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        this.initNBT(stack, true);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.traits != null) {
                this.traits.forEach(trait -> this.getGenericCallback((WeaponTrait)trait).ifPresent(callback -> callback.onItemUpdate(this.material, stack, level, living, itemSlot, isSelected)));
            }
        }
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.archetype.isBladed() && state.m_60713_(Blocks.f_50033_) ? 15.0f : 1.0f;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!level.f_46443_ && state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            this.damageThrowingWeapon(stack, 2, entityLiving);
        }
        return false;
    }

    public void damageThrowingWeapon(ItemStack stack, int damage, LivingEntity entity) {
        if (stack.m_41763_() && stack.m_41784_().m_128451_(NBT_AMMO_USED) < this.getMaxAmmo(stack) && (!(entity instanceof Player) || !((Player)entity).m_150110_().f_35937_) && stack.m_220157_(damage, entity.m_217043_(), entity instanceof ServerPlayer ? (ServerPlayer)entity : null)) {
            InteractionHand breakHand;
            Object object = stack == entity.m_21206_() ? InteractionHand.OFF_HAND : (breakHand = stack == entity.m_21205_() ? InteractionHand.MAIN_HAND : null);
            if (breakHand != null) {
                entity.m_21190_(breakHand);
            }
            int ammo = stack.m_41783_().m_128451_(NBT_AMMO_USED);
            stack.m_41783_().m_128405_(NBT_AMMO_USED, ++ammo);
            if (entity instanceof Player) {
                ((Player)entity).m_36246_(Stats.f_12983_.m_12902_((Object)stack.m_41720_()));
            }
            stack.m_41721_(0);
        }
    }

    public Component m_7626_(ItemStack stack) {
        if (this.customDisplayName == null) {
            return super.m_7626_(stack);
        }
        return Component.m_237110_((String)this.customDisplayName, (Object[])new Object[]{this.material.translateName()});
    }

    public void m_7373_(ItemStack stack, Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        boolean isShiftPressed = Screen.m_96638_();
        if (this.doCraftCheck && levelIn != null) {
            ITagManager tagManager;
            if (!(((Boolean)ClientConfig.INSTANCE.forceDisableUncraftableTooltips.get()).booleanValue() || this.material.getModId() != "spartanweaponry" || (tagManager = ForgeRegistries.ITEMS.tags()).isKnownTagName(this.material.getRepairTag()) && !tagManager.getTag(this.material.getRepairTag()).isEmpty())) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        }
        if (!this.canBeCrafted) {
            tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.uncraftable_missing_material", "spartanweaponry"), (Object[])new Object[]{this.material.getRepairTagName()}).m_130940_(ChatFormatting.RED));
        }
        this.archetype.addTagErrorTooltip(stack, tooltip);
        this.material.addTagErrorTooltip(stack, tooltip);
        if (stack.m_41784_().m_128441_(NBT_ORIGINAL) && !stack.m_41783_().m_128471_(NBT_ORIGINAL)) {
            tooltip.add((Component)Component.m_237115_((String)String.format("tooltip.%s.throwable.not_original", "spartanweaponry")).m_130940_(ChatFormatting.DARK_RED));
        }
        if (stack.m_41783_().m_128403_(NBT_UUID) && flagIn.m_7050_()) {
            tooltip.add((Component)Component.m_237113_((String)("UUID: " + ChatFormatting.GRAY.toString() + stack.m_41783_().m_128342_(NBT_UUID).toString())).m_130940_(ChatFormatting.DARK_PURPLE));
        }
        int mxAmmo = this.getMaxAmmo(stack);
        tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.throwable.ammo", "spartanweaponry"), (Object[])new Object[]{Component.m_237110_((String)String.format("tooltip.%s.throwable.ammo.value", "spartanweaponry"), (Object[])new Object[]{mxAmmo - stack.m_41783_().m_128451_(NBT_AMMO_USED), mxAmmo}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.throwable.charge_time", "spartanweaponry"), (Object[])new Object[]{Component.m_237110_((String)String.format("tooltip.%s.throwable.charge_time.value", "spartanweaponry"), (Object[])new Object[]{Float.valueOf((float)this.getMaxChargeTicks(stack) / 20.0f)}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        if (this.traits != null && !this.traits.isEmpty()) {
            if (isShiftPressed) {
                tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.traits", "spartanweaponry"), (Object[])new Object[]{Component.m_237115_((String)"tooltip.spartanweaponry.showing_details").m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.traits", "spartanweaponry"), (Object[])new Object[]{Component.m_237110_((String)"tooltip.spartanweaponry.show_details", (Object[])new Object[]{ChatFormatting.AQUA.toString() + "SHIFT"}).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
            }
            this.archetype.addTraitsToTooltip(stack, tooltip, isShiftPressed);
            this.material.addTraitsToTooltip(stack, this.archetype.getType(), tooltip, isShiftPressed);
            tooltip.add((Component)Component.m_237119_());
        }
        super.m_7373_(stack, levelIn, tooltip, flagIn);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.traits.forEach(trait -> trait.getMeleeCallback().ifPresent(callback -> callback.onHitEntity(this.material, stack, target, attacker, null)));
        if (stack.m_41784_().m_128451_(NBT_AMMO_USED) < this.getMaxAmmo(stack)) {
            this.damageThrowingWeapon(stack, 2, attacker);
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41784_().m_128451_(NBT_AMMO_USED) == this.getMaxAmmo(stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level levelIn, LivingEntity entityLiving, int timeLeft) {
        int maxAmmo;
        int ammoCount;
        if (entityLiving instanceof Player && (ammoCount = (maxAmmo = this.getMaxAmmo(stack)) - stack.m_41784_().m_128451_(NBT_AMMO_USED)) > 0) {
            Player player = (Player)entityLiving;
            int maxCharge = this.getMaxChargeTicks(stack);
            int charge = Math.min(this.m_8105_(stack) - timeLeft, maxCharge);
            if (!levelIn.f_46443_ && charge > 2) {
                ThrowingWeaponEntity thrown = this.createThrowingWeaponEntity(levelIn, player, stack, charge);
                float chargePerc = (float)charge / (float)maxCharge;
                if (thrown == null) {
                    return;
                }
                thrown.setWeapon(stack);
                int velocityBonus = stack.getEnchantmentLevel((Enchantment)ModEnchantments.PROPEL.get());
                thrown.m_37251_((Entity)player, player.f_19860_, player.f_19859_, 0.0f, this.throwVelocity * ((float)velocityBonus * 0.2f + 1.0f) * (chargePerc * 0.9f + 0.1f), 0.5f);
                this.traits.forEach(trait -> trait.getThrowingCallback().ifPresent(callback -> callback.onThrowingProjectileSpawn(this.material, thrown)));
                double damageMultiplier = (this.throwDamageMultiplier - 1.0f) * chargePerc + 1.0f;
                thrown.m_36781_(((double)this.getDirectAttackDamage() + 1.0) * damageMultiplier);
                int j = stack.getEnchantmentLevel((Enchantment)ModEnchantments.RAZORS_EDGE.get());
                if (j > 0) {
                    thrown.m_36781_(thrown.m_36789_() + (double)j * 0.5 + 0.5);
                }
                if (stack.getEnchantmentLevel((Enchantment)ModEnchantments.INCENDIARY.get()) > 0) {
                    thrown.m_20254_(100);
                }
                if (player.m_150110_().f_35937_) {
                    thrown.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (thrown.isValidThrowingWeapon()) {
                    stack.m_41784_().m_128405_(NBT_AMMO_USED, maxAmmo - --ammoCount);
                    if (ammoCount == 0 && !stack.m_41783_().m_128471_(NBT_ORIGINAL)) {
                        stack.m_41774_(1);
                        if (stack.m_41613_() <= 0) {
                            player.m_150109_().m_36057_(stack);
                        }
                    }
                }
                if (thrown.isValidThrowingWeapon()) {
                    stack.m_41721_(0);
                    levelIn.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getThrowingSound(), SoundSource.PLAYERS, 0.5f, 0.4f / (levelIn.f_46441_.m_188501_() * 0.4f + 0.8f));
                    levelIn.m_7967_((Entity)thrown);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
        super.m_5551_(stack, levelIn, entityLiving, timeLeft);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void m_7836_(ItemStack stack, Level levelIn, Player playerIn) {
        this.traits.forEach(trait -> this.getGenericCallback((WeaponTrait)trait).ifPresent(callback -> callback.onCreateItem(this.material, stack)));
        this.initNBT(stack, true);
    }

    public ItemStack makeTabStack() {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.initNBT(stack, false);
        return stack;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.material.m_6601_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment == Enchantments.f_44955_;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int damage = amount;
        for (WeaponTrait trait : this.traits) {
            if (trait.getGenericCallback().isPresent()) {
                damage = trait.getGenericCallback().get().onDamageItem(stack, entity, damage);
            }
            if (damage > 0) continue;
            break;
        }
        return Math.max(0, damage);
    }

    @Override
    public ThrowingWeaponItem getAsItem() {
        return this;
    }

    @Override
    public boolean hasWeaponTrait(WeaponTrait prop) {
        return this.traits.contains(prop);
    }

    @Override
    public boolean hasWeaponTraitWithType(String type) {
        return this.traits.stream().anyMatch(trait -> trait.getType() == type);
    }

    @Override
    public WeaponTrait getFirstWeaponTraitWithType(String type) {
        for (WeaponTrait trait : this.traits) {
            if (trait.getType() != type) continue;
            return trait;
        }
        return null;
    }

    @Override
    public List<WeaponTrait> getAllWeaponTraitsWithType(String type) {
        if (this.traits.isEmpty()) {
            return ImmutableList.of();
        }
        return this.traits.stream().filter(trait -> trait.getType() == type).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Collection<WeaponTrait> getAllWeaponTraits() {
        return this.traits;
    }

    @Override
    public WeaponMaterial getMaterial() {
        return this.material;
    }

    public float getDirectAttackDamage() {
        return this.attackDamage;
    }

    public void setAttackDamage(float baseDamage, float damageMultiplier) {
        this.attackDamage = this.material.m_6631_() * damageMultiplier + baseDamage - 1.0f;
    }

    public void setAttackSpeed(double speed) {
        this.attackSpeed = speed;
    }

    public void setChargeTicks(int chargeTicks) {
        this.maxChargeTicks = chargeTicks;
    }

    private Optional<IGenericTraitCallback> getGenericCallback(WeaponTrait trait) {
        return trait.getMeleeCallback().isPresent() ? Optional.of((IGenericTraitCallback)trait.getMeleeCallback().get()) : (trait.getGenericCallback().isPresent() ? trait.getGenericCallback() : Optional.empty());
    }

    public void updateFromConfig(float baseDamage, float damageMultiplier, double speed, int chargeTicks) {
        this.setAttackDamage(baseDamage, damageMultiplier);
        this.setAttackSpeed(speed);
        this.setChargeTicks(chargeTicks);
    }

    public ThrowingWeaponEntity createThrowingWeaponEntity(Level levelIn, Player player, ItemStack stack, int charge) {
        return new ThrowingWeaponEntity((EntityType<? extends ThrowingWeaponEntity>)((EntityType)ModEntities.THROWING_WEAPON.get()), (LivingEntity)player, levelIn);
    }

    protected SoundEvent getThrowingSound() {
        return (SoundEvent)ModSounds.THROWN_WEAPON_THROW.get();
    }

    protected void initNBT(ItemStack stack, boolean initUUID) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(NBT_AMMO_USED)) {
            tag.m_128405_(NBT_AMMO_USED, 0);
        }
        if (initUUID && !tag.m_128403_(NBT_UUID)) {
            stack.m_41783_().m_128362_(NBT_UUID, UUID.randomUUID());
            stack.m_41783_().m_128379_(NBT_ORIGINAL, true);
        }
    }

    public int getMaxAmmo(ItemStack stack) {
        int level = stack.getEnchantmentLevel((Enchantment)ModEnchantments.EXPANSE.get());
        int increasePerLevel = Math.max((int)((float)this.maxAmmo * 0.25f), 1);
        return this.maxAmmo + increasePerLevel * level;
    }

    public int getMaxAmmoBase() {
        return this.maxAmmo;
    }

    public int getMaxChargeTicks(ItemStack stack) {
        int chargeTicks = (int)((float)this.maxChargeTicks * (1.0f - (float)stack.getEnchantmentLevel((Enchantment)ModEnchantments.SUPERCHARGE.get()) * 0.2f));
        if (this.traits != null) {
            for (WeaponTrait trait : this.traits) {
                Optional<IThrowingTraitCallback> opt = trait.getThrowingCallback();
                if (!opt.isPresent()) continue;
                chargeTicks = opt.get().modifyThrowingChargeTime(this.material, chargeTicks);
            }
        }
        return chargeTicks;
    }

    @Override
    public ICrosshairOverlay getCrosshairHudElement() {
        return HudCrosshairThrowingWeapon::render;
    }
}

