/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGTags;
import quek.undergarden.world.gen.structure.BiggerJigsawStructure;
import quek.undergarden.world.gen.structure.processor.NoWaterloggingProcessor;

public class UGStructures {
    public static final DeferredRegister<StructureType<?>> STRUCTURES = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"undergarden");
    public static final RegistryObject<StructureType<BiggerJigsawStructure>> BIGGER_JIGSAW = STRUCTURES.register("bigger_jigsaw", () -> () -> BiggerJigsawStructure.CODEC);
    public static final ResourceKey<Structure> CATACOMBS = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("undergarden", "catacombs"));
    public static final ResourceKey<StructureSet> CATACOMBS_SET = ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)new ResourceLocation("undergarden", "catacombs"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_START = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("undergarden", "catacombs/catacombs_entrance"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_CHEST = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("undergarden", "catacombs/chest_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_INTERIOR = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("undergarden", "catacombs/interior_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_TUNNEL = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("undergarden", "catacombs/tunnel_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_WAY = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("undergarden", "catacombs/way_pool"));
    public static final ResourceKey<StructureProcessorList> CATACOMBS_DEGRADATION = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("undergarden", "catacombs_degradation"));
    public static final ResourceKey<Structure> FORGOTTEN_VESTIGE = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("undergarden", "forgotten_vestige"));
    public static final ResourceKey<StructureSet> FORGOTTEN_VESTIGE_SET = ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)new ResourceLocation("undergarden", "forgotten_vestige"));
    public static final ResourceKey<StructureTemplatePool> FORGOTTEN_VESTIGE_POOL = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("undergarden", "forgotten_vestige"));
    public static final ResourceKey<StructureProcessorList> FORGOTTEN_VESTIGE_DEGRADATION = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("undergarden", "forgotten_vestige_degradation"));

    public static void bootstrapStructures(BootstapContext<Structure> context) {
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        HolderGetter pools = context.m_255420_(Registries.f_256948_);
        context.m_255272_(CATACOMBS, (Object)new BiggerJigsawStructure(new Structure.StructureSettings((HolderSet)biomes.m_254956_(UGTags.Biomes.HAS_CATACOMBS), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.FORGOTTEN.get(), 1, 1, 1)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.m_255043_(CATACOMBS_START), Optional.empty(), 25, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158930_((int)48)), Optional.empty(), 116));
        context.m_255272_(FORGOTTEN_VESTIGE, (Object)new BiggerJigsawStructure(new Structure.StructureSettings((HolderSet)biomes.m_254956_(UGTags.Biomes.HAS_FORGOTTEN_VESTIGE), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.m_255043_(FORGOTTEN_VESTIGE_POOL), Optional.empty(), 5, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)32), (VerticalAnchor)VerticalAnchor.f_158916_), Optional.empty(), 10));
    }

    public static void bootstrapSets(BootstapContext<StructureSet> context) {
        HolderGetter structures = context.m_255420_(Registries.f_256944_);
        context.m_255272_(CATACOMBS_SET, (Object)new StructureSet((Holder)structures.m_255043_(CATACOMBS), (StructurePlacement)new RandomSpreadStructurePlacement(24, 12, RandomSpreadType.LINEAR, 276320045)));
        context.m_255272_(FORGOTTEN_VESTIGE_SET, (Object)new StructureSet((Holder)structures.m_255043_(FORGOTTEN_VESTIGE), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.f_123288_, StructurePlacement.FrequencyReductionMethod.DEFAULT, 0.85f, 276320046, Optional.empty(), 6, 3, RandomSpreadType.LINEAR)));
    }

    public static void bootstrapPools(BootstapContext<StructureTemplatePool> context) {
        Holder.Reference emptyPool = context.m_255420_(Registries.f_256948_).m_255043_(Pools.f_127186_);
        HolderGetter processors = context.m_255420_(Registries.f_257011_);
        context.m_255272_(CATACOMBS_START, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/entrance").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(CATACOMBS_CHEST, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210526_((String)"minecraft:empty"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210526_((String)new ResourceLocation("undergarden", "catacombs/chest").toString()), (Object)2), (Object)Pair.of((Object)StructurePoolElement.m_210526_((String)new ResourceLocation("undergarden", "catacombs/chest_forgotten").toString()), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(CATACOMBS_INTERIOR, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/interior1").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/interior2").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/interior3").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/interior4").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(CATACOMBS_TUNNEL, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/way_pool").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/tunnel1").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/tunnel2").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/tunnel3").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)50), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/tunnel4").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)50), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/tunnel5").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/tunnel6").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/tunnel7").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)50), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/room1").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)50), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/room2").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/room3").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/tunnel_guardian").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)25), (Object[])new Pair[0]), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(CATACOMBS_WAY, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/entrance").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/4way").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)25), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/3way").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)50), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/2way").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)75), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "catacombs/1way").toString(), (Holder)processors.m_255043_(CATACOMBS_DEGRADATION)), (Object)100)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(FORGOTTEN_VESTIGE_POOL, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_1").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_2").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_3").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_4").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_5").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_6").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/face_1").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/face_2").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/face_3").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_1").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_2").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_3").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object[])new Pair[]{Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_4").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_5").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_6").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_1").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_2").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_3").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_4").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_5").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.m_210531_((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_6").toString(), (Holder)processors.m_255043_(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1)}), StructureTemplatePool.Projection.RIGID));
    }

    public static void bootstrapProcessors(BootstapContext<StructureProcessorList> context) {
        context.m_255272_(CATACOMBS_DEGRADATION, (Object)new StructureProcessorList(List.of(new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.DEPTHROCK_BRICKS.get(), 0.5f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)UGBlocks.CRACKED_DEPTHROCK_BRICKS.get()).m_49966_()))), new NoWaterloggingProcessor())));
        context.m_255272_(FORGOTTEN_VESTIGE_DEGRADATION, (Object)new StructureProcessorList(List.of(new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.DEPTHROCK_BRICKS.get(), 0.25f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)UGBlocks.CRACKED_DEPTHROCK_BRICKS.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.SHIVERSTONE_BRICKS.get(), 0.25f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)UGBlocks.CRACKED_SHIVERSTONE_BRICKS.get()).m_49966_()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.CLOGGRUM_BLOCK.get(), 0.5f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)UGBlocks.RAW_CLOGGRUM_BLOCK.get()).m_49966_()))))));
    }
}

