/*
 * Decompiled with CFR 0.152.
 */
package com.tofu26.a2w.mixin;

import com.tofu26.a2w.network.ChangeExperiencePacket;
import com.tofu26.a2w.network.TeleportToWaystoneMessage;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.IWaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneTeleportContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import pepjebs.mapatlases.client.screen.DecorationBookmarkButton;
import pepjebs.mapatlases.client.screen.MapWidget;

@Mixin(value={MapWidget.class})
public class ClickMixin {
    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void printCoordinatesOnClick(double mouseX, double mouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        MapWidget widget = (MapWidget)this;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Collection activatedWaystones = WaystonesAPI.getActivatedWaystones((Player)player);
        try {
            Field mapScreenField = MapWidget.class.getDeclaredField("mapScreen");
            mapScreenField.setAccessible(true);
            Object mapScreen = mapScreenField.get(widget);
            if (mapScreen == null) {
                return;
            }
            Field isHoveredField = MapWidget.class.getDeclaredField("isHovered");
            isHoveredField.setAccessible(true);
            boolean isHovered = (Boolean)isHoveredField.get(widget);
            if (!isHovered) {
                return;
            }
            Method getHoveredPosMethod = MapWidget.class.getDeclaredMethod("getHoveredPos", Double.TYPE, Double.TYPE);
            getHoveredPosMethod.setAccessible(true);
            ColumnPos playerPos = (ColumnPos)getHoveredPosMethod.invoke((Object)widget, mouseX, mouseY);
            Method getSelectedSliceMethod = mapScreen.getClass().getDeclaredMethod("getSelectedSlice", new Class[0]);
            getSelectedSliceMethod.setAccessible(true);
            Object selectedSlice = getSelectedSliceMethod.invoke(mapScreen, new Object[0]);
            if (selectedSlice == null) {
                throw new NullPointerException("selectedSlice is null");
            }
            Field zoomLevelField = MapWidget.class.getDeclaredField("targetZoomLevel");
            zoomLevelField.setAccessible(true);
            float zoomLevel = zoomLevelField.getFloat(widget);
            int hoverAreaRadius = 4 + Math.round(4.0f * zoomLevel);
            Method dimensionMethod = selectedSlice.getClass().getDeclaredMethod("dimension", new Class[0]);
            dimensionMethod.setAccessible(true);
            Object dimension = dimensionMethod.invoke(selectedSlice, new Object[0]);
            Field decorationBookmarksField = mapScreen.getClass().getDeclaredField("decorationBookmarks");
            decorationBookmarksField.setAccessible(true);
            List decorationBookmarks = (List)decorationBookmarksField.get(mapScreen);
            for (IWaystone waystone : activatedWaystones) {
                boolean withinHover;
                BlockPos waystonePos = waystone.getPos();
                boolean bl = withinHover = waystone.getDimension() == dimension && playerPos.f_140723_() >= waystonePos.m_123341_() - hoverAreaRadius && playerPos.f_140723_() <= waystonePos.m_123341_() + hoverAreaRadius && playerPos.f_140724_() >= waystonePos.m_123343_() - hoverAreaRadius && playerPos.f_140724_() <= waystonePos.m_123343_() + hoverAreaRadius;
                if (!withinHover) continue;
                boolean foundMatch = false;
                for (Object obj : decorationBookmarks) {
                    DecorationBookmarkButton button;
                    if (!(obj instanceof DecorationBookmarkButton) || (int)Math.floor((button = (DecorationBookmarkButton)obj).getWorldX()) != waystonePos.m_123341_() || (int)Math.floor(button.getWorldZ()) != waystonePos.m_123343_()) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) continue;
                WaystoneTeleportContext context = new WaystoneTeleportContext(null, null, null);
                int xpLevelCost = PlayerWaystoneManager.getExperienceLevelCost((Entity)player, (IWaystone)waystone, (WarpMode)WarpMode.WARP_STONE, (IWaystoneTeleportContext)context);
                assert (player != null);
                if (player.f_36078_ >= xpLevelCost) {
                    Balm.getNetworking().sendToServer((Object)new TeleportToWaystoneMessage(waystone.getWaystoneUid()));
                    ChangeExperiencePacket packet = new ChangeExperiencePacket(-xpLevelCost);
                    Balm.getNetworking().sendToServer((Object)packet);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"message.a2w.no_experience", (Object[])new Object[]{xpLevelCost}), true);
                }
                player.m_6915_();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

