/*
 * Decompiled with CFR 0.152.
 */
package com.tofu26.a2w.mixin;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.IWaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneTeleportContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pepjebs.mapatlases.client.screen.DecorationBookmarkButton;
import pepjebs.mapatlases.client.screen.MapWidget;

@Mixin(value={MapWidget.class})
public class MapWidgetMixin {
    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void addCoordinatesToTeleportTooltip(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        MapWidget widget = (MapWidget)this;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Collection activatedWaystones = WaystonesAPI.getActivatedWaystones((Player)player);
        try {
            Field mapScreenField = MapWidget.class.getDeclaredField("mapScreen");
            mapScreenField.setAccessible(true);
            Object mapScreen = mapScreenField.get(widget);
            if (mapScreen == null) {
                return;
            }
            Field isHoveredField = MapWidget.class.getDeclaredField("isHovered");
            isHoveredField.setAccessible(true);
            boolean isHovered = (Boolean)isHoveredField.get(widget);
            if (!isHovered) {
                return;
            }
            Method getHoveredPosMethod = MapWidget.class.getDeclaredMethod("getHoveredPos", Double.TYPE, Double.TYPE);
            getHoveredPosMethod.setAccessible(true);
            ColumnPos playerPos = (ColumnPos)getHoveredPosMethod.invoke((Object)widget, pMouseX, pMouseY);
            Method getSelectedSliceMethod = mapScreen.getClass().getDeclaredMethod("getSelectedSlice", new Class[0]);
            getSelectedSliceMethod.setAccessible(true);
            Object selectedSlice = getSelectedSliceMethod.invoke(mapScreen, new Object[0]);
            if (selectedSlice == null) {
                return;
            }
            Method dimensionMethod = selectedSlice.getClass().getDeclaredMethod("dimension", new Class[0]);
            dimensionMethod.setAccessible(true);
            Object dimension = dimensionMethod.invoke(selectedSlice, new Object[0]);
            Field zoomLevelField = MapWidget.class.getDeclaredField("targetZoomLevel");
            zoomLevelField.setAccessible(true);
            float zoomLevel = zoomLevelField.getFloat(widget);
            int hoverAreaRadius = 4 + Math.round(4.0f * zoomLevel);
            Field decorationBookmarksField = mapScreen.getClass().getDeclaredField("decorationBookmarks");
            decorationBookmarksField.setAccessible(true);
            List decorationBookmarks = (List)decorationBookmarksField.get(mapScreen);
            for (IWaystone waystone : activatedWaystones) {
                boolean withinHover;
                BlockPos waystonePos = waystone.getPos();
                boolean bl = withinHover = waystone.getDimension() == dimension && playerPos.f_140723_() >= waystonePos.m_123341_() - hoverAreaRadius && playerPos.f_140723_() <= waystonePos.m_123341_() + hoverAreaRadius && playerPos.f_140724_() >= waystonePos.m_123343_() - hoverAreaRadius && playerPos.f_140724_() <= waystonePos.m_123343_() + hoverAreaRadius;
                if (!withinHover) continue;
                boolean foundMatch = false;
                for (Object obj : decorationBookmarks) {
                    DecorationBookmarkButton button;
                    if (!(obj instanceof DecorationBookmarkButton) || (int)Math.floor((button = (DecorationBookmarkButton)obj).getWorldX()) != waystonePos.m_123341_() || (int)Math.floor(button.getWorldZ()) != waystonePos.m_123343_()) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) continue;
                WaystoneTeleportContext context = new WaystoneTeleportContext(null, null, null);
                int xpLevelCost = PlayerWaystoneManager.getExperienceLevelCost((Entity)player, (IWaystone)waystone, (WarpMode)WarpMode.WARP_STONE, (IWaystoneTeleportContext)context);
                MutableComponent warpText = Component.m_237115_((String)"tooltip.warp").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
                MutableComponent levelCost = null;
                if (xpLevelCost > 0) {
                    assert (player != null);
                    boolean hasEnoughXP = player.f_36078_ >= xpLevelCost;
                    TextColor color = TextColor.m_131266_((int)(hasEnoughXP ? 0x55FF55 : 0xFF5555));
                    String key = xpLevelCost == 1 ? "tooltip.level_cost.single" : "tooltip.level_cost.multiple";
                    levelCost = Component.m_237110_((String)key, (Object[])new Object[]{xpLevelCost}).m_6270_(Style.f_131099_.m_131148_(color));
                }
                MutableComponent tooltip = levelCost != null ? warpText.m_7220_(levelCost) : warpText;
                graphics.m_280557_(mc.f_91062_, (Component)tooltip, pMouseX, pMouseY);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

