/*
 * Decompiled with CFR 0.152.
 */
package com.tofu26.a2w.network;

import com.mojang.datafixers.util.Either;
import java.util.UUID;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.IWaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class TeleportToWaystoneMessage {
    private final UUID waystoneUid;

    public TeleportToWaystoneMessage(UUID waystoneUid) {
        this.waystoneUid = waystoneUid;
    }

    public static void encode(TeleportToWaystoneMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.waystoneUid);
    }

    public static TeleportToWaystoneMessage decode(FriendlyByteBuf buf) {
        return new TeleportToWaystoneMessage(buf.m_130259_());
    }

    public static void handle(ServerPlayer player, TeleportToWaystoneMessage message) {
        WaystoneProxy waystone = new WaystoneProxy(player.f_8924_, message.waystoneUid);
        Either result = WaystonesAPI.createCustomTeleportContext((Entity)player, (IWaystone)waystone);
        result.ifLeft(context -> {
            PlayerWaystoneManager.getExperienceLevelCost((Entity)player, (IWaystone)waystone, (WarpMode)WarpMode.WARP_STONE, (IWaystoneTeleportContext)context);
            WaystonesAPI.tryTeleport((IWaystoneTeleportContext)context);
        });
        result.ifRight(error -> player.m_5661_((Component)Component.m_237113_((String)("Teleport failed: " + error.getClass().getSimpleName())), true));
    }
}

