/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.BrainiacEntity;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class BrainiacModel
extends AdvancedEntityModel<BrainiacEntity> {
    private final AdvancedModelBox torso;
    private final AdvancedModelBox chest;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox handMaw;
    private final AdvancedModelBox handMaw3;
    private final AdvancedModelBox rarm;
    private final AdvancedModelBox head;
    private final AdvancedModelBox brain;
    private final AdvancedModelBox tongue;
    private final AdvancedModelBox tongue2;
    private final AdvancedModelBox lleg;
    private final AdvancedModelBox rleg;
    private final ModelAnimator animator;

    public BrainiacModel() {
        this.texWidth = 256;
        this.texHeight = 256;
        this.torso = new AdvancedModelBox((AdvancedEntityModel)this);
        this.torso.setRotationPoint(0.0f, 3.0f, 0.0f);
        this.torso.setTextureOffset(0, 68).addBox(-5.5f, -4.0f, -4.0f, 11.0f, 14.0f, 8.0f, 0.0f, false);
        this.torso.setTextureOffset(0, 107).addBox(-5.5f, -3.0f, -4.0f, 11.0f, 13.0f, 8.0f, 0.25f, false);
        this.chest = new AdvancedModelBox((AdvancedEntityModel)this);
        this.chest.setRotationPoint(0.0f, 0.0f, 4.0f);
        this.torso.addChild((BasicModelPart)this.chest);
        this.chest.setTextureOffset(0, 42).addBox(-8.5f, -14.0f, -11.0f, 17.0f, 14.0f, 12.0f, 0.0f, false);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larm.setRotationPoint(8.1667f, -8.1667f, -5.0833f);
        this.chest.addChild((BasicModelPart)this.larm);
        this.larm.setTextureOffset(0, 0).addBox(0.3333f, -1.8333f, -4.1667f, 8.0f, 23.0f, 9.0f, 0.0f, false);
        this.larm.setTextureOffset(70, 79).addBox(1.3333f, -2.8333f, -6.1667f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        this.larm.setTextureOffset(35, 98).addBox(1.3333f, -2.8333f, -6.1667f, 8.0f, 8.0f, 8.0f, -0.25f, false);
        this.larm.setTextureOffset(35, 98).addBox(1.3333f, 9.1667f, -2.1667f, 8.0f, 8.0f, 8.0f, -0.25f, false);
        this.larm.setTextureOffset(38, 79).addBox(1.3333f, 9.1667f, -2.1667f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        this.handMaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.handMaw.setRotationPoint(8.3333f, 21.1667f, 0.3333f);
        this.larm.addChild((BasicModelPart)this.handMaw);
        this.handMaw.setTextureOffset(0, 90).addBox(-4.0f, 0.0f, -4.5f, 4.0f, 8.0f, 9.0f, 0.0f, false);
        this.handMaw3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.handMaw3.setRotationPoint(-8.0f, 0.0f, 0.0f);
        this.handMaw.addChild((BasicModelPart)this.handMaw3);
        this.handMaw3.setTextureOffset(92, 0).addBox(0.0f, 0.0f, -4.5f, 4.0f, 8.0f, 9.0f, 0.0f, false);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarm.setRotationPoint(-7.25f, -12.25f, -6.0f);
        this.chest.addChild((BasicModelPart)this.rarm);
        this.rarm.setTextureOffset(56, 0).addBox(-8.25f, -3.75f, -3.25f, 9.0f, 37.0f, 9.0f, 0.0f, false);
        this.rarm.setTextureOffset(84, 38).addBox(-10.25f, 15.25f, -5.25f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        this.rarm.setTextureOffset(35, 98).addBox(-10.25f, 15.25f, -5.25f, 8.0f, 8.0f, 8.0f, -0.25f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, -7.0f, -11.25f);
        this.chest.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(100, 54).addBox(-3.5f, -3.0f, -6.25f, 7.0f, 10.0f, 7.0f, 0.0f, false);
        this.brain = new AdvancedModelBox((AdvancedEntityModel)this);
        this.brain.setRotationPoint(0.0f, 28.0f, 7.25f);
        this.head.addChild((BasicModelPart)this.brain);
        this.brain.setTextureOffset(46, 56).addBox(-6.5f, -41.0f, -15.0f, 13.0f, 11.0f, 12.0f, 0.0f, false);
        this.tongue = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tongue.setRotationPoint(0.0f, 3.5f, -1.75f);
        this.head.addChild((BasicModelPart)this.tongue);
        this.tongue.setTextureOffset(73, 106).addBox(-2.5f, -0.5f, -21.0f, 5.0f, 1.0f, 21.0f, 0.0f, false);
        this.tongue2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tongue2.setRotationPoint(0.0f, 0.0f, -21.0f);
        this.tongue.addChild((BasicModelPart)this.tongue2);
        this.tongue2.setTextureOffset(84, 84).addBox(-2.5f, -0.5f, -21.0f, 5.0f, 1.0f, 21.0f, 0.0f, false);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(3.5f, 9.5f, 0.0f);
        this.torso.addChild((BasicModelPart)this.lleg);
        this.lleg.setTextureOffset(26, 91).addBox(-2.0f, 0.5f, -2.0f, 4.0f, 11.0f, 4.0f, 0.0f, true);
        this.lleg.setTextureOffset(67, 95).addBox(-2.0f, 0.5f, -2.0f, 4.0f, 11.0f, 4.0f, 0.25f, true);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(-3.5f, 9.5f, 0.0f);
        this.torso.addChild((BasicModelPart)this.rleg);
        this.rleg.setTextureOffset(26, 91).addBox(-2.0f, 0.5f, -2.0f, 4.0f, 11.0f, 4.0f, 0.0f, false);
        this.rleg.setTextureOffset(67, 95).addBox(-2.0f, 0.5f, -2.0f, 4.0f, 11.0f, 4.0f, 0.25f, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(BrainiacEntity.ANIMATION_THROW_BARREL);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.torso, 0.0f, (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-270.0), (float)Math.toRadians(-10.0), (float)Math.toRadians(-10.0));
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(40.0));
        this.animator.move(this.handMaw3, 0.0f, -4.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.larm, (float)Math.toRadians(-80.0), 0.0f, 0.0f);
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(-90.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(90.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(BrainiacEntity.ANIMATION_DRINK_BARREL);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.torso, 0.0f, (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-270.0), (float)Math.toRadians(-10.0), (float)Math.toRadians(-10.0));
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(40.0));
        this.animator.move(this.handMaw3, 0.0f, -4.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(10);
        this.animator.move(this.larm, 1.0f, 6.0f, 10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-80.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(-90.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(90.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(4);
        this.animator.move(this.larm, 1.0f, 5.0f, 10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-70.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(-90.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(90.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(4);
        this.animator.move(this.larm, 1.0f, 6.0f, 10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-80.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(-90.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(90.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(4);
        this.animator.move(this.larm, 1.0f, 5.0f, 10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-70.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(-90.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(90.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(4);
        this.animator.move(this.larm, 1.0f, 6.0f, 10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-80.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(-90.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(90.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(4);
        this.animator.move(this.larm, 1.0f, 5.0f, 10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-70.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(-90.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(90.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(4);
        this.animator.move(this.larm, 1.0f, 6.0f, 10.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-80.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(-90.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(90.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(BrainiacEntity.ANIMATION_BITE);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.torso, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.chest, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.torso, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.chest, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-80.0), (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(-90.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(90.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.rotate(this.torso, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.chest, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-70.0), (float)Math.toRadians(-20.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(BrainiacEntity.ANIMATION_SMASH);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.chest, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-130.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-130.0), (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.handMaw, 0.0f, 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.handMaw3, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.chest, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-20.0), (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.larm, (float)Math.toRadians(-20.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.torso);
    }

    public void translateToArmOrChest(PoseStack poseStack, boolean arm) {
        this.torso.translateAndRotate(poseStack);
        this.chest.translateAndRotate(poseStack);
        if (arm) {
            this.larm.translateAndRotate(poseStack);
        }
    }

    public void setupAnim(BrainiacEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        float walkSpeed = 0.5f;
        float walkDegree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float tongueLaunch = entity.getShootTongueAmount(partialTick);
        float tongueLength = entity.getLastTongueDistance(partialTick) * tongueLaunch;
        float tongueWiggle = (float)Math.sin((double)tongueLaunch * Math.PI);
        Entity tongueTarget = entity.getTongueTarget();
        if (tongueTarget != null && tongueLaunch > 0.0f) {
            float yBodyRot = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTick;
            Vec3 cameraPosition = tongueTarget.m_20299_(partialTick);
            Vec3 eyePosition = entity.m_20299_(partialTick);
            double d0 = eyePosition.f_82479_ - cameraPosition.f_82479_;
            double d1 = eyePosition.f_82480_ - cameraPosition.f_82480_;
            double d2 = eyePosition.f_82481_ - cameraPosition.f_82481_;
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            this.tongue.rotateAngleY = (float)((double)this.tongue.rotateAngleY - (Math.toRadians(yBodyRot) + (double)this.head.rotateAngleY + (double)this.chest.rotateAngleY + (double)this.torso.rotateAngleY));
            this.tongue.rotateAngleY -= (float)Math.toRadians(-((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875)) - 90.0f);
            this.tongue.rotateAngleX += (float)Math.toRadians(Mth.m_14177_((float)((float)(Mth.m_14136_((double)d1, (double)d3) * 180.0 / 3.1415927410125732))));
        }
        this.tongue.showModel = !(tongueLength <= 0.0f);
        float hunchAmount = limbSwingAmount * (1.0f - entity.getRaiseArmsAmount(partialTick));
        float hunchLeftAmount = hunchAmount * (1.0f - entity.getRaiseLeftArmAmount(partialTick));
        float zoomedHunch = Math.min(1.0f, hunchAmount * 3.0f);
        this.progressRotationPrev(this.chest, zoomedHunch, (float)Math.toRadians(20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.larm, zoomedHunch, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rarm, zoomedHunch, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, zoomedHunch, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.rarm, zoomedHunch, 0.0f, -3.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.larm, zoomedHunch, 0.0f, -2.5f, 0.0f, 1.0f);
        this.progressPositionPrev(this.head, zoomedHunch, 0.0f, -2.0f, 0.0f, 1.0f);
        this.tongue.setScale(1.0f, 1.0f, tongueLength);
        this.tongue.scaleChildren = true;
        this.brain.setScale((1.0f + (float)Math.sin(ageInTicks * 0.5f + 2.0f)) * 0.1f + 1.0f, 1.0f, (1.0f + (float)Math.sin(ageInTicks * 0.5f)) * 0.1f + 1.0f);
        this.flap(this.head, 0.15f, 0.1f, false, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.flap(this.head, 0.55f, 0.1f, false, 2.0f, 0.0f, ageInTicks, 0.5f + 0.5f * (float)Math.sin(ageInTicks * 0.5f));
        this.walk(this.tongue, 0.4f, 0.1f, false, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.tongue2, 0.4f, 0.2f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.tongue, 1.5f, 0.4f, false, 0.0f, 0.0f, ageInTicks, tongueWiggle);
        this.swing(this.tongue2, 1.5f, 0.4f, false, -1.0f, 0.0f, ageInTicks, tongueWiggle);
        this.tongue.rotateAngleZ -= this.head.rotateAngleZ;
        float bodyBob = this.walkValue(limbSwing, limbSwingAmount, walkSpeed * 1.5f, 0.5f, 1.0f, true);
        this.torso.rotationPointY += bodyBob;
        this.flap(this.chest, walkSpeed, walkDegree * 0.2f, false, 2.5f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.head, walkSpeed, walkDegree * -0.1f, false, 3.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.torso, walkSpeed, walkDegree * 0.1f, false, 3.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.rleg, walkSpeed, walkDegree, true, 0.0f, 0.1f, limbSwing, limbSwingAmount);
        this.walk(this.lleg, walkSpeed, walkDegree, false, 0.0f, 0.1f, limbSwing, limbSwingAmount);
        this.walk(this.rarm, walkSpeed, walkDegree * 1.3f, false, 1.0f, 0.0f, limbSwing, hunchAmount);
        this.walk(this.larm, walkSpeed, walkDegree * 1.3f, false, -1.0f, 0.0f, limbSwing, hunchLeftAmount);
        this.walk(this.torso, walkSpeed, walkDegree * 0.1f, false, -1.0f, 0.0f, limbSwing, hunchLeftAmount);
        this.rarm.rotationPointY += Math.min(0.0f, this.walkValue(limbSwing, hunchAmount, walkSpeed, -0.75f, 1.0f, false)) - bodyBob;
        this.rarm.rotationPointZ += this.walkValue(limbSwing, hunchAmount, walkSpeed, -0.75f, -3.0f, true);
        this.larm.rotationPointY += Math.min(0.0f, this.walkValue(limbSwing, hunchLeftAmount, walkSpeed, 0.75f, 1.0f, false)) - bodyBob;
        this.larm.rotationPointZ += this.walkValue(limbSwing, hunchLeftAmount, walkSpeed, 0.75f, -3.0f, true);
        this.rarm.rotateAngleZ -= this.torso.rotateAngleZ;
        this.larm.rotateAngleZ -= this.torso.rotateAngleZ;
        float yawAmount = netHeadYaw / 57.295776f;
        float pitchAmount = headPitch / 57.295776f;
        this.head.rotateAngleX += pitchAmount * 0.25f;
        this.head.rotateAngleY += yawAmount * 0.5f;
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.torso, (Object)this.chest, (Object)this.lleg, (Object)this.rleg, (Object)this.rarm, (Object)this.larm, (Object)this.handMaw, (Object)this.handMaw3, (Object)this.head, (Object)this.brain, (Object)this.tongue, (Object)this.tongue2, (Object[])new AdvancedModelBox[0]);
    }

    private float walkValue(float limbSwing, float limbSwingAmount, float speed, float offset, float degree, boolean inverse) {
        return (float)(Math.cos(limbSwing * speed + offset) * (double)degree * (double)limbSwingAmount * (double)(inverse ? -1 : 1));
    }
}

