/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.CaniacEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class CaniacModel
extends AdvancedEntityModel<CaniacEntity> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox body;
    private final AdvancedModelBox pelvis;
    private final AdvancedModelBox spine;
    private final AdvancedModelBox chest;
    private final AdvancedModelBox neck;
    private final AdvancedModelBox head;
    private final AdvancedModelBox right_Eye;
    private final AdvancedModelBox left_Eye;
    private final AdvancedModelBox left_Arm;
    private final AdvancedModelBox right_Arm;
    private final AdvancedModelBox left_Leg;
    private final AdvancedModelBox right_Leg;
    private final AdvancedModelBox cube_r1;
    private final AdvancedModelBox cube_r2;
    private final ModelAnimator animator;

    public CaniacModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, -19.0f, -3.0f);
        this.root.addChild((BasicModelPart)this.body);
        this.pelvis = new AdvancedModelBox((AdvancedEntityModel)this);
        this.pelvis.setRotationPoint(0.0f, 3.5f, 3.0f);
        this.body.addChild((BasicModelPart)this.pelvis);
        this.pelvis.setTextureOffset(12, 40).addBox(-5.0f, -1.5f, -2.0f, 10.0f, 3.0f, 4.0f, 0.0f, false);
        this.spine = new AdvancedModelBox((AdvancedEntityModel)this);
        this.spine.setRotationPoint(0.0f, -1.5f, 2.0f);
        this.pelvis.addChild((BasicModelPart)this.spine);
        this.cube_r1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r1.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.spine.addChild((BasicModelPart)this.cube_r1);
        this.setRotateAngle(this.cube_r1, 0.3927f, 0.0f, 0.0f);
        this.cube_r1.setTextureOffset(0, 6).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 0.0f, 0.0f, false);
        this.chest = new AdvancedModelBox((AdvancedEntityModel)this);
        this.chest.setRotationPoint(0.0f, -3.7f, -1.54f);
        this.spine.addChild((BasicModelPart)this.chest);
        this.cube_r2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r2.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.chest.addChild((BasicModelPart)this.cube_r2);
        this.setRotateAngle(this.cube_r2, 0.3927f, 0.0f, 0.0f);
        this.cube_r2.setTextureOffset(0, 0).addBox(-8.0f, -11.9959f, -9.9898f, 16.0f, 12.0f, 10.0f, 0.0f, false);
        this.neck = new AdvancedModelBox((AdvancedEntityModel)this);
        this.neck.setRotationPoint(0.0f, -11.05f, -4.56f);
        this.chest.addChild((BasicModelPart)this.neck);
        this.neck.setTextureOffset(32, 0).addBox(-2.0f, 0.0f, -10.0f, 4.0f, 0.0f, 10.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, 0.0f, -9.4f);
        this.neck.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(36, 22).addBox(-7.0f, -7.25f, -4.25f, 14.0f, 14.0f, 4.0f, 0.0f, false);
        this.head.setTextureOffset(0, 22).addBox(-7.0f, -7.25f, -4.25f, 14.0f, 14.0f, 4.0f, 0.25f, false);
        this.right_Eye = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Eye.setRotationPoint(-2.5f, -0.75f, -4.3f);
        this.head.addChild((BasicModelPart)this.right_Eye);
        this.right_Eye.setTextureOffset(0, 78).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, true);
        this.left_Eye = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Eye.setRotationPoint(2.5f, -0.75f, -4.3f);
        this.head.addChild((BasicModelPart)this.left_Eye);
        this.left_Eye.setTextureOffset(0, 78).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, false);
        this.left_Arm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Arm.setRotationPoint(7.75f, -8.8f, -6.96f);
        this.chest.addChild((BasicModelPart)this.left_Arm);
        this.left_Arm.setTextureOffset(20, 47).addBox(0.0f, 22.5f, 8.5f, 3.0f, 7.0f, 3.0f, 0.0f, false);
        this.left_Arm.setTextureOffset(33, 40).addBox(0.0f, 26.5f, 1.5f, 3.0f, 3.0f, 7.0f, 0.0f, false);
        this.left_Arm.setTextureOffset(0, 40).addBox(0.0f, -5.5f, -1.5f, 3.0f, 35.0f, 3.0f, 0.0f, false);
        this.right_Arm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Arm.setRotationPoint(-7.75f, -8.8f, -6.96f);
        this.chest.addChild((BasicModelPart)this.right_Arm);
        this.right_Arm.setTextureOffset(20, 47).addBox(-3.0f, 22.5f, 8.5f, 3.0f, 7.0f, 3.0f, 0.0f, true);
        this.right_Arm.setTextureOffset(33, 40).addBox(-3.0f, 26.5f, 1.5f, 3.0f, 3.0f, 7.0f, 0.0f, true);
        this.right_Arm.setTextureOffset(0, 40).addBox(-3.0f, -5.5f, -1.5f, 3.0f, 35.0f, 3.0f, 0.0f, true);
        this.left_Leg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Leg.setRotationPoint(3.0f, 1.5f, 0.0f);
        this.pelvis.addChild((BasicModelPart)this.left_Leg);
        this.left_Leg.setTextureOffset(12, 47).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 14.0f, 2.0f, 0.0f, false);
        this.left_Leg.setTextureOffset(32, 22).addBox(-1.0f, 12.0f, 1.0f, 2.0f, 2.0f, 2.0f, 0.0f, false);
        this.left_Leg.setTextureOffset(0, 0).addBox(-1.0f, 10.0f, 3.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
        this.right_Leg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Leg.setRotationPoint(-3.0f, 1.5f, 0.0f);
        this.pelvis.addChild((BasicModelPart)this.right_Leg);
        this.right_Leg.setTextureOffset(12, 47).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 14.0f, 2.0f, 0.0f, true);
        this.right_Leg.setTextureOffset(32, 22).addBox(-1.0f, 12.0f, 1.0f, 2.0f, 2.0f, 2.0f, 0.0f, true);
        this.right_Leg.setTextureOffset(0, 0).addBox(-1.0f, 10.0f, 3.0f, 2.0f, 4.0f, 2.0f, 0.0f, true);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.body, (Object)this.pelvis, (Object)this.chest, (Object)this.spine, (Object)this.chest, (Object)this.neck, (Object)this.head, (Object)this.right_Eye, (Object)this.right_Arm, (Object)this.left_Eye, (Object)this.left_Arm, (Object[])new AdvancedModelBox[]{this.right_Leg, this.left_Leg, this.cube_r1, this.cube_r2});
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(CaniacEntity.ANIMATION_LUNGE);
        this.animator.startKeyframe(10);
        this.animator.move(this.body, 0.0f, 0.0f, 4.0f);
        this.animator.rotate(this.spine, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-185.0), (float)Math.toRadians(-25.0), (float)Math.toRadians(45.0));
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-185.0), (float)Math.toRadians(25.0), (float)Math.toRadians(-45.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 4.0f, -15.0f);
        this.animator.move(this.left_Arm, 0.0f, -3.0f, -8.0f);
        this.animator.move(this.right_Arm, 0.0f, -3.0f, -8.0f);
        this.animator.rotate(this.body, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-110.0), (float)Math.toRadians(-15.0), (float)Math.toRadians(60.0));
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-110.0), (float)Math.toRadians(15.0), (float)Math.toRadians(-60.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(10);
    }

    public void setupAnim(CaniacEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        float walkSpeed = 0.7f;
        float walkDegree = 1.0f;
        float runSpeed = 0.5f;
        float runDegree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float runProgress = entity.getRunProgress(partialTick);
        float walkProgress = 1.0f - runProgress;
        float walkAmount = limbSwingAmount * walkProgress;
        float runAmount = limbSwingAmount * runProgress;
        float leftArmAngle = (float)Math.toRadians(Mth.m_14177_((float)entity.getArmAngle(true, partialTick)));
        float rightArmAngle = (float)Math.toRadians(Mth.m_14177_((float)entity.getArmAngle(false, partialTick)));
        float headYawAmount = netHeadYaw / 57.295776f;
        float headPitchAmount = headPitch / 57.295776f;
        this.progressRotationPrev(this.spine, walkAmount, (float)Math.toRadians(-25.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.left_Arm, walkAmount, 0.0f, 4.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.right_Arm, walkAmount, 0.0f, 4.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.spine, runAmount, (float)Math.toRadians(15.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.body, runAmount, 0.0f, 0.0f, 4.0f, 1.0f);
        this.walk(this.neck, 0.06f, 0.1f, false, 0.0f, 0.1f, ageInTicks, 1.0f);
        this.walk(this.head, 0.06f, 0.1f, true, 0.0f, 0.1f, ageInTicks, 1.0f);
        this.walk(this.chest, 0.06f, 0.05f, true, 1.0f, 0.05f, ageInTicks, 1.0f);
        this.walk(this.left_Arm, 0.06f, 0.05f, false, 1.0f, 0.05f, ageInTicks, 1.0f);
        this.walk(this.right_Arm, 0.06f, 0.05f, false, 1.0f, 0.05f, ageInTicks, 1.0f);
        this.walk(this.left_Leg, walkSpeed, walkDegree, false, 1.0f, 0.0f, limbSwing, walkAmount);
        this.walk(this.right_Leg, walkSpeed, walkDegree, true, 1.0f, 0.0f, limbSwing, walkAmount);
        this.walk(this.chest, walkSpeed, walkDegree * 0.1f, false, 2.0f, -0.1f, limbSwing, walkAmount);
        if (entity.getAnimation() != CaniacEntity.ANIMATION_LUNGE) {
            this.walk(this.left_Arm, walkSpeed, walkDegree * 0.05f, false, 3.0f, 1.0f, limbSwing, walkAmount);
            this.walk(this.right_Arm, walkSpeed, walkDegree * 0.05f, true, 3.0f, -1.0f, limbSwing, walkAmount);
        }
        float bodyWalkBob = -Math.abs(ACMath.walkValue(limbSwing, walkAmount, walkSpeed, -1.5f, 3.0f, false));
        float runWalkBob = -Math.abs(ACMath.walkValue(limbSwing, runAmount, runSpeed, -1.5f, 3.0f, false));
        this.body.rotationPointY += bodyWalkBob + runWalkBob;
        this.walk(this.left_Leg, runSpeed, runDegree, false, 1.0f, 0.0f, limbSwing, runAmount);
        this.walk(this.right_Leg, runSpeed, runDegree, true, 1.0f, 0.0f, limbSwing, runAmount);
        this.walk(this.chest, runSpeed, runDegree * 0.15f, false, 1.0f, -0.1f, limbSwing, runAmount);
        this.swing(this.spine, runSpeed, runDegree * 0.15f, false, 0.0f, 0.0f, limbSwing, runAmount);
        this.swing(this.neck, runSpeed, runDegree * 0.15f, true, 0.0f, 0.0f, limbSwing, runAmount);
        this.right_Arm.rotateAngleX += leftArmAngle;
        this.left_Arm.rotateAngleX += rightArmAngle;
        this.head.rotateAngleY += headYawAmount * 0.35f;
        this.neck.rotateAngleY += headYawAmount * 0.35f;
        this.head.rotateAngleX += headPitchAmount * 0.15f;
        this.neck.rotateAngleX += headPitchAmount * 0.15f;
        Entity look = Minecraft.m_91087_().m_91288_();
        if (look != null) {
            Vec3 vector3d = look.m_20299_(0.0f);
            Vec3 vector3d1 = entity.m_20299_(0.0f);
            double d0 = vector3d.f_82480_ - vector3d1.f_82480_;
            float f1 = (float)Mth.m_14008_((double)(-d0), (double)-1.0, (double)1.0);
            Vec3 vector3d2 = entity.m_20252_(0.0f);
            vector3d2 = new Vec3(vector3d2.f_82479_, 0.0, vector3d2.f_82481_);
            Vec3 vector3d3 = new Vec3(vector3d1.f_82479_ - vector3d.f_82479_, 0.0, vector3d1.f_82481_ - vector3d.f_82481_).m_82541_().m_82524_(1.5707964f);
            double d1 = vector3d2.m_82526_(vector3d3);
            double d2 = Mth.m_14116_((float)((float)Math.abs(d1 * 2.0))) * (float)Math.signum(d1);
            this.left_Eye.rotationPointX = (float)((double)this.left_Eye.rotationPointX + (d2 - (double)this.head.rotateAngleZ));
            this.left_Eye.rotationPointY += f1;
            this.right_Eye.rotationPointX = (float)((double)this.right_Eye.rotationPointX + (d2 - (double)this.head.rotateAngleZ));
            this.right_Eye.rotationPointY += f1;
        }
    }
}

