/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AmberMonolithParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private Vec3 target;
    private float initialDistance = 0.0f;

    public AmberMonolithParticle(ClientLevel level, double x, double y, double z, double toX, double toY, double toZ, SpriteSet spriteSet) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_172258_ = 0.96f;
        this.f_107226_ = 0.1f;
        this.f_172259_ = true;
        this.sprites = spriteSet;
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107663_ *= 1.125f;
        this.f_107225_ = (int)(20.0 / (Math.random() * 0.8 + 0.2));
        this.f_107219_ = false;
        this.target = new Vec3(toX, toY, toZ);
        this.m_108339_(spriteSet);
        this.initialDistance = (float)this.target.m_82492_(x, y, z).m_82553_();
        this.f_107227_ = 1.0f;
        this.f_107228_ = 0.69f;
        this.f_107229_ = 0.12f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float partialTicks) {
        Vec3 to = this.target.m_82492_(this.f_107212_, this.f_107213_, this.f_107214_);
        float glowBy = (float)(to.m_82553_() / (double)this.initialDistance);
        int i = super.m_6355_(partialTicks);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(glowBy * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        this.m_107271_(Mth.m_14179_((float)0.05f, (float)this.f_107230_, (float)1.0f));
        Vec3 to = this.target.m_82492_(this.f_107212_, this.f_107213_, this.f_107214_);
        if (to.m_82553_() > 1.0) {
            to = to.m_82541_();
        } else {
            this.m_107274_();
        }
        this.f_107215_ += to.f_82479_ * (double)0.05f;
        this.f_107216_ += to.f_82480_ * (double)0.05f;
        this.f_107217_ += to.f_82481_ * (double)0.05f;
        this.f_107227_ = Math.min(1.0f, this.f_107227_ + 0.03f);
        this.f_107228_ = Math.min(1.0f, this.f_107228_ + 0.03f);
        this.f_107229_ = Math.min(1.0f, this.f_107229_ + 0.03f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet p_107868_) {
            this.sprite = p_107868_;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AmberMonolithParticle spellparticle = new AmberMonolithParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
            return spellparticle;
        }
    }
}

