/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.VoronoiGenerator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public class FrostedChocolateBlock
extends Block {
    private static final VoronoiGenerator VORONOI_GENERATOR = new VoronoiGenerator(42L);
    private static final float COLORIZER_SAMPLE_SCALE = 0.0175f;
    private static final double COLORIZER_BLUR_RADIUS = (double)0.45f;
    private static final int COLORIZER_EDGE_SIZE_BLOCKS = 8;
    private static final int COLORIZER_R_DIFFERENCE = 5;
    private static final int COLORIZER_G_DIFFERENCE = 20;
    private static final int COLORIZER_B_DIFFERENCE = 50;
    private static final int MIN_SPIRAL_BY = 2;
    private static final int DOUBLE_SPIRAL_BY = 3;

    public FrostedChocolateBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283765_).m_60913_(1.0f, 2.0f).m_60918_(ACSoundTypes.DENSE_CANDY).m_280658_(NoteBlockInstrument.BASEDRUM).m_60977_());
    }

    private boolean shouldRemain(LevelReader levelReader, BlockPos blockPos) {
        BlockPos blockpos = blockPos.m_7494_();
        BlockState blockstate = levelReader.m_8055_(blockpos);
        return !blockstate.m_60659_((BlockGetter)levelReader, blockPos, Direction.DOWN, SupportType.FULL) || blockstate.m_60713_((Block)ACBlockRegistry.BLOCK_OF_FROSTING.get()) || !blockstate.m_60815_() || blockstate.m_60819_().m_76186_() == 8;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        return direction == Direction.UP && !this.shouldRemain((LevelReader)levelAccessor, blockPos) ? ((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()).m_49966_() : super.m_7417_(blockState, direction, blockState1, levelAccessor, blockPos, blockPos1);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.shouldRemain((LevelReader)context.m_43725_(), context.m_8083_()) ? super.m_5573_(context) : ((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()).m_49966_();
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!this.shouldRemain((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46597_(blockPos, ((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()).m_49966_());
        }
    }

    public static int calculateFrostingColor(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return 0xFFFFFF;
        }
        VoronoiGenerator.VoronoiInfo info = VORONOI_GENERATOR.get2((float)blockPos.m_123341_() * 0.0175f, (float)blockPos.m_123343_() * 0.0175f);
        double distance = info.distance();
        if (distance < 0.5) {
            double closestDist = Math.min(info.distance(), info.distance1());
            double rotateDir = info.hash() < 0.0 ? -1.0 : 1.0;
            double spiralCount = 2.0 + 3.0 * (1.0 + info.hash());
            double angle = rotateDir * distance * 360.0 * spiralCount;
            double targetSpiralX = Math.sin(Math.PI / 180 * angle);
            double targetSpiralZ = Math.cos(Math.PI / 180 * angle);
            double d0 = targetSpiralX - info.localPos().f_82479_;
            double d1 = targetSpiralZ - info.localPos().f_82481_;
            double distToTarget = Math.pow(d0 * d0 + d1 * d1, 2.0);
            double distToCenter = closestDist * 2.0 > (double)0.45f ? (double)(1.0f - ACMath.smin((float)((closestDist * 2.0 - (double)0.45f) / (double)0.45f), 1.0f, 0.2f)) : 1.0;
            double edgeDistScaled = 0.14f;
            if (info.distance1() < info.distance() + edgeDistScaled) {
                double lessBy = (info.distance() + edgeDistScaled - info.distance1()) / edgeDistScaled;
                distToCenter *= 1.0 - lessBy;
            }
            int rDec = (int)ACMath.smin((float)(5.0 * (distToTarget * distToCenter)), 5.0f, 0.1f);
            int gDec = (int)ACMath.smin((float)(20.0 * (distToTarget * distToCenter)), 20.0f, 0.1f);
            int bDec = (int)ACMath.smin((float)(50.0 * (distToTarget * distToCenter)), 50.0f, 0.1f);
            return FastColor.ARGB32.m_13660_((int)(255 - rDec), (int)(255 - gDec), (int)(255 - bDec), (int)255);
        }
        return 0xFFFFFF;
    }

    static {
        VORONOI_GENERATOR.setOffsetAmount(0.35f);
        VORONOI_GENERATOR.setDistanceType(VoronoiGenerator.DistanceType.euclidean);
    }
}

