/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GobthumperBlockEntity
extends BlockEntity {
    private int thumpTime;
    private int particleColor;
    private boolean hasThumpTicked = false;
    private int summonedWormId = -1;

    public GobthumperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.GOBTHUMPER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GobthumperBlockEntity entity) {
        ++entity.thumpTime;
        if (Math.sin((float)entity.thumpTime * 0.7f) <= (double)0.1f) {
            if (!entity.hasThumpTicked) {
                entity.hasThumpTicked = true;
                entity.f_58857_.m_247517_(null, entity.m_58899_(), (SoundEvent)ACSoundRegistry.GOBTHUMPER_THUMP.get(), SoundSource.BLOCKS);
                entity.thumpTick(level);
            }
        } else {
            entity.hasThumpTicked = false;
        }
    }

    private void thumpTick(Level level) {
        GumWormEntity gumWorm;
        Entity entity;
        if (level.f_46443_) {
            level.m_6485_((ParticleOptions)ACParticleRegistry.GOBTHUMPER.get(), true, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.15f), (double)((float)this.m_58899_().m_123343_() + 0.5f), (double)this.particleColor, 0.0, 0.0);
            this.particleColor = (this.particleColor + 1) % 3;
        } else if (this.summonedWormId != -1 && (entity = level.m_6815_(this.summonedWormId)) instanceof GumWormEntity && (gumWorm = (GumWormEntity)entity).m_6084_()) {
            gumWorm.setGobthumperPos(this.m_58899_());
        } else {
            GumWormEntity closestWorm = null;
            Vec3 vec3 = this.m_58899_().m_252807_();
            for (GumWormEntity worm : level.m_45976_(GumWormEntity.class, new AABB(this.m_58899_()).m_82377_(200.0, 200.0, 200.0))) {
                if (closestWorm != null && !(worm.m_20238_(vec3) < closestWorm.m_20238_(vec3))) continue;
                closestWorm = worm;
            }
            if (closestWorm != null) {
                this.summonedWormId = closestWorm.m_19879_();
            } else {
                boolean flag = false;
                BlockPos summonPos = null;
                for (int i = 0; i < 15; ++i) {
                    summonPos = this.m_58899_().m_7918_(level.m_213780_().m_188503_(200) - 100, -30, level.m_213780_().m_188503_(200) - 100);
                    if (summonPos.m_123342_() < level.m_141937_() + 2) {
                        summonPos = summonPos.m_175288_(level.m_141937_() + 2);
                    }
                    if (!level.m_46749_(summonPos) || !level.m_8055_(summonPos).m_280296_() || level.m_8055_(summonPos).m_204336_(ACTagRegistry.GUM_WORM_BLOCKS_DIGGING)) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    GumWormEntity summonedWorm = (GumWormEntity)((EntityType)ACEntityRegistry.GUM_WORM.get()).m_20615_(level);
                    summonedWorm.m_146884_(Vec3.m_82512_(summonPos));
                    summonedWorm.setTempSummon(true);
                    summonedWorm.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(summonPos), MobSpawnType.MOB_SUMMONED, null, null);
                    level.m_7967_((Entity)summonedWorm);
                    this.summonedWormId = summonedWorm.m_19879_();
                }
            }
        }
    }

    public float getThumpTime(float partialTicks) {
        return (float)this.thumpTime + partialTicks;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.summonedWormId = tag.m_128451_("SummonedWormID");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SummonedWormID", this.summonedWormId);
    }
}

