/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TremorzillaWanderGoal
extends Goal {
    private TremorzillaEntity tremorzilla;
    private double x;
    private double y;
    private double z;
    private boolean tryLandTarget;

    public TremorzillaWanderGoal(TremorzillaEntity tremorzilla) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.tremorzilla = tremorzilla;
    }

    public boolean m_8036_() {
        if (this.tremorzilla.m_217043_().m_188503_(40) != 0 && !this.tremorzilla.isTremorzillaSwimming()) {
            return false;
        }
        this.tryLandTarget = this.tremorzilla.isTremorzillaSwimming() ? this.tremorzilla.timeSwimming > 300 || this.tremorzilla.m_217043_().m_188501_() < 0.1f : this.tremorzilla.m_217043_().m_188501_() > 0.1f;
        Vec3 target = this.getPosition();
        if (target == null) {
            return false;
        }
        this.x = target.f_82479_;
        this.y = target.f_82480_;
        this.z = target.f_82481_;
        return true;
    }

    public boolean m_8045_() {
        return !this.tremorzilla.m_21573_().m_26571_() && this.tremorzilla.m_20275_(this.x, this.y, this.z) > 8.0;
    }

    public void m_8056_() {
        this.tremorzilla.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
    }

    public BlockPos findWaterBlock(int range) {
        BlockPos around = this.tremorzilla.m_20183_();
        BlockPos.MutableBlockPos move = new BlockPos.MutableBlockPos();
        move.m_122169_(this.tremorzilla.m_20185_(), this.tremorzilla.m_20186_(), this.tremorzilla.m_20189_());
        while (move.m_123342_() < this.tremorzilla.m_9236_().m_151558_() && !this.tremorzilla.m_9236_().m_6425_((BlockPos)move).m_76178_()) {
            move.m_122184_(0, 1, 0);
        }
        int surfaceY = move.m_123342_();
        around = around.m_175288_(Math.min(surfaceY - 1, around.m_123342_()));
        for (int i = 0; i < 15; ++i) {
            BlockPos blockPos = around.m_7918_(this.tremorzilla.m_217043_().m_188503_(range) - range / 2, this.tremorzilla.m_217043_().m_188503_(range) - range / 2, this.tremorzilla.m_217043_().m_188503_(range) - range / 2);
            if (this.tremorzilla.m_9236_().m_6425_(blockPos).m_76178_() || this.isTargetBlocked(Vec3.m_82512_((Vec3i)blockPos)) || blockPos.m_123342_() <= this.tremorzilla.m_9236_().m_141937_() + 1) continue;
            return blockPos;
        }
        return around;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.tremorzilla.m_20185_(), this.tremorzilla.m_20188_(), this.tremorzilla.m_20189_());
        return this.tremorzilla.m_9236_().m_45547_(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.tremorzilla)).m_6662_() != HitResult.Type.MISS;
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 landTarget;
        if (this.tryLandTarget && (landTarget = LandRandomPos.m_148488_((PathfinderMob)this.tremorzilla, (int)30, (int)8)) != null) {
            return landTarget;
        }
        BlockPos water = this.findWaterBlock(20);
        if (water != null) {
            return Vec3.m_82512_((Vec3i)water);
        }
        return null;
    }
}

