/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.living.MagnetronEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MagnetronJoint;
import com.github.alexmodguy.alexscaves.server.message.MultipartEntityMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class MagnetronPartEntity
extends PartEntity<MagnetronEntity> {
    private final MagnetronJoint joint;
    private BlockPos startPosition;
    private BlockState blockState;
    private EntityDimensions size;
    public boolean left;
    public float scale = 1.0f;
    private final BlockState STONE = Blocks.f_50069_.m_49966_();

    public MagnetronPartEntity(MagnetronEntity parent, MagnetronJoint joint, boolean left) {
        super((Entity)parent);
        this.f_19850_ = true;
        this.size = EntityDimensions.m_20398_((float)0.9f, (float)0.9f);
        this.joint = joint;
        this.left = left;
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.size;
    }

    public boolean m_5825_() {
        return true;
    }

    public MagnetronJoint getJoint() {
        return this.joint;
    }

    public boolean isLeft() {
        return this.left;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        MagnetronEntity parent = (MagnetronEntity)this.getParent();
        if (parent == null) {
            return InteractionResult.PASS;
        }
        this.m_216990_(SoundEvents.f_12018_);
        if (player.m_9236_().f_46443_) {
            AlexsCaves.sendMSGToServer(new MultipartEntityMessage(parent.m_19879_(), player.m_19879_(), 0, 0.0));
        }
        return parent.m_6096_(player, hand);
    }

    public boolean m_20223_(CompoundTag tag) {
        return false;
    }

    public boolean m_5829_() {
        MagnetronEntity parent = (MagnetronEntity)this.getParent();
        return parent != null && parent.m_5829_();
    }

    public boolean m_6087_() {
        MagnetronEntity parent = (MagnetronEntity)this.getParent();
        return parent != null && parent.m_6087_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity player;
        MagnetronEntity parent = (MagnetronEntity)this.getParent();
        if (!this.m_6673_(source) && parent != null && (player = source.m_7639_()) != null && player.m_9236_().f_46443_) {
            AlexsCaves.sendMSGToServer(new MultipartEntityMessage(parent.m_19879_(), player.m_19879_(), 1, amount));
        }
        return false;
    }

    public boolean m_7306_(Entity entityIn) {
        return this == entityIn || this.getParent() == entityIn;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        throw new UnsupportedOperationException();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public boolean m_142391_() {
        return false;
    }

    public void positionMultipart(MagnetronEntity entity) {
        Vec3 targetPos = entity.m_20182_().m_82549_(this.joint.getTargetPosition(entity, this.left));
        Vec3 start = this.startPosition == null ? entity.m_20182_() : Vec3.m_82512_((Vec3i)this.startPosition);
        Vec3 addToStart = targetPos.m_82546_(start);
        this.m_146884_(start.m_82549_(addToStart.m_82490_((double)entity.getFormProgress(1.0f))));
    }

    public void setStartsAt(BlockPos pos) {
        this.startPosition = pos;
    }

    public BlockPos getStartPosition() {
        return this.startPosition;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public BlockState getVisualBlockState() {
        MagnetronEntity parent = (MagnetronEntity)this.getParent();
        return this.blockState == null && parent != null && parent.m_6084_() ? this.STONE : this.blockState;
    }

    public void setBlockState(BlockState state) {
        this.blockState = state;
    }

    public double getLowPoint() {
        return this.m_20191_().f_82289_;
    }
}

