/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.GuanoLayerBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GuanoPileFeature
extends Feature<NoneFeatureConfiguration> {
    public GuanoPileFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos.MutableBlockPos pileBottom = new BlockPos.MutableBlockPos();
        pileBottom.m_122190_((Vec3i)context.m_159777_());
        if (!level.m_8055_((BlockPos)pileBottom).m_60795_() || level.m_45527_((BlockPos)pileBottom)) {
            return false;
        }
        while (pileBottom.m_123342_() > level.m_141937_() && level.m_8055_((BlockPos)pileBottom).m_247087_()) {
            pileBottom.m_122184_(0, -1, 0);
        }
        int centerLayerHeight = 1 + randomsource.m_188503_(3);
        int radius = 3 + randomsource.m_188503_(4);
        BlockPos center = pileBottom.m_7949_().m_6630_(centerLayerHeight).m_7495_();
        BlockPos.MutableBlockPos side = new BlockPos.MutableBlockPos();
        block1: for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                float seaFloorExtra;
                double radiusSq;
                int placedLayers = 0;
                side.m_122178_(pileBottom.m_123341_() + x, pileBottom.m_123342_() + placedLayers, pileBottom.m_123343_() + z);
                while (!level.m_8055_((BlockPos)side).m_247087_() && side.m_123342_() < level.m_151558_()) {
                    side.m_122184_(0, 1, 0);
                }
                while (level.m_8055_((BlockPos)side).m_247087_() && side.m_123342_() > level.m_141937_()) {
                    side.m_122184_(0, -1, 0);
                }
                double dist = side.m_203202_((double)center.m_123341_(), (double)side.m_123342_(), (double)center.m_123343_());
                if (dist <= (radiusSq = (double)((float)radius * ((float)radius - (seaFloorExtra = (1.0f + ACMath.sampleNoise2D(side.m_123341_(), side.m_123343_(), 6.0f)) * 2.0f))))) {
                    int y = 0;
                    double invDist = 1.0 - dist / (double)((float)radiusSq);
                    while ((double)y < (double)centerLayerHeight * invDist) {
                        BlockState guanoState = ((Block)ACBlockRegistry.GUANO_LAYER.get()).m_49966_();
                        if (++y < centerLayerHeight) {
                            guanoState = (BlockState)guanoState.m_61124_((Property)GuanoLayerBlock.f_56581_, (Comparable)Integer.valueOf(8));
                        } else {
                            int j = Mth.m_14045_((int)((int)Math.round(8.0 * invDist * invDist) - randomsource.m_188503_(2)), (int)1, (int)8);
                            guanoState = (BlockState)guanoState.m_61124_((Property)GuanoLayerBlock.f_56581_, (Comparable)Integer.valueOf(j));
                        }
                        if (GuanoPileFeature.canReplace(level.m_8055_((BlockPos)side)) && !level.m_45527_(side.m_7494_()) && level.m_8055_(side.m_7495_()).m_60838_((BlockGetter)level, side.m_7495_())) {
                            level.m_7731_((BlockPos)side, guanoState, 3);
                        }
                        side.m_122184_(0, 1, 0);
                    }
                }
                if (level.m_45527_((BlockPos)side)) continue block1;
            }
        }
        return true;
    }

    private static boolean canReplace(BlockState state) {
        return (state.m_60795_() || state.m_247087_()) && !state.m_204336_(ACTagRegistry.UNMOVEABLE) && state.m_60819_().m_76178_();
    }
}

