/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.message;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SundropRainbowMessage {
    public int fromX;
    public int fromY;
    public int fromZ;
    public int toX;
    public int toY;
    public int toZ;

    public SundropRainbowMessage(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        this.fromX = fromX;
        this.fromY = fromY;
        this.fromZ = fromZ;
        this.toX = toX;
        this.toY = toY;
        this.toZ = toZ;
    }

    public SundropRainbowMessage() {
    }

    public static SundropRainbowMessage read(FriendlyByteBuf buf) {
        return new SundropRainbowMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void write(SundropRainbowMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.fromX);
        buf.writeInt(message.fromY);
        buf.writeInt(message.fromZ);
        buf.writeInt(message.toX);
        buf.writeInt(message.toY);
        buf.writeInt(message.toZ);
    }

    public static void handle(SundropRainbowMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer playerSided = ((NetworkEvent.Context)context.get()).getSender();
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                playerSided = AlexsCaves.PROXY.getClientSidePlayer();
            }
            if (playerSided.m_9236_() != null) {
                BlockPos blockPos1 = new BlockPos(message.fromX, message.fromY, message.fromZ);
                BlockPos blockPos2 = new BlockPos(message.toX, message.toY, message.toZ);
                if (playerSided.m_9236_().m_46805_(blockPos1) && playerSided.m_9236_().m_8055_(blockPos1).m_60713_((Block)ACBlockRegistry.SUNDROP.get())) {
                    playerSided.m_9236_().m_6485_((ParticleOptions)ACParticleRegistry.RAINBOW.get(), true, (double)((float)blockPos1.m_123341_() + 0.5f), (double)((float)blockPos1.m_123342_() + 0.5f), (double)((float)blockPos1.m_123343_() + 0.5f), (double)((float)blockPos2.m_123341_() + 0.5f), (double)((float)blockPos2.m_123342_() + 0.5f), (double)((float)blockPos2.m_123343_() + 0.5f));
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

