/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipelineContext;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class AzModelRenderer<T> {
    private final Matrix4f poseStateCache = new Matrix4f();
    private final Vector3f normalCache = new Vector3f();
    private final AzRendererPipeline<T> rendererPipeline;
    protected final AzLayerRenderer<T> layerRenderer;

    public AzModelRenderer(AzRendererPipeline<T> rendererPipeline, AzLayerRenderer<T> layerRenderer) {
        this.layerRenderer = layerRenderer;
        this.rendererPipeline = rendererPipeline;
    }

    protected void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        T animatable = context.animatable();
        AzBakedModel model = context.bakedModel();
        this.rendererPipeline.updateAnimatedTextureFrame(animatable);
        for (AzBone bone : model.getTopLevelBones()) {
            this.renderRecursively(context, bone, isReRender);
        }
        AzRendererConfig<T> config = this.rendererPipeline.config();
        config.renderEntry(context);
    }

    protected void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        VertexConsumer buffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        PoseStack poseStack = context.poseStack();
        poseStack.m_85836_();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, context.partialTick(), context.packedLight(), context.packedOverlay(), context.red(), context.green(), context.blue(), context.alpha())) {
            this.renderCubesOfBone(context, bone);
        }
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.m_85849_();
    }

    protected void renderCubesOfBone(AzRendererPipelineContext<T> context, AzBone bone) {
        if (bone.isHidden()) {
            return;
        }
        PoseStack poseStack = context.poseStack();
        for (GeoCube cube : bone.getCubes()) {
            poseStack.m_85836_();
            this.renderCube(context, cube);
            poseStack.m_85849_();
        }
    }

    protected void renderChildBones(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (AzBone childBone : bone.getChildBones()) {
            this.renderRecursively(context, childBone, isReRender);
        }
    }

    protected void renderCube(AzRendererPipelineContext<T> context, GeoCube cube) {
        PoseStack poseStack = context.poseStack();
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.m_85850_().m_252943_();
        Matrix4f poseState = this.poseStateCache.set((Matrix4fc)poseStack.m_85850_().m_252922_());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtils.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(context, quad, poseState, normal);
        }
    }

    protected void createVerticesOfQuad(AzRendererPipelineContext<T> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        VertexConsumer buffer = context.vertexConsumer();
        AzRendererConfig<T> config = this.rendererPipeline.config();
        int packedOverlay = context.packedOverlay();
        int packedLight = context.packedLight();
        IntIntPair boneTextureSize = context.computeTextureSize(context.getTextureOverride());
        IntIntPair entityTextureSize = context.computeTextureSize(config.textureLocation(context.animatable()));
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            if (context.getTextureOverride() != null && boneTextureSize != null && entityTextureSize != null) {
                float texU = vertex.texU() * (float)entityTextureSize.firstInt() / (float)boneTextureSize.firstInt();
                float texV = vertex.texV() * (float)entityTextureSize.secondInt() / (float)boneTextureSize.secondInt();
                context.vertexConsumer().m_5954_(vector4f.x(), vector4f.y(), vector4f.z(), context.red(), context.green(), context.blue(), context.alpha(), texU, texV, context.packedOverlay(), context.packedLight(), normal.x(), normal.y(), normal.z());
                continue;
            }
            buffer.m_5954_(vector4f.x(), vector4f.y(), vector4f.z(), context.red(), context.green(), context.blue(), context.alpha(), vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    public boolean boneRenderOverride(PoseStack poseStack, AzBone bone, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        return false;
    }

    @Nullable
    public RenderType getRenderTypeOverrideForBone(AzBone bone, T animatable, ResourceLocation texturePath, MultiBufferSource bufferSource, float partialTick) {
        return null;
    }

    @Nullable
    public ResourceLocation getTextureOverrideForBone(AzBone bone, T animatable, float partialTick) {
        return null;
    }

    public void handleAnimation(AzAnimator<T> animator, T animatable, float partialTick) {
        animator.animate(animatable, partialTick);
    }

    public VertexConsumer getOrRefreshBufferRenderType(AzItemRendererPipelineContext context, AzBone bone, RenderType renderType) {
        VertexConsumer currentBuffer = context.multiBufferSource().m_6299_(renderType);
        MultiBufferSource bufferSource = context.multiBufferSource();
        if (currentBuffer instanceof BufferBuilder) {
            BufferBuilder builder = (BufferBuilder)currentBuffer;
            if (this.isBufferInactive(builder)) {
                return bufferSource.m_6299_(renderType);
            }
        } else if (currentBuffer instanceof OutlineBufferSource.EntityOutlineGenerator) {
            OutlineBufferSource.EntityOutlineGenerator outline = (OutlineBufferSource.EntityOutlineGenerator)currentBuffer;
            if (this.needsBufferRefresh(outline.f_109936_)) {
                return new OutlineBufferSource.EntityOutlineGenerator(bufferSource.m_6299_(renderType), 255, 255, 255, 255);
            }
        } else if (currentBuffer instanceof VertexMultiConsumer.Double) {
            VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)currentBuffer;
            VertexConsumer firstBuffer = pair.f_86171_;
            VertexConsumer secondBuffer = pair.f_86172_;
            boolean firstNeedsRefresh = this.needsBufferRefresh(firstBuffer);
            boolean secondNeedsRefresh = this.needsBufferRefresh(secondBuffer);
            if (firstNeedsRefresh || secondNeedsRefresh) {
                return new VertexMultiConsumer.Double(firstNeedsRefresh ? bufferSource.m_6299_(renderType) : firstBuffer, secondNeedsRefresh ? bufferSource.m_6299_(renderType) : secondBuffer);
            }
        }
        return currentBuffer;
    }

    public VertexConsumer getOrRefreshRenderBuffer(boolean isReRender, AzRendererPipelineContext<T> context, AzBone bone) {
        AzRendererConfig<T> config = this.rendererPipeline.config();
        VertexConsumer currentBuffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        RenderType renderType = context.renderType();
        if (config.boneTextureOverrideProvider(bone) != null) {
            context.setTextureOverride(config.boneTextureOverrideProvider(bone));
        }
        ResourceLocation texture = config.boneTextureOverrideProvider(bone);
        RenderType renderTypeOverride = config.boneRenderTypeOverrideProvider(bone);
        if (texture != null && renderTypeOverride == null) {
            renderTypeOverride = context.getDefaultRenderType(context.animatable(), texture, bufferSource, context.partialTick());
        }
        if (renderTypeOverride != null) {
            currentBuffer = context.multiBufferSource().m_6299_(renderTypeOverride);
        }
        if (isReRender) {
            return currentBuffer;
        }
        if (currentBuffer instanceof BufferBuilder) {
            BufferBuilder builder = (BufferBuilder)currentBuffer;
            if (this.isBufferInactive(builder)) {
                return bufferSource.m_6299_(renderType);
            }
        } else if (currentBuffer instanceof OutlineBufferSource.EntityOutlineGenerator) {
            OutlineBufferSource.EntityOutlineGenerator outline = (OutlineBufferSource.EntityOutlineGenerator)currentBuffer;
            if (this.needsBufferRefresh(outline.f_109936_)) {
                return new OutlineBufferSource.EntityOutlineGenerator(bufferSource.m_6299_(renderType), 255, 255, 255, 255);
            }
        } else if (currentBuffer instanceof VertexMultiConsumer.Double) {
            VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)currentBuffer;
            VertexConsumer firstBuffer = pair.f_86171_;
            VertexConsumer secondBuffer = pair.f_86172_;
            boolean firstNeedsRefresh = this.needsBufferRefresh(firstBuffer);
            boolean secondNeedsRefresh = this.needsBufferRefresh(secondBuffer);
            if (firstNeedsRefresh || secondNeedsRefresh) {
                return new VertexMultiConsumer.Double(firstNeedsRefresh ? bufferSource.m_6299_(renderType) : firstBuffer, secondNeedsRefresh ? bufferSource.m_6299_(renderType) : secondBuffer);
            }
        }
        return currentBuffer;
    }

    protected boolean needsBufferRefresh(VertexConsumer buffer) {
        if (buffer instanceof BufferBuilder) {
            BufferBuilder builder = (BufferBuilder)buffer;
            return this.isBufferInactive(builder);
        }
        if (buffer instanceof OutlineBufferSource.EntityOutlineGenerator) {
            OutlineBufferSource.EntityOutlineGenerator outline = (OutlineBufferSource.EntityOutlineGenerator)buffer;
            return this.needsBufferRefresh(outline.f_109936_);
        }
        if (buffer instanceof VertexMultiConsumer.Double) {
            VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)buffer;
            return this.needsBufferRefresh(pair.f_86171_) || this.needsBufferRefresh(pair.f_86172_);
        }
        return false;
    }

    protected boolean isBufferInactive(BufferBuilder builder) {
        return !builder.f_85661_;
    }
}

