/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.betterlockon.client.control;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.shelmarow.betterlockon.config.LockOnConfig;
import net.shelmarow.betterlockon.mixins.LocalPlayerPatchAccessor;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSetPlayerTarget;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@Mod.EventBusSubscriber(modid="betterlockon", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class LockOnControl {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static int startTick = 0;
    private static double lastMouseX = 0.0;
    private static double lastMouseY = 0.0;
    private static double deltaMouseX = 0.0;
    private static double movedDistance = 0.0;
    private static double lastMovedDistanceX = 0.0;
    private static double lastMovedDistanceY = 0.0;
    private static final int maxCoolDown = 1;
    private static int cooldownRemaining = 0;

    @SubscribeEvent
    public static void movementInputUpdateEvent(MovementInputUpdateEvent event) {
        Input input = event.getInput();
        LocalPlayerPatch playerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (Minecraft.m_91087_().f_91066_.f_92091_.m_90857_() && !Minecraft.m_91087_().f_91066_.f_92095_.m_90857_() && playerPatch != null && playerPatch.isTargetLockedOn()) {
            if (input.f_108567_ < 0.0f) {
                input.f_108567_ = -input.f_108567_;
            }
            if (Math.abs(input.f_108566_) > 0.0f) {
                input.f_108567_ = Math.abs(input.f_108566_);
                input.f_108566_ = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient() && LockOnControl.MC.f_91080_ == null && LockOnControl.MC.f_91074_ != null && event.player == LockOnControl.MC.f_91074_ && LockOnControl.MC.f_91073_ != null && event.phase == TickEvent.Phase.START) {
            LocalPlayerPatch playerPatch;
            if (cooldownRemaining > 0) {
                --cooldownRemaining;
                lastMouseX = LockOnControl.MC.f_91067_.m_91589_();
                return;
            }
            double currentMouseX = LockOnControl.MC.f_91067_.m_91589_();
            double distanceX = currentMouseX - lastMouseX;
            double currentDeltaMouseX = distanceX == 0.0 ? 0.0 : (double)(distanceX > 0.0 ? 1 : -1);
            lastMovedDistanceX += Mth.m_14175_((double)(distanceX / 30.0));
            double currentMouseY = LockOnControl.MC.f_91067_.m_91594_();
            double distanceY = currentMouseY - lastMouseY;
            lastMovedDistanceY += Mth.m_14175_((double)(distanceY / 30.0));
            double mouseSpeed = (movedDistance += Math.abs(distanceX)) / (double)(LockOnControl.MC.f_91074_.f_19797_ - startTick + 1);
            double changeDistance = (Double)LockOnConfig.LOCK_ON_CHANGE_DISTANCE.get();
            double minMoveSpeed = (Double)LockOnConfig.LOCK_ON_MIN_MOUSE_SPEED.get();
            double maxSoftAngleX = (Double)LockOnConfig.MAX_SOFT_ANGLE_X.get();
            double maxSoftAngleY = (Double)LockOnConfig.MAX_SOFT_ANGLE_Y.get();
            double md = (Double)LockOnConfig.CHANGE_DISTANCE_MULTIPLY.get();
            double ms = (Double)LockOnConfig.CHANGE_SPEED_MULTIPLY.get();
            if (((Boolean)LockOnConfig.ENABLE_SOFT_LOCK.get()).booleanValue()) {
                minMoveSpeed *= ms;
                changeDistance *= md;
            }
            if (lastMovedDistanceX > 0.0) {
                lastMovedDistanceX = Mth.m_14008_((double)lastMovedDistanceX, (double)0.0, (double)(maxSoftAngleX / 2.0));
            } else if (lastMovedDistanceX < 0.0) {
                lastMovedDistanceX = Mth.m_14008_((double)lastMovedDistanceX, (double)(-maxSoftAngleX / 2.0), (double)0.0);
            }
            if (lastMovedDistanceY > 0.0) {
                lastMovedDistanceY = Mth.m_14008_((double)lastMovedDistanceY, (double)0.0, (double)(maxSoftAngleY / 2.0));
            } else if (lastMovedDistanceY < 0.0) {
                lastMovedDistanceY = Mth.m_14008_((double)lastMovedDistanceY, (double)(-maxSoftAngleY / 2.0), (double)0.0);
            }
            if (currentMouseX == lastMouseX || deltaMouseX != 0.0 && currentDeltaMouseX != deltaMouseX || mouseSpeed < minMoveSpeed) {
                movedDistance = 0.0;
                startTick = LockOnControl.MC.f_91074_.f_19797_;
            }
            if ((playerPatch = (LocalPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)LockOnControl.MC.f_91074_, LocalPlayerPatch.class)) != null && playerPatch.isTargetLockedOn()) {
                if (movedDistance >= changeDistance) {
                    LockOnControl.triggerTargetChange(LockOnControl.MC.f_91073_, currentDeltaMouseX);
                    movedDistance = 0.0;
                    cooldownRemaining = 1;
                }
            } else {
                movedDistance = 0.0;
            }
            deltaMouseX = currentDeltaMouseX;
            lastMouseX = currentMouseX;
            lastMouseY = currentMouseY;
        }
    }

    public static float getLastMovedDistanceX() {
        return (float)lastMovedDistanceX;
    }

    public static void setLastMovedDistanceX(float distance) {
        lastMovedDistanceX = distance;
    }

    public static float getLastMovedDistanceY() {
        return (float)lastMovedDistanceY;
    }

    public static void setLastMovedDistanceY(double lastMovedDistanceY) {
        LockOnControl.lastMovedDistanceY = lastMovedDistanceY;
    }

    private static void triggerTargetChange(ClientLevel level, double deltaMouseX) {
        LivingEntity target;
        LocalPlayerPatch playerPatch = (LocalPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)LockOnControl.MC.f_91074_, LocalPlayerPatch.class);
        if (playerPatch != null && (target = playerPatch.getTarget()) != null && target.m_6084_()) {
            List<LivingEntity> targetList = LockOnControl.entitiesCanBeSeen(LockOnControl.MC.f_91074_, level, target, deltaMouseX);
            LivingEntity changedTarget = LockOnControl.selectBestTarget(LockOnControl.MC.f_91074_, targetList, target);
            LocalPlayerPatchAccessor accessor = (LocalPlayerPatchAccessor)playerPatch;
            if (changedTarget != null) {
                Vec3 playerPosition = LockOnControl.MC.f_91074_.m_146892_();
                Vec3 targetPosition = changedTarget.m_146892_();
                Vec3 toTarget = targetPosition.m_82546_(playerPosition);
                float yaw = (float)MathUtils.getYRotOfVector((Vec3)toTarget);
                float pitch = (float)MathUtils.getXRotOfVector((Vec3)toTarget);
                Vec3 preTargetPosition = target.m_146892_();
                Vec3 toPreTarget = preTargetPosition.m_82546_(playerPosition);
                float deltaYaw = (float)((double)(yaw - (float)MathUtils.getYRotOfVector((Vec3)toPreTarget)) - lastMovedDistanceX);
                float deltaPitch = (float)((double)(pitch - (float)MathUtils.getXRotOfVector((Vec3)toPreTarget)) - lastMovedDistanceY);
                double maxSoftAngleX = (Double)LockOnConfig.MAX_SOFT_ANGLE_X.get();
                double maxSoftAngleY = (Double)LockOnConfig.MAX_SOFT_ANGLE_Y.get();
                if ((double)deltaYaw >= -maxSoftAngleX / 2.0 && (double)deltaYaw <= maxSoftAngleX / 2.0) {
                    lastMovedDistanceX = (double)(-deltaYaw) - ((double)deltaYaw > maxSoftAngleX / 2.0 ? lastMovedDistanceX : 0.0);
                }
                if (deltaYaw > 0.0f && (double)deltaYaw > maxSoftAngleX / 2.0) {
                    lastMovedDistanceX = maxSoftAngleX / 2.0;
                } else if (deltaYaw < 0.0f && (double)deltaYaw < -maxSoftAngleX / 2.0) {
                    lastMovedDistanceX = -maxSoftAngleX / 2.0;
                }
                if ((double)deltaPitch >= -maxSoftAngleY / 2.0 && (double)deltaPitch <= maxSoftAngleY / 2.0) {
                    lastMovedDistanceY = (double)(-deltaPitch) - ((double)deltaPitch > maxSoftAngleY / 2.0 ? lastMovedDistanceY : 0.0);
                } else if (deltaPitch > 0.0f && (double)deltaPitch > maxSoftAngleY / 2.0) {
                    lastMovedDistanceY = -maxSoftAngleY / 2.0;
                } else if (deltaPitch < 0.0f && (double)deltaPitch < -maxSoftAngleY / 2.0) {
                    lastMovedDistanceY = maxSoftAngleY / 2.0;
                }
                accessor.setRayTarget(changedTarget);
                EpicFightNetworkManager.sendToServer((Object)new CPSetPlayerTarget(changedTarget.m_19879_()));
                playerPatch.setLockOn(true);
            }
        }
    }

    public static LivingEntity selectBestTarget(LocalPlayer player, List<LivingEntity> candidates, LivingEntity currentTarget) {
        if (candidates.isEmpty()) {
            return null;
        }
        double standDistanceSqr = 100.0;
        if (currentTarget != null) {
            standDistanceSqr = player.m_20280_((Entity)currentTarget);
        }
        LivingEntity bestTarget = null;
        double bestWeight = Double.NEGATIVE_INFINITY;
        for (LivingEntity entity : candidates) {
            double weight = LockOnControl.getWeight(player, entity, standDistanceSqr);
            if (!(weight > bestWeight)) continue;
            bestWeight = weight;
            bestTarget = entity;
        }
        return bestTarget;
    }

    public static double getWeight(LocalPlayer player, LivingEntity entity, double standDistanceSqr) {
        Vec3 playerPos = player.m_20182_();
        Vec3 lookDir = player.m_20154_().m_82541_();
        Vec3 toTarget = entity.m_20182_().m_82546_(playerPos).m_82541_();
        double dot = lookDir.m_82526_(toTarget);
        dot = Math.max(-1.0, Math.min(1.0, dot));
        double angleDegrees = Math.toDegrees(Math.acos(dot));
        double distanceSqr = playerPos.m_82557_(entity.m_20182_());
        double totalWeight = 200.0;
        totalWeight -= angleDegrees * 0.5;
        if (distanceSqr > standDistanceSqr) {
            double diff = Math.sqrt(distanceSqr) - Math.sqrt(standDistanceSqr);
            totalWeight -= diff * 2.0;
        }
        return totalWeight;
    }

    public static List<LivingEntity> entitiesCanBeSeen(LocalPlayer player, ClientLevel level, LivingEntity target, double deltaMouseX) {
        Frustum frustum = LockOnControl.MC.f_91060_.getFrustum();
        ArrayList<LivingEntity> livingEntities = new ArrayList<LivingEntity>();
        for (Entity entity : level.m_104735_()) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !LockOnControl.canBeSeenAsTarget(frustum, player, livingEntity = (LivingEntity)entity, target, level, deltaMouseX)) continue;
            livingEntities.add(livingEntity);
        }
        return livingEntities;
    }

    private static boolean canBeSeenAsTarget(Frustum frustum, LocalPlayer player, LivingEntity entity, LivingEntity target, ClientLevel level, double deltaMouseX) {
        int delta = LockOnControl.getEntitySide(player, (Entity)entity);
        double maxRange = (Double)LockOnConfig.MAX_TARGET_SELECT_DISTANCE.get();
        double distanceSqr = player.m_20280_((Entity)entity);
        List whiteList = (List)LockOnConfig.WHITE_LIST.get();
        List blackList = (List)LockOnConfig.BLACK_LIST.get();
        String id = "";
        @Nullable ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (key != null) {
            id = key.toString();
        }
        if (target != null && entity.m_20148_().equals(target.m_20148_())) {
            return false;
        }
        if (!entity.m_6084_()) {
            return false;
        }
        if (entity.m_20177_((Player)player)) {
            return false;
        }
        if (entity.m_20148_().equals(player.m_20148_())) {
            return false;
        }
        if (distanceSqr >= maxRange * maxRange) {
            return false;
        }
        if (!frustum.m_113029_(entity.m_20191_())) {
            return false;
        }
        if (!LockOnControl.isUnobstructed(level, (Entity)entity)) {
            return false;
        }
        if (deltaMouseX != 0.0 && (double)delta != deltaMouseX) {
            return false;
        }
        if (player.m_20202_() != null && entity == player.m_20202_()) {
            return false;
        }
        if (whiteList.contains(id)) {
            return true;
        }
        if (blackList.contains(id)) {
            return false;
        }
        if (entity instanceof Mob || entity instanceof Player) {
            return player.m_21040_(entity, TargetingConditions.m_148352_());
        }
        return false;
    }

    private static int getEntitySide(LocalPlayer player, Entity entity) {
        Vec3 playerPos = player.m_20182_();
        Vec3 lookDir = player.m_20154_();
        Vec3 toTarget = entity.m_20182_().m_82546_(playerPos).m_82541_();
        Vec3 cross = lookDir.m_82537_(toTarget);
        if (cross.f_82480_ >= 0.0) {
            return -1;
        }
        return 1;
    }

    private static boolean isUnobstructed(ClientLevel level, Entity entity) {
        Vec3 targetPos;
        if (LockOnControl.MC.f_91074_ == null) {
            return false;
        }
        Camera camera = LockOnControl.MC.f_91063_.m_109153_();
        Vec3 startPos = LockOnControl.MC.f_91074_.m_146892_();
        ClipContext blockContext = new ClipContext(startPos, targetPos = entity.m_146892_(), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)LockOnControl.MC.f_91074_);
        BlockHitResult blockHit = level.m_45547_(blockContext);
        if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
            return false;
        }
        EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)level, (Entity)LockOnControl.MC.f_91074_, (Vec3)startPos, (Vec3)targetPos, (AABB)new AABB(startPos, targetPos).m_82400_(0.05), e -> e != LockOnControl.MC.f_91074_ && e.m_6084_() && !e.m_20177_((Player)LockOnControl.MC.f_91074_));
        if (entityHit == null) {
            return true;
        }
        return entityHit.m_82443_() == entity;
    }
}

