/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.betterlockon.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.shelmarow.betterlockon.client.render.LockOnRenderTypes;
import net.shelmarow.betterlockon.client.render.icon.IconTypeManager;
import net.shelmarow.betterlockon.client.render.icon.type.IconType;
import net.shelmarow.betterlockon.config.LockOnConfig;
import net.shelmarow.combat_evolution.ai.CEHumanoidPatch;
import net.shelmarow.combat_evolution.iml.ILivingEntityData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

@OnlyIn(value=Dist.CLIENT)
public class LockOnRenderer
extends EntityUI {
    private static float healthRatio = 1.0f;
    private static float staminaRatio = 0.0f;

    public boolean shouldDraw(LivingEntity entity, @Nullable LivingEntityPatch<?> livingEntityPatch, LocalPlayerPatch playerpatch, float v) {
        LivingEntity target = playerpatch.getTarget();
        if (playerpatch.isTargetLockedOn() && entity == target && !entity.m_21224_()) {
            healthRatio = target.m_21223_() / target.m_21233_();
            staminaRatio = 0.0f;
            boolean hasStamina = false;
            if (livingEntityPatch instanceof PlayerPatch) {
                PlayerPatch targetPlayer = (PlayerPatch)livingEntityPatch;
                staminaRatio = targetPlayer.getStamina() / targetPlayer.getMaxStamina();
                hasStamina = true;
            }
            if (!hasStamina && ModList.get().isLoaded("combat_evolution") && livingEntityPatch instanceof CEHumanoidPatch) {
                CEHumanoidPatch ceHumanoidPatch = (CEHumanoidPatch)livingEntityPatch;
                ILivingEntityData entityData = (ILivingEntityData)ceHumanoidPatch;
                LivingEntity original = (LivingEntity)livingEntityPatch.getOriginal();
                if (original.m_21204_().m_22171_((Attribute)EpicFightAttributes.MAX_STAMINA.get())) {
                    staminaRatio = (float)((double)entityData.combat_evolution$getStamina(original) / original.m_21133_((Attribute)EpicFightAttributes.MAX_STAMINA.get()));
                    hasStamina = true;
                }
            }
            if (!hasStamina && ModList.get().isLoaded("indestructible") && livingEntityPatch instanceof IAdvancedCapability) {
                IAdvancedCapability capability = (IAdvancedCapability)livingEntityPatch;
                staminaRatio = capability.getStamina() / capability.getMaxStamina();
                hasStamina = true;
            }
            if (!hasStamina && livingEntityPatch != null) {
                staminaRatio = livingEntityPatch.getStunShield() / livingEntityPatch.getMaxStunShield();
                hasStamina = true;
            }
            return true;
        }
        return false;
    }

    public void draw(LivingEntity entity, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, PoseStack poseStack, MultiBufferSource buffers, float partialTicks) {
        Matrix4f matrix = this.getModelViewMatrixAlignedToCamera(poseStack, entity, 0.0f, entity.m_20206_() * 2.0f / 3.0f, 0.0f, true, partialTicks);
        float baseSize = (float)((Double)LockOnConfig.LOCK_ON_ICON_SIZE.get()).doubleValue();
        float size = (Boolean)LockOnConfig.LOCK_ON_SIZE_SCALING.get() != false ? this.calculateAdjustedIconSize(baseSize, entity) : baseSize;
        float r = (float)((Double)LockOnConfig.LOCK_ON_RED.get()).doubleValue();
        float g = (float)((Double)LockOnConfig.LOCK_ON_GREEN.get()).doubleValue();
        float b = (float)((Double)LockOnConfig.LOCK_ON_BLUE.get()).doubleValue();
        float a = (float)((Double)LockOnConfig.LOCK_ON_ALPHA.get()).doubleValue();
        this.renderLockOn(buffers, matrix, size / 2.0f, -size / 2.0f, r, g, b, a);
    }

    private float calculateAdjustedIconSize(float baseSize, LivingEntity entity) {
        float entityWidth = entity.m_20205_();
        float entityHeight = entity.m_20206_();
        float entitySizeFactor = Math.max(entityWidth, entityHeight);
        float STANDARD_ENTITY_SIZE = 1.0f;
        if (entitySizeFactor <= 1.0f) {
            return baseSize;
        }
        float scaleFactor = 1.0f + (float)Math.log1p(entitySizeFactor - 1.0f) * 0.5f;
        float MAX_SCALE = 2.0f;
        scaleFactor = Math.min(scaleFactor, 2.0f);
        return baseSize * scaleFactor;
    }

    private void renderLockOn(MultiBufferSource buffers, Matrix4f matrix, float max, float min, float r, float g, float b, float alpha) {
        float v;
        float u;
        float y;
        float x;
        float sin;
        float cos;
        float angle;
        int i;
        VertexConsumer vc;
        IconType iconType = IconTypeManager.getIconTypeOrDefault((String)LockOnConfig.LOCK_ON_ICON_TYPES.get());
        if (iconType.getBackground() != null) {
            vc = buffers.m_6299_(LockOnRenderTypes.getLockOnQuads(iconType.getBackground()));
            vc.m_252986_(matrix, min, min, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
            vc.m_252986_(matrix, max, min, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
            vc.m_252986_(matrix, max, max, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            vc.m_252986_(matrix, min, max, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        }
        int segments = 100;
        if (iconType.getHealth() != null) {
            vc = buffers.m_6299_(LockOnRenderTypes.getLockOnTriangleFan(iconType.getHealth()));
            vc.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.5f, 0.5f).m_85950_(r, g, b, alpha).m_5752_();
            for (i = 0; i <= segments; ++i) {
                float progress = (float)i / (float)segments;
                angle = iconType.reverse() ? (float)(iconType.getHealthStartAngle() + (double)healthRatio * iconType.getHealthTotalAngle() * (double)progress) : (float)(iconType.getHealthStartAngle() - (double)healthRatio * iconType.getHealthTotalAngle() * (double)progress);
                cos = (float)Math.cos(angle);
                sin = (float)Math.sin(angle);
                x = cos * max;
                y = sin * max;
                u = 0.5f + cos * 0.5f;
                v = 0.5f - sin * 0.5f;
                vc.m_252986_(matrix, x, y, 0.0f).m_7421_(u, v).m_85950_(r, g, b, alpha).m_5752_();
            }
        }
        if (iconType.getStamina() != null) {
            vc = buffers.m_6299_(LockOnRenderTypes.getLockOnTriangleFan(iconType.getStamina()));
            vc.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.5f, 0.5f).m_85950_(r, g, b, alpha).m_5752_();
            for (i = 0; i <= segments; ++i) {
                float sweep = (float)(Math.PI * (double)staminaRatio);
                angle = (float)(-1.5707963267948966 - (double)(sweep / 2.0f) + (double)(sweep * (float)i / (float)segments));
                cos = (float)Math.cos(angle);
                sin = (float)Math.sin(angle);
                x = cos * max;
                y = sin * max;
                u = 0.5f + cos * 0.5f;
                v = 0.5f - sin * 0.5f;
                vc.m_252986_(matrix, x, y, 0.0f).m_7421_(u, v).m_85950_(r, g, b, alpha).m_5752_();
            }
        }
        if (iconType.getOverlay() != null) {
            vc = buffers.m_6299_(LockOnRenderTypes.getLockOnQuads(iconType.getOverlay()));
            vc.m_252986_(matrix, min, min, 0.0f).m_7421_(0.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
            vc.m_252986_(matrix, max, min, 0.0f).m_7421_(1.0f, 1.0f).m_85950_(r, g, b, alpha).m_5752_();
            vc.m_252986_(matrix, max, max, 0.0f).m_7421_(1.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
            vc.m_252986_(matrix, min, max, 0.0f).m_7421_(0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        }
    }
}

